/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

@Singleton
public class CreateNodesWithGroupEncodedIntoNameThenAddToSet
implements CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy;
    protected final ListNodesStrategy listNodesStrategy;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final ListeningExecutorService userExecutor;
    protected final CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;

    @Inject
    protected CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory) {
        this.addNodeWithGroupStrategy = addNodeWithGroupStrategy;
        this.listNodesStrategy = listNodesStrategy;
        this.namingConvention = namingConvention;
        this.userExecutor = userExecutor;
        this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory = customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
    }

    @Override
    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (String name : this.getNextNames(group, template, count)) {
            responses.put(name, Futures.transform(this.createNodeInGroupWithNameAndTemplate(group, name, template), this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory.create(template.getOptions(), goodNodes, badNodes, customizationResponses), (Executor)this.userExecutor));
        }
        return responses;
    }

    protected ListenableFuture<AtomicReference<NodeMetadata>> createNodeInGroupWithNameAndTemplate(String group, String name, Template template) {
        return this.userExecutor.submit((Callable)new AddNode(name, group, template));
    }

    protected Set<String> getNextNames(String group, Template template, int count) {
        LinkedHashSet names = Sets.newLinkedHashSet();
        Set<String> nodeNames = template.getOptions().getNodeNames();
        if (nodeNames.size() >= count) {
            return ImmutableSet.copyOf((Iterable)Iterables.limit(nodeNames, (int)count));
        }
        names.addAll(nodeNames);
        Iterable<? extends ComputeMetadata> currentNodes = this.listNodesStrategy.listNodes();
        int maxTries = 100;
        int currentTries = 0;
        while (names.size() < count && currentTries++ < maxTries) {
            final String name = this.namingConvention.createWithoutPrefix().uniqueNameForGroup(group);
            if (Iterables.any(currentNodes, (Predicate)new Predicate<ComputeMetadata>(){

                public boolean apply(ComputeMetadata input) {
                    return name.equals(input.getName());
                }
            })) continue;
            names.add(name);
        }
        return names;
    }

    protected class AddNode
    implements Callable<AtomicReference<NodeMetadata>> {
        private final String name;
        private final String group;
        private final Template template;

        public AddNode(String name, String group, Template template) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.group = (String)Preconditions.checkNotNull((Object)group, (Object)"group");
            this.template = (Template)Preconditions.checkNotNull((Object)template, (Object)"template");
        }

        @Override
        public AtomicReference<NodeMetadata> call() throws Exception {
            NodeMetadata node = null;
            CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.debug(">> adding node location(%s) name(%s) image(%s) hardware(%s)", new Object[]{this.template.getLocation().getId(), this.name, Objects.firstNonNull((Object)this.template.getImage().getProviderId(), (Object)this.template.getImage().getId()), Objects.firstNonNull((Object)this.template.getHardware().getProviderId(), (Object)this.template.getHardware().getId())});
            node = CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.addNodeWithGroupStrategy.createNodeWithGroupEncodedIntoName(this.group, this.name, this.template);
            CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.debug("<< %s node(%s)", new Object[]{ComputeServiceUtils.formatStatus(node), node.getId()});
            return new AtomicReference<NodeMetadata>(node);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("group", (Object)this.group).add("template", (Object)this.template).toString();
        }
    }
}

