/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.util;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.regex.Pattern;

public class Passwords {
    private static final Random random = new Random();
    private static final int MIN_CHAR = 8;
    private static final int MAX_CHAR = 50;
    private static final String PASSWORD_FORMAT = String.format("[a-zA-Z0-9][^iIloOwWyYzZ10]{%d,%d}", 7, 50);
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(PASSWORD_FORMAT);
    private static final ImmutableSet<Character> INVALID_CHARS = ImmutableSet.of((Object)Character.valueOf('i'), (Object)Character.valueOf('I'), (Object)Character.valueOf('l'), (Object)Character.valueOf('o'), (Object)Character.valueOf('O'), (Object)Character.valueOf('w'), (Object[])new Character[]{Character.valueOf('W'), Character.valueOf('y'), Character.valueOf('Y'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('1'), Character.valueOf('0')});

    public static boolean isValidPassword(String password) {
        return PASSWORD_PATTERN.matcher(password).matches();
    }

    public static String generate() {
        int count = random.nextInt(42) + 8;
        char[] buffer = new char[count];
        int start = 65;
        int end = 122;
        int gap = 58;
        while (count-- != 0) {
            char ch = (char)(random.nextInt(58) + 65);
            if ((Passwords.isBetween(ch, 65, 90) || Passwords.isBetween(ch, 97, 122)) && !INVALID_CHARS.contains((Object)Character.valueOf(ch))) {
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    private static boolean isBetween(char ch, int start, int end) {
        return ch >= start && ch <= end;
    }
}

