/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.rest.domain.HasName;

public class SensorSummary
implements HasName,
Serializable {
    private static final long serialVersionUID = 1154308408351165426L;
    private final String name;
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String description;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public SensorSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SensorSummary)) {
            return false;
        }
        SensorSummary that = (SensorSummary)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.links);
    }

    public String toString() {
        return "SensorSummary{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", description='" + this.description + '\'' + ", links=" + this.links + '}';
    }
}

