/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.rest.domain.HasId;
import org.apache.brooklyn.rest.domain.HasName;

public class EntitySummary
implements HasId,
HasName,
Serializable {
    private static final long serialVersionUID = 100490507982229165L;
    private final String id;
    private final String name;
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String catalogItemId;
    private final Map<String, URI> links;

    public EntitySummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="catalogItemId") String catalogItemId, @JsonProperty(value="links") Map<String, URI> links) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.catalogItemId = catalogItemId;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntitySummary)) {
            return false;
        }
        EntitySummary that = (EntitySummary)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.catalogItemId, that.catalogItemId) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.catalogItemId, this.links);
    }

    public String toString() {
        return "EntitySummary{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", catalogItemId='" + this.catalogItemId + '\'' + ", links=" + this.links + '}';
    }
}

