/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.brooklyn.rest.domain.EntitySpec;
import org.apache.brooklyn.rest.domain.HasName;

public class ApplicationSpec
implements HasName,
Serializable {
    private static final long serialVersionUID = -7090404504233835343L;
    private final String name;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Set<EntitySpec> entities;
    private final Set<String> locations;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    private final Map<String, String> config;

    public static Builder builder() {
        return new Builder();
    }

    public ApplicationSpec(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="entities") Set<EntitySpec> entities, @JsonProperty(value="locations") Collection<String> locations, @JsonProperty(value="config") Map<String, String> config) {
        this.name = name;
        this.type = type;
        this.entities = entities == null ? null : (entities.isEmpty() && type != null ? null : ImmutableSet.copyOf(entities));
        this.locations = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(locations, (Object)"locations must be provided for an application spec")));
        ImmutableMap immutableMap = this.config = config == null ? Collections.emptyMap() : ImmutableMap.copyOf(config);
        if (this.entities != null && this.type != null) {
            throw new IllegalStateException("cannot supply both type and entities for an application spec");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Set<EntitySpec> getEntities() {
        return this.entities;
    }

    public Set<String> getLocations() {
        return this.locations;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationSpec)) {
            return false;
        }
        ApplicationSpec that = (ApplicationSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.entities, that.entities) && Objects.equals(this.locations, that.locations) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.entities, this.locations, this.config);
    }

    public String toString() {
        return "ApplicationSpec{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", entities=" + this.entities + ", locations=" + this.locations + ", config=" + this.config + '}';
    }

    public static class Builder {
        private String name;
        private String type;
        private Set<EntitySpec> entities;
        private Set<String> locations;
        private Map<String, String> config;

        public Builder from(ApplicationSpec spec) {
            this.name = spec.name;
            this.entities = spec.entities;
            this.locations = spec.locations;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder entities(Set<EntitySpec> entities) {
            this.entities = entities;
            return this;
        }

        public Builder locations(Set<String> locations) {
            this.locations = locations;
            return this;
        }

        public Builder config(Map<String, String> config) {
            this.config = config;
            return this;
        }

        public ApplicationSpec build() {
            return new ApplicationSpec(this.name, this.type, this.entities, this.locations, this.config);
        }
    }
}

