/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.enricher;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.policy.enricher.RollingTimeWindowMeanEnricher;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.AtomicReferences;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.math.MathFunctions;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="HTTP Latency Detector", description="Computes latency in accessing a URL, normally by periodically polling that URL")
public class HttpLatencyDetector
extends AbstractEnricher
implements Enricher {
    private static final Logger log = LoggerFactory.getLogger(HttpLatencyDetector.class);
    public static final Duration LATENCY_WINDOW_DEFAULT_PERIOD = Duration.TEN_SECONDS;
    @SetFromFlag(value="url")
    public static final ConfigKey<?> URL = ConfigKeys.newStringConfigKey((String)"latencyDetector.url");
    @SetFromFlag(value="urlSensor")
    public static final ConfigKey<AttributeSensor<?>> URL_SENSOR = ConfigKeys.newConfigKey((TypeToken)new TypeToken<AttributeSensor<?>>(){}, (String)"latencyDetector.urlSensor");
    @SetFromFlag(value="urlPostProcessing")
    public static final ConfigKey<Function<String, String>> URL_POST_PROCESSING = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Function<String, String>>(){}, (String)"latencyDetector.urlPostProcessing", (String)"Function applied to the urlSensor value, to determine the URL to use");
    @SetFromFlag(value="rollup")
    public static final ConfigKey<Duration> ROLLUP_WINDOW_SIZE = ConfigKeys.newConfigKey(Duration.class, (String)"latencyDetector.rollup");
    @SetFromFlag(value="requireServiceUp")
    public static final ConfigKey<Boolean> REQUIRE_SERVICE_UP = ConfigKeys.newBooleanConfigKey((String)"latencyDetector.requireServiceUp");
    @SetFromFlag(value="period")
    public static final ConfigKey<Duration> PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"latencyDetector.period");
    public static final AttributeSensor<Double> REQUEST_LATENCY_IN_SECONDS_MOST_RECENT = Sensors.newDoubleSensor((String)"web.request.latency.last", (String)"Request latency of most recent call, in seconds");
    public static final AttributeSensor<Double> REQUEST_LATENCY_IN_SECONDS_IN_WINDOW = Sensors.newDoubleSensor((String)"web.request.latency.windowed", (String)"Request latency over time window, in seconds");
    final AtomicBoolean serviceUp = new AtomicBoolean(false);
    final AtomicReference<String> url = new AtomicReference();
    HttpFeed httpFeed = null;

    public HttpLatencyDetector() {
    }

    protected HttpLatencyDetector(Map<?, ?> flags) {
        super(flags);
    }

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.initialize();
        this.startSubscriptions(entity);
        this.activateAdditionalEnrichers(entity);
        if (log.isDebugEnabled()) {
            log.debug("" + (Object)((Object)this) + " enabled=" + this.computeEnablement() + " when attached, subscribing to " + this.getAllSubscriptions());
        }
        this.updateEnablement();
    }

    protected void initialize() {
        Preconditions.checkState((boolean)(this.getConfig(URL) != null ^ this.getConfig(URL_SENSOR) != null), (String)"Must set exactly one of url or urlSensor: url=%s; urlSensor=%s", (Object[])new Object[]{this.getConfig(URL), this.getConfig(URL_SENSOR)});
        Preconditions.checkState((this.getConfig(URL_SENSOR) != null || this.getConfig(URL_POST_PROCESSING) == null ? 1 : 0) != 0, (Object)"Must not set urlPostProcessing without urlSensor");
        Object configValue = this.getConfig(URL);
        if (configValue != null) {
            this.url.set(configValue.toString());
        }
        this.httpFeed = HttpFeed.builder().entity((Entity)this.entity).period((Duration)this.getConfig(PERIOD)).baseUri(Suppliers.compose((Function)Urls.stringToUriFunction(), (Supplier)AtomicReferences.supplier(this.url))).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(REQUEST_LATENCY_IN_SECONDS_MOST_RECENT).onResult(MathFunctions.divide((Function)HttpValueFunctions.latency(), (double)1000.0))).setOnException(null)).suspended().build();
        if (this.getUniqueTag() == null) {
            this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + (this.getConfig(URL) != null ? this.getConfig(URL) : this.getConfig(URL_SENSOR));
        }
    }

    protected void startSubscriptions(EntityLocal entity) {
        AttributeSensor urlSensor;
        if (((Boolean)this.getConfig(REQUIRE_SERVICE_UP)).booleanValue()) {
            this.subscriptions().subscribe((Entity)entity, (Sensor)Startable.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

                public void onEvent(SensorEvent<Boolean> event) {
                    if (AtomicReferences.setIfDifferent((AtomicBoolean)HttpLatencyDetector.this.serviceUp, (boolean)Boxing.unboxSafely((Boolean)((Boolean)event.getValue()), (boolean)false))) {
                        log.debug("" + this + " updated on " + event + ", enabled=" + HttpLatencyDetector.this.computeEnablement());
                        HttpLatencyDetector.this.updateEnablement();
                    }
                }
            });
            Boolean currentVal = (Boolean)entity.getAttribute(Startable.SERVICE_UP);
            if (currentVal != null) {
                AtomicReferences.setIfDifferent((AtomicBoolean)this.serviceUp, (boolean)currentVal);
            }
        }
        if ((urlSensor = (AttributeSensor)this.getConfig(URL_SENSOR)) != null) {
            this.subscriptions().subscribe((Entity)entity, (Sensor)urlSensor, (SensorEventListener)new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    String newVal;
                    Function postProcessor = (Function)HttpLatencyDetector.this.getConfig(URL_POST_PROCESSING);
                    String val = event.getValue().toString();
                    String string = newVal = postProcessor != null ? (String)postProcessor.apply((Object)val) : val;
                    if (AtomicReferences.setIfDifferent(HttpLatencyDetector.this.url, (Object)newVal)) {
                        log.debug("" + this + " updated on " + event + ", enabled=" + HttpLatencyDetector.this.computeEnablement());
                        HttpLatencyDetector.this.updateEnablement();
                    }
                }
            });
            Object currentVal = entity.getAttribute(urlSensor);
            if (currentVal != null) {
                String newVal;
                Function postProcessor = (Function)this.getConfig(URL_POST_PROCESSING);
                String string = newVal = postProcessor != null ? (String)postProcessor.apply((Object)currentVal.toString()) : currentVal.toString();
                if (AtomicReferences.setIfDifferent(this.url, (Object)newVal)) {
                    log.debug("{} updated url on initial connectionon, to {}", (Object)this, (Object)newVal);
                }
            }
        }
    }

    protected void activateAdditionalEnrichers(EntityLocal entity) {
        Duration rollupWindowSize = (Duration)this.getConfig(ROLLUP_WINDOW_SIZE);
        if (rollupWindowSize != null) {
            entity.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(RollingTimeWindowMeanEnricher.class).configure((CharSequence)"producer", (Object)entity)).configure((CharSequence)"source", REQUEST_LATENCY_IN_SECONDS_MOST_RECENT)).configure((CharSequence)"target", REQUEST_LATENCY_IN_SECONDS_IN_WINDOW)).configure((CharSequence)"timePeriod", (Object)rollupWindowSize));
        }
    }

    public void updateEnablement() {
        if (this.computeEnablement()) {
            this.httpFeed.resume();
        } else {
            this.httpFeed.suspend();
        }
    }

    protected boolean computeEnablement() {
        return ((Boolean)this.getConfig(REQUIRE_SERVICE_UP) == false || this.serviceUp.get()) && this.url.get() != null;
    }

    public void destroy() {
        super.destroy();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        boolean requireServiceUp = true;
        Duration period = Duration.ONE_SECOND;
        String url;
        AttributeSensor<?> urlSensor;
        Function<String, String> urlPostProcessing;
        Duration rollupWindowSize = LATENCY_WINDOW_DEFAULT_PERIOD;

        public Builder noServiceUp() {
            this.requireServiceUp = false;
            return this;
        }

        public Builder period(Duration period) {
            this.period = period;
            return this;
        }

        public Builder period(int amount, TimeUnit unit) {
            return this.period(Duration.of((long)amount, (TimeUnit)unit));
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder url(URL url) {
            return this.url(url.toString());
        }

        public Builder url(URI uri) {
            return this.url(uri.toString());
        }

        public Builder url(AttributeSensor<?> sensor) {
            this.urlSensor = sensor;
            return this;
        }

        public Builder url(AttributeSensor<?> sensor, Function<String, String> postProcessing) {
            this.urlSensor = sensor;
            this.urlPostProcessing = postProcessing;
            return this;
        }

        public Builder rollup(Duration windowSize) {
            this.rollupWindowSize = windowSize;
            return this;
        }

        public Builder rollup(int windowSize, TimeUnit unit) {
            return this.rollup(Duration.of((long)windowSize, (TimeUnit)unit));
        }

        public Builder rollupOff() {
            this.rollupWindowSize = null;
            return this;
        }

        @Deprecated
        public HttpLatencyDetector build() {
            return new HttpLatencyDetector((Map<?, ?>)MutableMap.builder().putIfNotNull(PERIOD, (Object)this.period).putIfNotNull(ROLLUP_WINDOW_SIZE, (Object)this.rollupWindowSize).putIfNotNull(REQUIRE_SERVICE_UP, (Object)this.requireServiceUp).putIfNotNull(URL, (Object)this.url).putIfNotNull(URL_SENSOR, this.urlSensor).putIfNotNull(URL_POST_PROCESSING, this.urlPostProcessing).build());
        }

        public EnricherSpec<HttpLatencyDetector> buildSpec() {
            return (EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(HttpLatencyDetector.class).configureIfNotNull(PERIOD, (Object)this.period)).configureIfNotNull(ROLLUP_WINDOW_SIZE, (Object)this.rollupWindowSize)).configureIfNotNull(REQUIRE_SERVICE_UP, (Object)this.requireServiceUp)).configureIfNotNull(URL, (Object)this.url)).configureIfNotNull(URL_SENSOR, this.urlSensor)).configureIfNotNull(URL_POST_PROCESSING, this.urlPostProcessing);
        }
    }
}

