/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.WebEntitlementContext;
import org.apache.brooklyn.rest.filter.RequestTaggingFilter;
import org.apache.brooklyn.rest.security.provider.DelegatingSecurityProvider;
import org.apache.brooklyn.rest.util.OsgiCompat;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrooklynPropertiesSecurityFilter
implements Filter {
    public static final String AUTHENTICATED_USER_SESSION_ATTRIBUTE = "brooklyn.user";
    @Deprecated
    public static final String REMOTE_ADDRESS_SESSION_ATTRIBUTE = "request.remoteAddress";
    private static final Logger log = LoggerFactory.getLogger(BrooklynPropertiesSecurityFilter.class);
    protected DelegatingSecurityProvider provider;
    private static ThreadLocal<String> originalRequest = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if (this.provider == null) {
            log.warn("No security provider available: disallowing web access to brooklyn");
            httpResponse.sendError(503);
            return;
        }
        if (originalRequest.get() != null) {
            Entitlements.clearEntitlementContext();
        } else {
            originalRequest.set(uri);
        }
        boolean authenticated = this.provider.isAuthenticated(httpRequest.getSession());
        if ("/logout".equals(uri) || "/v1/logout".equals(uri)) {
            httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"brooklyn\"");
            if (authenticated && httpRequest.getSession().getAttributeNames().hasMoreElements()) {
                this.logout(httpRequest);
                httpResponse.sendError(401);
            } else {
                RequestDispatcher dispatcher = httpRequest.getRequestDispatcher("/");
                log.debug("Not authenticated, forwarding request for {} to {}", (Object)uri, (Object)dispatcher);
                dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            return;
        }
        if (!httpRequest.getSession().getAttributeNames().hasMoreElements() || !this.provider.isAuthenticated(httpRequest.getSession()) || "/logout".equals(originalRequest.get())) {
            authenticated = this.authenticate(httpRequest);
        }
        if (!authenticated) {
            httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"brooklyn\"");
            httpResponse.sendError(401);
            return;
        }
        String uid = RequestTaggingFilter.getTag();
        String user = Strings.toString((Object)httpRequest.getSession().getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE));
        try {
            WebEntitlementContext entitlementContext = new WebEntitlementContext(user, httpRequest.getRemoteAddr(), uri, uid);
            Entitlements.setEntitlementContext((EntitlementContext)entitlementContext);
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            if (!response.isCommitted()) {
                httpResponse.sendError(500);
            }
        }
        finally {
            originalRequest.remove();
            Entitlements.clearEntitlementContext();
        }
    }

    protected boolean authenticate(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (this.provider.isAuthenticated(session)) {
            return true;
        }
        session.setAttribute(REMOTE_ADDRESS_SESSION_ATTRIBUTE, (Object)request.getRemoteAddr());
        String user = null;
        String pass = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null) {
            String userpass = new String(Base64.decodeBase64((String)authorization.substring(6)));
            int idxColon = userpass.indexOf(":");
            if (idxColon >= 0) {
                user = userpass.substring(0, idxColon);
                pass = userpass.substring(idxColon + 1);
            } else {
                return false;
            }
        }
        if (this.provider.authenticate(session, user, pass)) {
            if (user != null) {
                session.setAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE, user);
            }
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
        ManagementContext mgmt = OsgiCompat.getManagementContext((ServletContext)config.getServletContext());
        this.provider = new DelegatingSecurityProvider(mgmt);
    }

    public void destroy() {
    }

    protected void logout(HttpServletRequest request) {
        log.info("REST logging {} out of session {}", request.getSession().getAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE), (Object)request.getSession().getId());
        this.provider.logout(request.getSession());
        request.getSession().removeAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE);
        request.getSession().removeAttribute(REMOTE_ADDRESS_SESSION_ATTRIBUTE);
        request.getSession().invalidate();
    }
}

