/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercerExtensible;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.UserAndHostAndPort;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.brooklyn.util.yaml.Yamls;

public class CommonAdaptorTypeCoercions {
    private final TypeCoercerExtensible coercer;

    public CommonAdaptorTypeCoercions(TypeCoercerExtensible coercer) {
        this.coercer = coercer;
    }

    public CommonAdaptorTypeCoercions registerAllAdapters() {
        this.registerStandardAdapters();
        this.registerRecursiveIterableAdapters();
        this.registerClassForNameAdapters();
        this.registerCollectionJsonAdapters();
        return this;
    }

    public synchronized <A, B> Function<? super A, B> registerAdapter(Class<A> sourceType, Class<B> targetType, Function<? super A, B> fn) {
        return this.coercer.registerAdapter(sourceType, targetType, fn);
    }

    public void registerStandardAdapters() {
        this.registerAdapter(CharSequence.class, String.class, new Function<CharSequence, String>(){

            public String apply(CharSequence input) {
                return input.toString();
            }
        });
        this.registerAdapter(byte[].class, String.class, new Function<byte[], String>(){

            public String apply(byte[] input) {
                return new String(input);
            }
        });
        this.registerAdapter(Collection.class, Set.class, new Function<Collection, Set>(){

            public Set apply(Collection input) {
                return Sets.newLinkedHashSet((Iterable)input);
            }
        });
        this.registerAdapter(Collection.class, List.class, new Function<Collection, List>(){

            public List apply(Collection input) {
                return Lists.newArrayList((Iterable)input);
            }
        });
        this.registerAdapter(String.class, InetAddress.class, new Function<String, InetAddress>(){

            public InetAddress apply(String input) {
                return Networking.getInetAddressWithFixedName(input);
            }
        });
        this.registerAdapter(String.class, HostAndPort.class, new Function<String, HostAndPort>(){

            public HostAndPort apply(String input) {
                return HostAndPort.fromString((String)input);
            }
        });
        this.registerAdapter(String.class, UserAndHostAndPort.class, new Function<String, UserAndHostAndPort>(){

            public UserAndHostAndPort apply(String input) {
                return UserAndHostAndPort.fromString(input);
            }
        });
        this.registerAdapter(String.class, Cidr.class, new Function<String, Cidr>(){

            public Cidr apply(String input) {
                return new Cidr(input);
            }
        });
        this.registerAdapter(String.class, URL.class, new Function<String, URL>(){

            public URL apply(String input) {
                try {
                    return new URL(input);
                }
                catch (Exception e) {
                    throw Exceptions.propagate(e);
                }
            }
        });
        this.registerAdapter(URL.class, String.class, new Function<URL, String>(){

            public String apply(URL input) {
                return input.toString();
            }
        });
        this.registerAdapter(String.class, URI.class, new Function<String, URI>(){

            public URI apply(String input) {
                return URI.create(input);
            }
        });
        this.registerAdapter(URI.class, String.class, new Function<URI, String>(){

            public String apply(URI input) {
                return input.toString();
            }
        });
        this.registerAdapter(Object.class, Duration.class, new Function<Object, Duration>(){

            public Duration apply(Object input) {
                return Duration.of(input);
            }
        });
        this.registerAdapter(Integer.class, AtomicLong.class, new Function<Integer, AtomicLong>(){

            public AtomicLong apply(Integer input) {
                return new AtomicLong(input.intValue());
            }
        });
        this.registerAdapter(Long.class, AtomicLong.class, new Function<Long, AtomicLong>(){

            public AtomicLong apply(Long input) {
                return new AtomicLong(input);
            }
        });
        this.registerAdapter(String.class, AtomicLong.class, new Function<String, AtomicLong>(){

            public AtomicLong apply(String input) {
                return new AtomicLong(Long.parseLong(input.trim()));
            }
        });
        this.registerAdapter(Integer.class, AtomicInteger.class, new Function<Integer, AtomicInteger>(){

            public AtomicInteger apply(Integer input) {
                return new AtomicInteger(input);
            }
        });
        this.registerAdapter(String.class, AtomicInteger.class, new Function<String, AtomicInteger>(){

            public AtomicInteger apply(String input) {
                return new AtomicInteger(Integer.parseInt(input.trim()));
            }
        });
        this.registerAdapter(String.class, Number.class, new Function<String, Number>(){

            public Number apply(String input) {
                return Double.valueOf(input);
            }
        });
        this.registerAdapter(BigDecimal.class, Double.class, new Function<BigDecimal, Double>(){

            public Double apply(BigDecimal input) {
                return input.doubleValue();
            }
        });
        this.registerAdapter(BigInteger.class, Long.class, new Function<BigInteger, Long>(){

            public Long apply(BigInteger input) {
                return input.longValue();
            }
        });
        this.registerAdapter(BigInteger.class, Integer.class, new Function<BigInteger, Integer>(){

            public Integer apply(BigInteger input) {
                return input.intValue();
            }
        });
        this.registerAdapter(String.class, BigDecimal.class, new Function<String, BigDecimal>(){

            public BigDecimal apply(String input) {
                return new BigDecimal(input);
            }
        });
        this.registerAdapter(Double.class, BigDecimal.class, new Function<Double, BigDecimal>(){

            public BigDecimal apply(Double input) {
                return BigDecimal.valueOf(input);
            }
        });
        this.registerAdapter(String.class, BigInteger.class, new Function<String, BigInteger>(){

            public BigInteger apply(String input) {
                return new BigInteger(input);
            }
        });
        this.registerAdapter(Long.class, BigInteger.class, new Function<Long, BigInteger>(){

            public BigInteger apply(Long input) {
                return BigInteger.valueOf(input);
            }
        });
        this.registerAdapter(Integer.class, BigInteger.class, new Function<Integer, BigInteger>(){

            public BigInteger apply(Integer input) {
                return BigInteger.valueOf(input.intValue());
            }
        });
        this.registerAdapter(String.class, Date.class, new Function<String, Date>(){

            public Date apply(String input) {
                return Time.parseDate(input);
            }
        });
        this.registerAdapter(String.class, QuorumCheck.class, new Function<String, QuorumCheck>(){

            public QuorumCheck apply(String input) {
                return QuorumCheck.QuorumChecks.of(input);
            }
        });
        this.registerAdapter(Integer.class, QuorumCheck.class, new Function<Integer, QuorumCheck>(){

            public QuorumCheck apply(Integer input) {
                return QuorumCheck.QuorumChecks.of(input);
            }
        });
        this.registerAdapter(Collection.class, QuorumCheck.class, new Function<Collection, QuorumCheck>(){

            public QuorumCheck apply(Collection input) {
                return QuorumCheck.QuorumChecks.of(input);
            }
        });
        this.registerAdapter(String.class, TimeZone.class, new Function<String, TimeZone>(){

            public TimeZone apply(String input) {
                return TimeZone.getTimeZone(input);
            }
        });
        this.registerAdapter(Long.class, Date.class, new Function<Long, Date>(){

            public Date apply(Long input) {
                return new Date(input);
            }
        });
        this.registerAdapter(Integer.class, Date.class, new Function<Integer, Date>(){

            public Date apply(Integer input) {
                return new Date(input.intValue());
            }
        });
        this.registerAdapter(String.class, Predicate.class, new Function<String, Predicate>(){

            public Predicate apply(String input) {
                switch (input) {
                    case "alwaysFalse": {
                        return Predicates.alwaysFalse();
                    }
                    case "alwaysTrue": {
                        return Predicates.alwaysTrue();
                    }
                    case "isNull": {
                        return Predicates.isNull();
                    }
                    case "notNull": {
                        return Predicates.notNull();
                    }
                }
                throw new IllegalArgumentException("Cannot convert string '" + input + "' to predicate");
            }
        });
    }

    public void registerRecursiveIterableAdapters() {
        this.registerAdapter(Iterable.class, String[].class, new Function<Iterable, String[]>(){

            @Nullable
            public String[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                String[] result = new String[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = CommonAdaptorTypeCoercions.this.coercer.coerce(element, String.class);
                }
                return result;
            }
        });
        this.registerAdapter(Iterable.class, Integer[].class, new Function<Iterable, Integer[]>(){

            @Nullable
            public Integer[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                Integer[] result = new Integer[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = CommonAdaptorTypeCoercions.this.coercer.coerce(element, Integer.class);
                }
                return result;
            }
        });
        this.registerAdapter(Iterable.class, int[].class, new Function<Iterable, int[]>(){

            @Nullable
            public int[] apply(@Nullable Iterable list) {
                if (list == null) {
                    return null;
                }
                int[] result = new int[Iterables.size((Iterable)list)];
                int count = 0;
                for (Object element : list) {
                    result[count++] = CommonAdaptorTypeCoercions.this.coercer.coerce(element, Integer.TYPE);
                }
                return result;
            }
        });
    }

    public void registerClassForNameAdapters() {
        this.registerAdapter(String.class, Class.class, new Function<String, Class>(){

            public Class apply(String input) {
                try {
                    return Class.forName(input);
                }
                catch (ClassNotFoundException e) {
                    throw Exceptions.propagate(e);
                }
            }
        });
    }

    public void registerCollectionJsonAdapters() {
        this.registerAdapter(String.class, List.class, new Function<String, List>(){

            public List<String> apply(String input) {
                return StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible(input);
            }
        });
        this.registerAdapter(String.class, Set.class, new Function<String, Set>(){

            public Set<String> apply(String input) {
                return MutableSet.copyOf(StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible(input)).asUnmodifiable();
            }
        });
        this.registerAdapter(String.class, Map.class, new Function<String, Map>(){

            public Map apply(String input) {
                Exception error = null;
                if (!input.trim().startsWith("{")) {
                    try {
                        return this.apply("{ " + input + " }");
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal(e);
                        error = e;
                    }
                }
                try {
                    return Yamls.getAs(Yamls.parseAll(input), Map.class);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                    if (error != null && input.indexOf(10) == -1) {
                        e = error;
                    }
                    throw new IllegalArgumentException("Cannot parse string as map with flexible YAML parsing; " + (e instanceof ClassCastException ? "yaml treats it as a string" : (e instanceof IllegalArgumentException && Strings.isNonEmpty(e.getMessage()) ? e.getMessage() : "" + e)));
                }
            }
        });
    }
}

