/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.http.executor.Credentials;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpRequestImpl;

@Beta
public interface HttpRequest {
    public URI uri();

    public String method();

    @Nullable
    public byte[] body();

    public Multimap<String, String> headers();

    @Nullable
    public Credentials credentials();

    @Nullable
    public HttpConfig config();

    @Beta
    public static class Builder {
        protected URI uri;
        protected String method;
        protected byte[] body;
        protected Multimap<String, String> headers = ArrayListMultimap.create();
        protected Credentials credentials;
        protected HttpConfig config;

        public Builder uri(URI val) {
            this.uri = (URI)Preconditions.checkNotNull((Object)val, (Object)"uri");
            return this;
        }

        public Builder method(String val) {
            this.method = (String)Preconditions.checkNotNull((Object)val, (Object)"method");
            return this;
        }

        public Builder body(@Nullable byte[] val) {
            this.body = val;
            return this;
        }

        public Builder headers(Multimap<String, String> val) {
            this.headers.putAll((Multimap)Preconditions.checkNotNull(val, (Object)"headers"));
            return this;
        }

        public Builder headers(Map<String, String> val) {
            if (((Map)Preconditions.checkNotNull(val, (Object)"headers")).keySet().contains(null)) {
                throw new NullPointerException("Headers must not contain null key");
            }
            for (Map.Entry<String, String> entry : val.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder header(String key, String val) {
            this.headers.put(Preconditions.checkNotNull((Object)key, (Object)"key"), (Object)val);
            return this;
        }

        public Builder credentials(@Nullable Credentials val) {
            this.credentials = val;
            return this;
        }

        public Builder config(@Nullable HttpConfig val) {
            this.config = val;
            return this;
        }

        public Builder from(HttpRequestImpl httpRequest) {
            this.uri = (URI)Preconditions.checkNotNull((Object)httpRequest.uri, (Object)"uri");
            this.method = (String)Preconditions.checkNotNull((Object)httpRequest.method, (Object)"method");
            this.body = httpRequest.body;
            this.headers = ArrayListMultimap.create((Multimap)((Multimap)Preconditions.checkNotNull(httpRequest.headers, (Object)"headers")));
            this.credentials = httpRequest.credentials;
            this.config = httpRequest.config;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequestImpl(this);
        }
    }
}

