/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.jboss;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.jboss.JBoss7Driver;
import org.apache.brooklyn.entity.webapp.jboss.JBoss7Server;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.util.guava.Functionals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBoss7ServerImpl
extends JavaWebAppSoftwareProcessImpl
implements JBoss7Server {
    public static final Logger log = LoggerFactory.getLogger(JBoss7ServerImpl.class);
    private volatile HttpFeed httpFeed;

    public Class<?> getDriverInterface() {
        return JBoss7Driver.class;
    }

    @Override
    public JBoss7Driver getDriver() {
        return (JBoss7Driver)super.getDriver();
    }

    protected void connectSensors() {
        super.connectSensors();
        HostAndPort hp = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this, (int)((Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTP_PORT) + (Integer)this.getConfig(PORT_INCREMENT)));
        String managementUri = String.format("http://%s:%s/management/subsystem/web/connector/http/read-resource", hp.getHostText(), hp.getPort());
        this.sensors().set(MANAGEMENT_URL, (Object)managementUri);
        if (this.isHttpMonitoringEnabled()) {
            log.debug("JBoss sensors for " + this + " reading from " + managementUri);
            ImmutableMap includeRuntimeUriVars = ImmutableMap.of((Object)"include-runtime", (Object)"true");
            boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
            this.httpFeed = HttpFeed.builder().entity((Entity)this).period(200L).baseUri(managementUri).credentials((String)this.getConfig(MANAGEMENT_USER), (String)this.getConfig(MANAGEMENT_PASSWORD)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MANAGEMENT_STATUS).onSuccess(HttpValueFunctions.responseCode())).suppressDuplicates(true)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MANAGEMENT_URL_UP).onSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)false))).suppressDuplicates(true)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(REQUEST_COUNT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"requestCount", Integer.class))).onFailureOrException(EntityFunctions.attribute((Entity)this, (AttributeSensor)REQUEST_COUNT))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig((AttributeSensor)ERROR_COUNT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"errorCount", Integer.class))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(TOTAL_PROCESSING_TIME).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"processingTime", Integer.class))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MAX_PROCESSING_TIME).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"maxTime", Integer.class))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(BYTES_RECEIVED).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"bytesReceived", Long.class))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(BYTES_SENT).vars((Map)includeRuntimeUriVars).onSuccess(HttpValueFunctions.jsonContents((String)"bytesSent", Long.class))).enabled(retrieveUsageMetrics)).build();
            this.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(MANAGEMENT_URL_UP).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Management URL not reachable"))).build());
        }
        this.connectServiceUpIsRunning();
    }

    @Deprecated
    protected final void connectServiceUp() {
    }

    @Deprecated
    protected final void disconnectServiceUp() {
    }

    protected void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
    }

    protected boolean isHttpMonitoringEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_HTTP_MONITORING));
    }

    public int getManagementHttpsPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTPS_PORT);
    }

    public int getManagementHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_HTTP_PORT);
    }

    public int getManagementNativePort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_NATIVE_PORT);
    }

    public int getPortOffset() {
        return (Integer)this.getConfig(PORT_INCREMENT);
    }

    public boolean isWelcomeRootEnabled() {
        return false;
    }

    public String getBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getManagementBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getUnsecureBindAddress() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)BIND_ADDRESS);
    }

    public String getHttpManagementInterfaceSecurityRealm() {
        return "";
    }

    public int getDeploymentTimeoutSecs() {
        return (Integer)this.getConfig(DEPLOYMENT_TIMEOUT);
    }

    public String getHttpsSslKeystoreFile() {
        return this.getDriver().getSslKeystoreFile();
    }

    public String getShortName() {
        return "JBossAS7";
    }

    static {
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

