/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.jboss;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.webapp.JavaWebAppSshDriver;
import org.apache.brooklyn.entity.webapp.jboss.JBoss6Driver;
import org.apache.brooklyn.entity.webapp.jboss.JBoss6Server;
import org.apache.brooklyn.entity.webapp.jboss.JBoss6ServerImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class JBoss6SshDriver
extends JavaWebAppSshDriver
implements JBoss6Driver {
    public static final String SERVER_TYPE = "standard";
    public static final int DEFAULT_HTTP_PORT = 8080;
    private static final String PORT_GROUP_NAME = "ports-brooklyn";

    public JBoss6SshDriver(JBoss6ServerImpl entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    public JBoss6ServerImpl getEntity() {
        return (JBoss6ServerImpl)super.getEntity();
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "server", SERVER_TYPE, "log/server.log"});
    }

    @Override
    protected String getDeploySubdir() {
        return Os.mergePathsUnix((String[])new String[]{"server", SERVER_TYPE, "deploy"});
    }

    protected String getBindAddress() {
        return (String)this.entity.getAttribute(JBoss6Server.BIND_ADDRESS);
    }

    protected Integer getPortIncrement() {
        return (Integer)this.entity.getAttribute(JBoss6Server.PORT_INCREMENT);
    }

    protected String getClusterName() {
        return (String)this.entity.getAttribute(JBoss6Server.CLUSTER_NAME);
    }

    public String getExpandedInstallDir() {
        String result = super.getExpandedInstallDir();
        return result != null ? result : this.getInstallDir() + "/jboss-" + this.getVersion();
    }

    @Override
    public void postLaunch() {
        this.entity.sensors().set((AttributeSensor)JBoss6Server.HTTP_PORT, (Object)(8080 + this.getPortIncrement()));
        super.postLaunch();
    }

    public boolean installJava() {
        return this.checkForAndInstallJava("1.7");
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_UNZIP);
        commands.add(String.format("unzip -o %s", saveAs));
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("mkdir -p %s/server", this.getRunDir()), String.format("cd %s/server", this.getRunDir()), String.format("cp -r %s/server/%s %s", this.getExpandedInstallDir(), SERVER_TYPE, SERVER_TYPE), String.format("cd %s/conf/bindingservice.beans/META-INF/", SERVER_TYPE), "BJB=\"bindings-jboss-beans.xml\"", String.format("sed -i.bk 's/ports-03/%s/' $BJB", PORT_GROUP_NAME), String.format("sed -i.bk 's/<parameter>300<\\/parameter>/<parameter>%s<\\/parameter>/' $BJB", this.getPortIncrement())}).execute();
        this.getEntity().deployInitialWars();
    }

    public void launch() {
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("httpPort", this.getHttpPort());
        if (this.isJmxEnabled()) {
            ports.put("jmxPort", this.getJmxPort());
        }
        Networking.checkPortsValid(ports);
        String clusterArg = Strings.isEmpty((CharSequence)this.getClusterName()) ? "" : "-g " + this.getClusterName();
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{String.format("export JBOSS_CLASSPATH=%s/lib/jboss-logmanager.jar", this.getExpandedInstallDir()), String.format("export JBOSS_PIDFILE=%s/%s", this.getRunDir(), "pid.txt"), "mv " + this.getRunDir() + "/console " + this.getRunDir() + "/console-$(date +\"%Y%m%d.%H%M.%S\") || true", String.format("%s/bin/run.sh -Djboss.service.binding.set=%s -Djboss.server.base.dir=$RUN_DIR/server ", this.getExpandedInstallDir(), PORT_GROUP_NAME) + String.format("-Djboss.server.base.url=file://$RUN_DIR/server -Djboss.messaging.ServerPeerID=%s ", this.entity.getId()) + String.format("-Djboss.boot.server.log.dir=%s/server/%s/log ", this.getRunDir(), SERVER_TYPE) + String.format("-b %s %s -c %s ", this.getBindAddress(), clusterArg, SERVER_TYPE) + ">>$RUN_DIR/console 2>&1 </dev/null &", BashCommands.waitForFileContents((String)(this.getRunDir() + "/console"), (String)"Starting", (Duration)Duration.TEN_SECONDS, (boolean)false)}).execute();
    }

    public boolean isRunning() {
        UsesJmx.JmxAgentModes jmxMode = (UsesJmx.JmxAgentModes)this.entity.getConfig(UsesJmx.JMX_AGENT_MODE);
        if (jmxMode == UsesJmx.JmxAgentModes.JMX_RMI_CUSTOM_AGENT) {
            String host = (String)this.entity.getAttribute(Attributes.HOSTNAME);
            Integer port = (Integer)this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT);
            LinkedList<String> checkRunningScript = new LinkedList<String>();
            checkRunningScript.add(String.format("%s/bin/twiddle.sh --host %s --port %s get \"jboss.system:type=Server\" Started | grep true || exit 1", this.getExpandedInstallDir(), host, port));
            LinkedHashMap flags = new LinkedHashMap();
            flags.put("env", new LinkedHashMap());
            int result = this.execute(flags, checkRunningScript, "checkRunning " + this.entity + " on " + this.getMachine());
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                return false;
            }
            throw new IllegalStateException(String.format("%s running check gave result code %s", this.getEntity(), result));
        }
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        UsesJmx.JmxAgentModes jmxMode = (UsesJmx.JmxAgentModes)this.entity.getConfig(UsesJmx.JMX_AGENT_MODE);
        if (jmxMode == UsesJmx.JmxAgentModes.JMX_RMI_CUSTOM_AGENT) {
            String host = (String)this.entity.getAttribute(Attributes.HOSTNAME);
            Integer port = (Integer)this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT);
            LinkedList<String> shutdownScript = new LinkedList<String>();
            shutdownScript.add(String.format("%s/bin/shutdown.sh --host %s --port %s -S", this.getExpandedInstallDir(), host, port));
            log.debug("invoking shutdown script for {}: {}", (Object)this.entity, shutdownScript);
            LinkedHashMap flags = new LinkedHashMap();
            flags.put("env", new LinkedHashMap());
            int result = this.execute(flags, shutdownScript, "shutdown " + this.entity + " on " + this.getMachine());
            if (result != 0) {
                log.warn("non-zero result code terminating {}: {}", (Object)this.entity, (Object)result);
            }
            log.debug("done invoking shutdown script for {}", (Object)this.entity);
        } else {
            this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
        }
    }

    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll((Iterable)super.getCustomJavaConfigOptions()).add((Object)"-Xms200m").add((Object)"-Xmx800m").add((Object)"-XX:MaxPermSize=400m").build();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"LAUNCH_JBOSS_IN_BACKGROUND", (Object)"1").put((Object)"RUN", (Object)this.getRunDir()).build();
    }

    protected Map getCustomJavaSystemProperties() {
        return MutableMap.builder().put((Object)"jboss.platform.mbeanserver", null).put((Object)"javax.management.builder.initial", (Object)"org.jboss.system.server.jmx.MBeanServerBuilderImpl").put((Object)"java.util.logging.manager", (Object)"org.jboss.logmanager.LogManager").put((Object)"org.jboss.logging.Logger.pluginClass", (Object)"org.jboss.logging.logmanager.LoggerPluginImpl").build();
    }
}

