/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import org.jclouds.azurecompute.domain.Error;
import org.jclouds.azurecompute.domain.Operation;
import org.jclouds.azurecompute.xml.ErrorHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class OperationHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Operation> {
    private String id;
    private Operation.Status status;
    private Integer httpStatusCode;
    private Error error;
    private boolean inError;
    private final ErrorHandler errorHandler = new ErrorHandler();
    private final StringBuilder currentText = new StringBuilder();

    public Operation getResult() {
        return Operation.create(this.id, this.status, this.httpStatusCode, this.error);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Error")) {
            this.inError = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Error")) {
            this.error = this.errorHandler.getResult();
            this.inError = false;
        } else if (this.inError) {
            this.errorHandler.endElement(uri, name, qName);
        } else if (qName.equals("ID")) {
            this.id = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Status")) {
            String statusText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.status = Operation.Status.fromString(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, statusText));
        } else if (qName.equals("HttpStatusCode")) {
            this.httpStatusCode = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inError) {
            this.errorHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

