/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.Disk;
import org.jclouds.azurecompute.xml.DiskHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListDisksHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<Disk>> {
    private boolean inDisk;
    private final DiskHandler diskHandler;
    private final ImmutableList.Builder<Disk> disks = ImmutableList.builder();

    @Inject
    ListDisksHandler(DiskHandler diskHandler) {
        this.diskHandler = diskHandler;
    }

    public List<Disk> getResult() {
        return this.disks.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Disk")) {
            this.inDisk = true;
        }
        if (this.inDisk) {
            this.diskHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Disk")) {
            this.inDisk = false;
            this.disks.add((Object)this.diskHandler.getResult());
        } else if (this.inDisk) {
            this.diskHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDisk) {
            this.diskHandler.characters(ch, start, length);
        }
    }
}

