/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpoint;
import org.jclouds.azurecompute.domain.ProfileDefinitionMonitor;

public abstract class ProfileDefinition {
    ProfileDefinition() {
    }

    public abstract int ttl();

    public abstract Status status();

    public abstract String version();

    public abstract List<ProfileDefinitionMonitor> monitors();

    public abstract LBMethod lb();

    public abstract List<ProfileDefinitionEndpoint> endpoints();

    public abstract HealthStatus healthStatus();

    public static ProfileDefinition create(int ttl, Status status, String version, List<ProfileDefinitionMonitor> monitors, LBMethod lb, List<ProfileDefinitionEndpoint> endpoints, HealthStatus healthStatus) {
        return new AutoValue_ProfileDefinition(ttl, status, version, (List<ProfileDefinitionMonitor>)ImmutableList.copyOf(monitors), lb, (List<ProfileDefinitionEndpoint>)ImmutableList.copyOf(endpoints), healthStatus);
    }

    public static enum HealthStatus {
        UNRECOGNIZED(""),
        ONLINE("Online"),
        DEGRADED("Degraded"),
        INACTIVE("Inactive"),
        DISABLED("Disabled"),
        STOPPED("Stopped"),
        CHECKINGENDPOINT("CheckingEndpoint");

        private final String value;

        private HealthStatus(String value) {
            this.value = value;
        }

        public static HealthStatus fromString(String value) {
            for (HealthStatus status : HealthStatus.values()) {
                if (!status.value.equalsIgnoreCase(value)) continue;
                return status;
            }
            return UNRECOGNIZED;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Protocol {
        UNRECOGNIZED,
        HTTP,
        HTTPS;


        public static Protocol fromString(String value) {
            for (Protocol protocol : Protocol.values()) {
                if (!protocol.name().equalsIgnoreCase(value)) continue;
                return protocol;
            }
            return UNRECOGNIZED;
        }
    }

    public static enum LBMethod {
        UNRECOGNIZED(""),
        PERFORMANCE("Performance"),
        FAILOVER("Failover"),
        ROUNDROBIN("RoundRobin");

        private final String value;

        private LBMethod(String value) {
            this.value = value;
        }

        public static LBMethod fromString(String value) {
            for (LBMethod lb : LBMethod.values()) {
                if (!lb.value.equalsIgnoreCase(value)) continue;
                return lb;
            }
            return UNRECOGNIZED;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        UNRECOGNIZED(""),
        ENABLED("Enabled"),
        DISABLED("Disabled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public static Status fromString(String value) {
            for (Status status : Status.values()) {
                if (!status.value.equalsIgnoreCase(value)) continue;
                return status;
            }
            return UNRECOGNIZED;
        }

        public String getValue() {
            return this.value;
        }
    }
}

