/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.azurecompute.domain.AutoValue_DeploymentParams;
import org.jclouds.azurecompute.domain.AutoValue_DeploymentParams_ExternalEndpoint;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;

public abstract class DeploymentParams {
    DeploymentParams() {
    }

    public abstract String name();

    public abstract RoleSize.Type size();

    public abstract String username();

    public abstract String password();

    public abstract String sourceImageName();

    public abstract URI mediaLink();

    public abstract OSImage.Type os();

    public abstract Set<ExternalEndpoint> externalEndpoints();

    @Nullable
    public abstract String virtualNetworkName();

    @SinceApiVersion(value="2014-05-01")
    @Nullable
    public abstract String reservedIPName();

    public abstract List<String> subnetNames();

    @Nullable
    public abstract Boolean provisionGuestAgent();

    @Nullable
    public abstract Boolean winrmUseHttps();

    public static Builder builder() {
        return new AutoValue_DeploymentParams.Builder().externalEndpoints((Set<ExternalEndpoint>)ImmutableSet.of()).subnetNames((List<String>)ImmutableList.of());
    }

    abstract Builder toBuilder();

    public static DeploymentParams create(String name, RoleSize.Type size, String username, String password, String sourceImageName, URI mediaLink, OSImage.Type os, Set<ExternalEndpoint> externalEndpoints, String virtualNetworkName, String reservedIPName, List<String> subnetNames, Boolean provisionGuestAgent) {
        return DeploymentParams.builder().name(name).size(size).username(username).password(password).sourceImageName(sourceImageName).mediaLink(mediaLink).os(os).externalEndpoints(externalEndpoints).virtualNetworkName(virtualNetworkName).reservedIPName(reservedIPName).subnetNames(subnetNames).provisionGuestAgent(provisionGuestAgent).build();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder size(RoleSize.Type var1);

        public abstract Builder username(String var1);

        public abstract Builder password(String var1);

        public abstract Builder winrmUseHttps(Boolean var1);

        public abstract Builder sourceImageName(String var1);

        public abstract Builder mediaLink(URI var1);

        public abstract Builder os(OSImage.Type var1);

        public abstract Builder externalEndpoints(Set<ExternalEndpoint> var1);

        public abstract Builder virtualNetworkName(String var1);

        public abstract Builder reservedIPName(String var1);

        public abstract Builder subnetNames(List<String> var1);

        public abstract Builder provisionGuestAgent(Boolean var1);

        abstract Set<ExternalEndpoint> externalEndpoints();

        abstract List<String> subnetNames();

        abstract DeploymentParams autoBuild();

        public DeploymentParams build() {
            this.externalEndpoints((Set<ExternalEndpoint>)(this.externalEndpoints() != null ? ImmutableSet.copyOf(this.externalEndpoints()) : null));
            this.subnetNames((List<String>)(this.subnetNames() != null ? ImmutableList.copyOf(this.subnetNames()) : null));
            return this.autoBuild();
        }
    }

    public static abstract class ExternalEndpoint {
        public abstract String name();

        public abstract String protocol();

        public abstract int port();

        public abstract int localPort();

        public static ExternalEndpoint inboundTcpToLocalPort(int port, int localPort) {
            return new AutoValue_DeploymentParams_ExternalEndpoint(String.format("tcp_%s-%s", port, localPort), "tcp", port, localPort);
        }

        public static ExternalEndpoint inboundUdpToLocalPort(int port, int localPort) {
            return new AutoValue_DeploymentParams_ExternalEndpoint(String.format("udp_%s-%s", port, localPort), "udp", port, localPort);
        }

        ExternalEndpoint() {
        }
    }
}

