/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.compute.AzureComputeServiceAdapter;
import org.jclouds.azurecompute.compute.extensions.AzureComputeSecurityGroupExtension;
import org.jclouds.azurecompute.compute.functions.DeploymentToNodeMetadata;
import org.jclouds.azurecompute.compute.functions.LocationToLocation;
import org.jclouds.azurecompute.compute.functions.OSImageToImage;
import org.jclouds.azurecompute.compute.functions.RoleSizeToHardware;
import org.jclouds.azurecompute.compute.options.AzureComputeTemplateOptions;
import org.jclouds.azurecompute.compute.strategy.GetOrCreateStorageServiceAndVirtualNetworkThenCreateNodes;
import org.jclouds.azurecompute.compute.strategy.UseNodeCredentialsButOverrideFromTemplate;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.util.ConflictManagementPredicate;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Location;

public class AzureComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Deployment, RoleSize, OSImage, org.jclouds.azurecompute.domain.Location> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Deployment, RoleSize, OSImage, org.jclouds.azurecompute.domain.Location>>(){}).to(AzureComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<OSImage, Image>>(){}).to(OSImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RoleSize, Hardware>>(){}).to(RoleSizeToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Deployment, NodeMetadata>>(){}).to(DeploymentToNodeMetadata.class);
        this.bind(PrioritizeCredentialsFromTemplate.class).to(UseNodeCredentialsButOverrideFromTemplate.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.azurecompute.domain.Location, Location>>(){}).to(LocationToLocation.class);
        this.bind(TemplateOptions.class).to(AzureComputeTemplateOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).to(AzureComputeSecurityGroupExtension.class);
        this.bind(CreateNodesInGroupThenAddToSet.class).to(GetOrCreateStorageServiceAndVirtualNetworkThenCreateNodes.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Deployment, RoleSize, OSImage, org.jclouds.azurecompute.domain.Location>(){});
    }

    @Provides
    @Singleton
    protected Predicate<String> provideOperationSucceededPredicate(AzureComputeApi api, AzureComputeConstants azureComputeConstants) {
        return new ConflictManagementPredicate(api, azureComputeConstants.operationTimeout(), azureComputeConstants.operationPollInitialPeriod().intValue(), azureComputeConstants.operationPollMaxPeriod().intValue(), TimeUnit.MILLISECONDS);
    }

    @Singleton
    public static class AzureComputeConstants {
        @Named(value="jclouds.azurecompute.operation.timeout")
        @Inject
        private String operationTimeoutProperty;
        @Named(value="jclouds.azurecompute..operation.poll.initial.period")
        @Inject
        private String operationPollInitialPeriodProperty;
        @Named(value="jclouds.azurecompute.operation.poll.max.period")
        @Inject
        private String operationPollMaxPeriodProperty;
        @Named(value="jclouds.azurecompute.tcp.rule.format")
        @Inject
        private String tcpRuleFormatProperty;
        @Named(value="jclouds.azurecompute.tcp.rule.regexp")
        @Inject
        private String tcpRuleRegexpProperty;
        @Named(value="jclouds.azurecompute.deallocate.when.suspending")
        @Inject
        private String deallocateWhenSuspending;

        public Long operationTimeout() {
            return Long.parseLong(this.operationTimeoutProperty);
        }

        public Integer operationPollInitialPeriod() {
            return Integer.parseInt(this.operationPollInitialPeriodProperty);
        }

        public Integer operationPollMaxPeriod() {
            return Integer.parseInt(this.operationPollMaxPeriodProperty);
        }

        public String tcpRuleFormat() {
            return this.tcpRuleFormatProperty;
        }

        public String tcpRuleRegexp() {
            return this.tcpRuleRegexpProperty;
        }

        public boolean deallocateWhenSuspending() {
            return Boolean.parseBoolean(this.deallocateWhenSuspending);
        }
    }
}

