/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.pdp.AssemblyTemplateConstructor;
import org.apache.brooklyn.camp.spi.pdp.Service;
import org.apache.brooklyn.camp.spi.resolve.PdpMatcher;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynEntityMatcher
implements PdpMatcher {
    private static final Logger log = LoggerFactory.getLogger(BrooklynEntityMatcher.class);
    protected final ManagementContext mgmt;

    public BrooklynEntityMatcher(ManagementContext bmc) {
        this.mgmt = bmc;
    }

    public boolean accepts(Object deploymentPlanItem) {
        return this.lookupType(deploymentPlanItem) != null;
    }

    protected String lookupType(Object deploymentPlanItem) {
        if (deploymentPlanItem instanceof Service) {
            Service service = (Service)deploymentPlanItem;
            String serviceType = service.getServiceType();
            if (serviceType == null) {
                throw new UserFacingException("Service must declare a type: " + service);
            }
            BrooklynClassLoadingContext loader = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader();
            if (loader == null) {
                loader = JavaBrooklynClassLoadingContext.create((ManagementContext)this.mgmt);
            }
            if (BrooklynComponentTemplateResolver.Factory.newInstance(loader, serviceType).canResolve()) {
                return serviceType;
            }
        }
        return null;
    }

    public boolean apply(Object deploymentPlanItem, AssemblyTemplateConstructor atc) {
        Object iconUrl;
        Object locations;
        Object location;
        MutableMap attrs;
        if (!(deploymentPlanItem instanceof Service)) {
            return false;
        }
        String type = this.lookupType(deploymentPlanItem);
        if (type == null) {
            return false;
        }
        log.debug("Item " + deploymentPlanItem + " being instantiated with " + type);
        Class old = atc.getInstantiator();
        if (old != null && !old.equals(BrooklynAssemblyTemplateInstantiator.class)) {
            log.warn("Can't mix Brooklyn entities with non-Brooklyn entities (at present): " + old);
            return false;
        }
        PlatformComponentTemplate.Builder builder = PlatformComponentTemplate.builder();
        builder.type(type.indexOf(58) == -1 ? "brooklyn:" + type : type);
        atc.instantiator(BrooklynAssemblyTemplateInstantiator.class);
        String name = ((Service)deploymentPlanItem).getName();
        if (!Strings.isBlank((CharSequence)name)) {
            builder.name(name);
        }
        if ((attrs = MutableMap.copyOf((Map)((Service)deploymentPlanItem).getCustomAttributes())).containsKey("id")) {
            builder.customAttribute("planId", attrs.remove("id"));
        }
        if ((location = attrs.remove("location")) != null) {
            builder.customAttribute("location", location);
        }
        if ((locations = attrs.remove("locations")) != null) {
            builder.customAttribute("locations", locations);
        }
        if ((iconUrl = attrs.remove(BrooklynConfigKeys.ICON_URL.getName())) != null) {
            builder.customAttribute(BrooklynConfigKeys.ICON_URL.getName(), iconUrl);
        }
        MutableMap brooklynFlags = MutableMap.of();
        Object origBrooklynFlags = attrs.remove("brooklyn.flags");
        if (origBrooklynFlags != null) {
            if (!(origBrooklynFlags instanceof Map)) {
                throw new IllegalArgumentException("brooklyn.flags must be a map of brooklyn flags");
            }
            brooklynFlags.putAll((Map)origBrooklynFlags);
        }
        this.addCustomMapAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.config");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.policies");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.enrichers");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.initializers");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.children");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.parameters");
        this.addCustomMapAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.catalog");
        this.addCustomListAttributeIfNonNull((PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate>)builder, (Map<?, ?>)attrs, "brooklyn.tags");
        brooklynFlags.putAll((Map)attrs);
        if (!brooklynFlags.isEmpty()) {
            builder.customAttribute("brooklyn.flags", (Object)brooklynFlags);
        }
        atc.add((PlatformComponentTemplate)builder.build());
        return true;
    }

    private void addCustomListAttributeIfNonNull(PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate> builder, Map<?, ?> attrs, String key) {
        Object items = attrs.remove(key);
        if (items != null) {
            if (items instanceof List) {
                List itemList = (List)items;
                if (!itemList.isEmpty()) {
                    builder.customAttribute(key, (Object)Lists.newArrayList((Iterable)itemList));
                }
            } else {
                throw new IllegalArgumentException(key + " must be a list, is: " + items.getClass().getName());
            }
        }
    }

    private void addCustomMapAttributeIfNonNull(PlatformComponentTemplate.Builder<? extends PlatformComponentTemplate> builder, Map<?, ?> attrs, String key) {
        Object items = attrs.remove(key);
        if (items != null) {
            if (items instanceof Map) {
                Map itemMap = (Map)items;
                if (!itemMap.isEmpty()) {
                    builder.customAttribute(key, (Object)Maps.newHashMap((Map)itemMap));
                }
            } else {
                throw new IllegalArgumentException(key + " must be a map, is: " + items.getClass().getName());
            }
        }
    }
}

