/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.ha;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.MemberReplaceable;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.entity.group.StopFailedRuntimeException;
import org.apache.brooklyn.policy.ha.HASensors;
import org.apache.brooklyn.policy.ha.ServiceRestarter;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Service Replacer", description="HA policy for replacing a failed member of a group")
public class ServiceReplacer
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceReplacer.class);
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> ENTITY_REPLACEMENT_FAILED = new BasicNotificationSensor(HASensors.FailureDescriptor.class, "ha.entityFailed.replacement", "Indicates that an entity replacement attempt has failed");
    @SetFromFlag(value="setOnFireOnFailure")
    public static final ConfigKey<Boolean> SET_ON_FIRE_ON_FAILURE = ConfigKeys.newBooleanConfigKey((String)"setOnFireOnFailure", (String)"Whether to set the entity as 'ON_FIRE' when failure is detected", (Boolean)true);
    @SetFromFlag(value="failureSensorToMonitor")
    public static final ConfigKey<Sensor> FAILURE_SENSOR_TO_MONITOR = new BasicConfigKey(Sensor.class, "failureSensorToMonitor", "The sensor, emitted by an entity, used to trigger its replacement. Defaults to 'ha.entityFailed.restart' (i.e. a 'ServiceRestarter' policy tried and failed to restart the entity)", ServiceRestarter.ENTITY_RESTART_FAILED);
    @SetFromFlag(value="failOnRecurringFailuresInThisDuration")
    public static final ConfigKey<Long> FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION = ConfigKeys.newLongConfigKey((String)"failOnRecurringFailuresInThisDuration", (String)"Abandon replace if replacement has failed many times within this time interval", (Long)300000L);
    @SetFromFlag(value="failOnNumRecurringFailures")
    public static final ConfigKey<Integer> FAIL_ON_NUM_RECURRING_FAILURES = ConfigKeys.newIntegerConfigKey((String)"failOnNumRecurringFailures", (String)"Abandon replace if replacement has failed this many times (100% of attempts) within the time interval", (Integer)5);
    @SetFromFlag(value="ticker")
    public static final ConfigKey<Ticker> TICKER = ConfigKeys.newConfigKey(Ticker.class, (String)"ticker", (String)"A time source (defaults to system-clock, which is almost certainly what's wanted, except in tests)", null);
    protected final List<Long> consecutiveReplacementFailureTimes = Lists.newCopyOnWriteArrayList();

    public void setEntity(final EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof MemberReplaceable), (String)"ServiceReplacer must take a MemberReplaceable, not %s", (Object[])new Object[]{entity});
        Sensor failureSensorToMonitor = (Sensor)Preconditions.checkNotNull((Object)this.getConfig(FAILURE_SENSOR_TO_MONITOR), (Object)"failureSensorToMonitor");
        super.setEntity(entity);
        this.subscriptions().subscribeToMembers((Group)entity, failureSensorToMonitor, (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(final SensorEvent<Object> event) {
                if (ServiceReplacer.this.isRunning()) {
                    ServiceReplacer.this.highlightViolation("Failure detected");
                    LOG.warn("ServiceReplacer notified; dispatching job for " + entity + " (" + event.getValue() + ")");
                    ((EntityInternal)entity).getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

                        @Override
                        public void run() {
                            ServiceReplacer.this.onDetectedFailure((SensorEvent<Object>)event);
                        }
                    });
                } else {
                    LOG.warn("ServiceReplacer not running, so not acting on failure detected at " + entity + " (" + event.getValue() + ", child of " + entity + ")");
                }
            }
        });
        this.highlightTriggers(failureSensorToMonitor, "members");
    }

    protected synchronized void onDetectedFailure(SensorEvent<Object> event) {
        Long timestamp;
        final Entity failedEntity = event.getSource();
        final Object reason = event.getValue();
        final String violationText = "Failure detected at " + failedEntity + (reason != null ? " (" + reason + ")" : "");
        if (this.isSuspended()) {
            this.highlightViolation(violationText + " but policy is suspended");
            LOG.warn("ServiceReplacer suspended, so not acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + ")");
            return;
        }
        Integer failOnNumRecurringFailures = (Integer)this.getConfig(FAIL_ON_NUM_RECURRING_FAILURES);
        long failOnRecurringFailuresInThisDuration = (Long)this.getConfig(FAIL_ON_RECURRING_FAILURES_IN_THIS_DURATION);
        long oldestPermitted = this.currentTimeMillis() - failOnRecurringFailuresInThisDuration;
        Iterator<Long> iter = this.consecutiveReplacementFailureTimes.iterator();
        while (iter.hasNext() && (timestamp = iter.next()) < oldestPermitted) {
            iter.remove();
        }
        if (this.consecutiveReplacementFailureTimes.size() >= failOnNumRecurringFailures) {
            this.highlightViolation(violationText + " but too many recent failures detected: " + this.consecutiveReplacementFailureTimes.size() + " in " + failOnRecurringFailuresInThisDuration + " exceeds limit of " + failOnNumRecurringFailures);
            LOG.error("ServiceReplacer not acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + "), because too many recent replacement failures");
            return;
        }
        this.highlightViolation(violationText + ", triggering restart");
        LOG.warn("ServiceReplacer acting on failure detected at " + failedEntity + " (" + reason + ", child of " + this.entity + ")");
        Task t = ((EntityInternal)this.entity).getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

            @Override
            public void run() {
                try {
                    Entities.invokeEffectorWithArgs((Entity)ServiceReplacer.this.entity, (Entity)ServiceReplacer.this.entity, (Effector)MemberReplaceable.REPLACE_MEMBER, (Object[])new Object[]{failedEntity.getId()}).get();
                    ServiceReplacer.this.consecutiveReplacementFailureTimes.clear();
                }
                catch (Exception e) {
                    if (Exceptions.getFirstThrowableOfType((Throwable)e, StopFailedRuntimeException.class) != null) {
                        LOG.info("ServiceReplacer: ignoring error reported from stopping failed node " + failedEntity);
                        return;
                    }
                    ServiceReplacer.this.highlightViolation(violationText + " and replace attempt failed: " + Exceptions.collapseText((Throwable)e));
                    ServiceReplacer.this.onReplacementFailed("Replace failure (" + Exceptions.collapseText((Throwable)e) + ") at " + ServiceReplacer.this.entity + ": " + reason);
                }
            }
        });
        this.highlightAction("Replacing " + failedEntity, t);
    }

    protected long currentTimeMillis() {
        Ticker ticker = (Ticker)this.getConfig(TICKER);
        return ticker == null ? System.currentTimeMillis() : TimeUnit.NANOSECONDS.toMillis(ticker.read());
    }

    protected void onReplacementFailed(String msg) {
        LOG.warn("ServiceReplacer failed for " + this.entity + ": " + msg);
        this.consecutiveReplacementFailureTimes.add(this.currentTimeMillis());
        if (((Boolean)this.getConfig(SET_ON_FIRE_ON_FAILURE)).booleanValue()) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((Entity)this.entity, (String)"ServiceReplacer", (Object)("replacement failed: " + msg));
        }
        this.entity.sensors().emit(ENTITY_REPLACEMENT_FAILED, (Object)new HASensors.FailureDescriptor(this.entity, msg));
    }
}

