/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.domain.LocationAndName;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.compute.functions.VirtualMachineToStatus;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.IpConfiguration;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkProfile;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.StorageProfile;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;

public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final GroupNamingConvention nodeNamingConvention;
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Map<String, ? extends Hardware>> hardwares;
    private final ImageCacheSupplier imageCache;
    private final VirtualMachineToStatus virtualMachineToStatus;

    @Inject
    VirtualMachineToNodeMetadata(AzureComputeApi api, GroupNamingConvention.Factory namingConvention, Supplier<Map<String, ? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> imageCache, VirtualMachineToStatus virtualMachineToStatus) {
        this.api = api;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.locations = locations;
        this.hardwares = hardwares;
        this.virtualMachineToStatus = virtualMachineToStatus;
        Preconditions.checkArgument((boolean)(imageCache instanceof ImageCacheSupplier), (Object)"This provider needs an instance of the ImageCacheSupplier");
        this.imageCache = (ImageCacheSupplier)imageCache;
    }

    public NodeMetadata apply(VirtualMachine virtualMachine) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(ResourceGroupAndName.fromResourceGroupAndName(IdReference.extractResourceGroup(virtualMachine.id()), virtualMachine.name()).slashEncode());
        builder.providerId(virtualMachine.id());
        builder.name(virtualMachine.name());
        builder.hostname(virtualMachine.name());
        VirtualMachineToStatus.StatusAndBackendStatus status = this.virtualMachineToStatus.apply(virtualMachine);
        builder.status(status.status());
        builder.backendStatus(status.backendStatus());
        builder.publicAddresses(this.getPublicIpAddresses(virtualMachine.properties().networkProfile().networkInterfaces()));
        builder.privateAddresses(this.getPrivateIpAddresses(virtualMachine.properties().networkProfile().networkInterfaces()));
        String groupFromMetadata = null;
        if (virtualMachine.tags() != null) {
            ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue((NodeMetadataBuilder)builder, virtualMachine.tags());
            groupFromMetadata = virtualMachine.tags().get("jclouds_group");
        }
        builder.group(groupFromMetadata != null ? groupFromMetadata : this.nodeNamingConvention.extractGroup(virtualMachine.name()));
        String locationName = virtualMachine.location();
        builder.location(VirtualMachineToNodeMetadata.getLocation(this.locations, locationName));
        Optional<? extends Image> image = this.findImage(virtualMachine.properties().storageProfile(), locationName);
        if (image.isPresent()) {
            builder.imageId(((Image)image.get()).getId());
            builder.operatingSystem(((Image)image.get()).getOperatingSystem());
        } else {
            this.logger.info(">> image with id %s for virtualmachine %s was not found. This might be because the image that was used to create the virtualmachine has a new id.", new Object[]{virtualMachine.id(), virtualMachine.id()});
        }
        builder.hardware(this.getHardware(LocationAndName.fromLocationAndName(virtualMachine.location(), virtualMachine.properties().hardwareProfile().vmSize())));
        return builder.build();
    }

    private Iterable<String> getPrivateIpAddresses(List<NetworkProfile.NetworkInterface> networkInterfaces) {
        ArrayList privateIpAddresses = Lists.newArrayList();
        for (NetworkProfile.NetworkInterface networkInterfaceCardIdReference : networkInterfaces) {
            NetworkInterfaceCard networkInterfaceCard = this.getNetworkInterfaceCard(networkInterfaceCardIdReference);
            if (networkInterfaceCard == null || networkInterfaceCard.properties() == null || networkInterfaceCard.properties().ipConfigurations() == null) continue;
            for (IpConfiguration ipConfiguration : networkInterfaceCard.properties().ipConfigurations()) {
                if (ipConfiguration.properties().privateIPAddress() == null) continue;
                privateIpAddresses.add(ipConfiguration.properties().privateIPAddress());
            }
        }
        return privateIpAddresses;
    }

    private NetworkInterfaceCard getNetworkInterfaceCard(NetworkProfile.NetworkInterface nic) {
        return this.api.getNetworkInterfaceCardApi(IdReference.extractResourceGroup(nic.id())).get(IdReference.extractName(nic.id()));
    }

    private Iterable<String> getPublicIpAddresses(List<NetworkProfile.NetworkInterface> networkInterfaces) {
        ArrayList publicIpAddresses = Lists.newArrayList();
        for (NetworkProfile.NetworkInterface networkInterfaceCardIdReference : networkInterfaces) {
            NetworkInterfaceCard networkInterfaceCard = this.getNetworkInterfaceCard(networkInterfaceCardIdReference);
            if (networkInterfaceCard == null || networkInterfaceCard.properties() == null || networkInterfaceCard.properties().ipConfigurations() == null) continue;
            for (IpConfiguration ipConfiguration : networkInterfaceCard.properties().ipConfigurations()) {
                IdReference publicIpId;
                PublicIPAddress publicIp;
                if (ipConfiguration.properties().publicIPAddress() == null || (publicIp = this.api.getPublicIPAddressApi((publicIpId = ipConfiguration.properties().publicIPAddress()).resourceGroup()).get(publicIpId.name())) == null || publicIp.properties().ipAddress() == null) continue;
                publicIpAddresses.add(publicIp.properties().ipAddress());
            }
        }
        return publicIpAddresses;
    }

    protected static Location getLocation(Supplier<Set<? extends Location>> locations, String locationName) {
        return (Location)Iterables.find((Iterable)((Iterable)locations.get()), (Predicate)LocationPredicates.idEquals((String)Strings.nullToEmpty((String)locationName)), null);
    }

    protected Optional<? extends Image> findImage(StorageProfile storageProfile, String locatioName) {
        if (storageProfile.imageReference() != null) {
            String imageId = storageProfile.imageReference().customImageId() != null ? storageProfile.imageReference().encodeFieldsToUniqueIdCustom(locatioName) : storageProfile.imageReference().encodeFieldsToUniqueId(locatioName);
            return this.imageCache.get(imageId);
        }
        this.logger.warn("could not find image for storage profile %s", new Object[]{storageProfile});
        return Optional.absent();
    }

    protected Hardware getHardware(LocationAndName hardwareId) {
        final String slashEncoded = hardwareId.slashEncode();
        return (Hardware)Iterables.find(((Map)this.hardwares.get()).values(), (Predicate)new Predicate<Hardware>(){

            public boolean apply(Hardware input) {
                return input.getId().equals(slashEncoded);
            }
        });
    }
}

