/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.AzureComputeService;
import org.jclouds.azurecompute.arm.compute.AzureComputeServiceAdapter;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndNameAndIngressRules;
import org.jclouds.azurecompute.arm.compute.extensions.AzureComputeImageExtension;
import org.jclouds.azurecompute.arm.compute.extensions.AzureComputeSecurityGroupExtension;
import org.jclouds.azurecompute.arm.compute.functions.LocationToLocation;
import org.jclouds.azurecompute.arm.compute.functions.NetworkSecurityGroupToSecurityGroup;
import org.jclouds.azurecompute.arm.compute.functions.NetworkSecurityRuleToIpPermission;
import org.jclouds.azurecompute.arm.compute.functions.VMHardwareToHardware;
import org.jclouds.azurecompute.arm.compute.functions.VMImageToImage;
import org.jclouds.azurecompute.arm.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.azurecompute.arm.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.azurecompute.arm.compute.loaders.DefaultResourceGroup;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.compute.strategy.CreateResourcesThenCreateNodes;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.ResourceDefinition;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.VMHardware;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineInstance;
import org.jclouds.azurecompute.arm.functions.ParseJobStatus;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.util.Predicates2;

public class AzureComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location>>(){}).to(AzureComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VMImage, org.jclouds.compute.domain.Image>>(){}).to(VMImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VMHardware, Hardware>>(){}).to(VMHardwareToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualMachine, NodeMetadata>>(){}).to(VirtualMachineToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.azurecompute.arm.domain.Location, Location>>(){}).to(LocationToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<NetworkSecurityGroup, SecurityGroup>>(){}).to(NetworkSecurityGroupToSecurityGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<NetworkSecurityRule, IpPermission>>(){}).to(NetworkSecurityRuleToIpPermission.class);
        this.bind(ComputeService.class).to(AzureComputeService.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location>(){});
        this.bind(TemplateOptions.class).to(AzureTemplateOptions.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateResourcesThenCreateNodes.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<ResourceGroupAndNameAndIngressRules, String>>(){}).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, ResourceGroup>>(){}).to(DefaultResourceGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(AzureComputeImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).to(AzureComputeSecurityGroupExtension.class);
    }

    @Provides
    @Singleton
    protected final LoadingCache<ResourceGroupAndNameAndIngressRules, String> securityGroupMap(CacheLoader<ResourceGroupAndNameAndIngressRules, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, ResourceGroup> defaultResourceGroup(CacheLoader<String, ResourceGroup> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected VirtualMachineInStatePredicateFactory provideVirtualMachineRunningPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VirtualMachineInStatePredicateFactory(api, VirtualMachineInstance.PowerState.RUNNING, timeouts.nodeRunning, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<URI> provideNodeTerminatedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<URI> provideImageCapturedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ImageCapturedPredicate(api), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.azurecompute.arm.timeout.resourcedeleted")
    protected Predicate<URI> provideResourceDeletedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected VirtualMachineInStatePredicateFactory provideNodeSuspendedPredicate(AzureComputeApi api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new VirtualMachineInStatePredicateFactory(api, VirtualMachineInstance.PowerState.STOPPED, timeouts.nodeTerminated, pollPeriod.pollInitialPeriod, pollPeriod.pollMaxPeriod);
    }

    @Provides
    protected PublicIpAvailablePredicateFactory providePublicIpAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
        return new PublicIpAvailablePredicateFactory(api, resourceAvailable);
    }

    @Provides
    protected SecurityGroupAvailablePredicateFactory provideSecurityGroupAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
        return new SecurityGroupAvailablePredicateFactory(api, resourceAvailable);
    }

    @Provides
    protected ImageAvailablePredicateFactory provideImageAvailablePredicate(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return new ImageAvailablePredicateFactory(api, (Predicate<Supplier<Provisionable>>)Predicates2.retry((Predicate)new ResourceInStatusPredicate("Succeeded"), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod));
    }

    @Provides
    protected Predicate<Supplier<Provisionable>> provideResourceAvailablePredicate(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ResourceInStatusPredicate("Succeeded"), (long)operationTimeout.intValue(), (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="STORAGE")
    protected Predicate<URI> provideStorageAccountAvailablePredicate(AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.operation.timeout") Integer operationTimeout, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)operationTimeout.intValue(), (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    public static class ImageAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        ImageAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String resourceGroup) {
            Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return ImageAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            Image img = ImageAvailablePredicateFactory.this.api.getVirtualMachineImageApi(resourceGroup).get(name);
                            return img == null ? null : img.properties();
                        }
                    });
                }
            };
        }
    }

    public static class SecurityGroupAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        SecurityGroupAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String resourceGroup) {
            Preconditions.checkNotNull((Object)resourceGroup, (Object)"resourceGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return SecurityGroupAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            NetworkSecurityGroup sg = SecurityGroupAvailablePredicateFactory.this.api.getNetworkSecurityGroupApi(resourceGroup).get(name);
                            return sg == null ? null : sg.properties();
                        }
                    });
                }
            };
        }
    }

    public static class PublicIpAvailablePredicateFactory {
        private final AzureComputeApi api;
        private final Predicate<Supplier<Provisionable>> resourceAvailable;

        PublicIpAvailablePredicateFactory(AzureComputeApi api, Predicate<Supplier<Provisionable>> resourceAvailable) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.resourceAvailable = resourceAvailable;
        }

        public Predicate<String> create(final String azureGroup) {
            Preconditions.checkNotNull((Object)azureGroup, (Object)"azureGroup cannot be null");
            return new Predicate<String>(){

                public boolean apply(final String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    return PublicIpAvailablePredicateFactory.this.resourceAvailable.apply((Object)new Supplier<Provisionable>(){

                        public Provisionable get() {
                            PublicIPAddress publicIp = PublicIpAvailablePredicateFactory.this.api.getPublicIPAddressApi(azureGroup).get(name);
                            return publicIp == null ? null : publicIp.properties();
                        }
                    });
                }
            };
        }
    }

    public static class ResourceInStatusPredicate
    implements Predicate<Supplier<Provisionable>> {
        private final String expectedStatus;

        ResourceInStatusPredicate(String expectedStatus) {
            this.expectedStatus = (String)Preconditions.checkNotNull((Object)expectedStatus, (Object)"expectedStatus cannot be null");
        }

        public boolean apply(Supplier<Provisionable> provisionableSupplier) {
            Preconditions.checkNotNull(provisionableSupplier, (Object)"provisionableSupplier supplier cannot be null");
            Provisionable provisionable = (Provisionable)provisionableSupplier.get();
            return provisionable != null && provisionable.provisioningState().equalsIgnoreCase(this.expectedStatus);
        }
    }

    public static class VirtualMachineInStatePredicateFactory {
        private final AzureComputeApi api;
        private final VirtualMachineInstance.PowerState powerState;
        private final long timeout;
        private final long period;
        private final long maxPeriod;

        VirtualMachineInStatePredicateFactory(AzureComputeApi api, VirtualMachineInstance.PowerState powerState, long timeout, long period, long maxPeriod) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api cannot be null");
            this.powerState = (VirtualMachineInstance.PowerState)((Object)Preconditions.checkNotNull((Object)((Object)powerState), (Object)"powerState cannot be null"));
            this.timeout = timeout;
            this.period = period;
            this.maxPeriod = maxPeriod;
        }

        public Predicate<String> create(final String azureGroup) {
            return Predicates2.retry((Predicate)new Predicate<String>(){

                public boolean apply(String name) {
                    Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
                    VirtualMachineInstance vmInstance = VirtualMachineInStatePredicateFactory.this.api.getVirtualMachineApi(azureGroup).getInstanceDetails(name);
                    if (vmInstance == null) {
                        return false;
                    }
                    return VirtualMachineInStatePredicateFactory.this.powerState == vmInstance.powerState();
                }
            }, (long)this.timeout, (long)this.period, (long)this.maxPeriod);
        }
    }

    @VisibleForTesting
    static class ImageCapturedPredicate
    implements Predicate<URI> {
        private final AzureComputeApi api;

        public ImageCapturedPredicate(AzureComputeApi api) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri cannot be null");
            if (this.api.getJobApi().jobStatus(uri) != ParseJobStatus.JobStatus.DONE) {
                return false;
            }
            List<ResourceDefinition> definitions = this.api.getJobApi().captureStatus(uri);
            return definitions != null;
        }
    }

    @VisibleForTesting
    static class ActionDonePredicate
    implements Predicate<URI> {
        private final AzureComputeApi api;

        public ActionDonePredicate(AzureComputeApi api) {
            this.api = (AzureComputeApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(URI uri) {
            Preconditions.checkNotNull((Object)uri, (Object)"uri cannot be null");
            return ParseJobStatus.JobStatus.DONE == this.api.getJobApi().jobStatus(uri) || ParseJobStatus.JobStatus.NO_CONTENT == this.api.getJobApi().jobStatus(uri);
        }
    }
}

