/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;

public class DigitalOcean2TemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<Integer> sshKeyIds = ImmutableSet.of();
    private boolean privateNetworking = false;
    private boolean backupsEnabled = false;
    private boolean autoCreateKeyPair = true;
    private byte[] userData;

    public DigitalOcean2TemplateOptions privateNetworking(boolean privateNetworking) {
        this.privateNetworking = privateNetworking;
        return this;
    }

    public DigitalOcean2TemplateOptions backupsEnabled(boolean backupsEnabled) {
        this.backupsEnabled = backupsEnabled;
        return this;
    }

    public DigitalOcean2TemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
        this.sshKeyIds = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(sshKeyIds, (Object)"sshKeyIds cannot be null")));
        return this;
    }

    public DigitalOcean2TemplateOptions autoCreateKeyPair(boolean autoCreateKeyPair) {
        this.autoCreateKeyPair = autoCreateKeyPair;
        return this;
    }

    public DigitalOcean2TemplateOptions userData(byte[] userData) {
        this.userData = userData;
        return this;
    }

    @Deprecated
    public TemplateOptions userMetadata(Map<String, String> userMetadata) {
        return super.userMetadata(userMetadata);
    }

    @Deprecated
    public TemplateOptions userMetadata(String key, String value) {
        return super.userMetadata(key, value);
    }

    @Deprecated
    public Map<String, String> getUserMetadata() {
        return super.getUserMetadata();
    }

    public Set<Integer> getSshKeyIds() {
        return this.sshKeyIds;
    }

    public boolean getPrivateNetworking() {
        return this.privateNetworking;
    }

    public boolean getBackupsEnabled() {
        return this.backupsEnabled;
    }

    public boolean getAutoCreateKeyPair() {
        return this.autoCreateKeyPair;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public DigitalOcean2TemplateOptions clone() {
        DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof DigitalOcean2TemplateOptions) {
            DigitalOcean2TemplateOptions eTo = (DigitalOcean2TemplateOptions)DigitalOcean2TemplateOptions.class.cast(to);
            eTo.privateNetworking(this.privateNetworking);
            eTo.backupsEnabled(this.backupsEnabled);
            eTo.autoCreateKeyPair(this.autoCreateKeyPair);
            eTo.sshKeyIds(this.sshKeyIds);
            if (null != this.getUserData()) {
                eTo.userData(this.getUserData());
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.backupsEnabled, this.privateNetworking, this.autoCreateKeyPair, this.sshKeyIds, Arrays.hashCode(this.userData)});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DigitalOcean2TemplateOptions other = (DigitalOcean2TemplateOptions)obj;
        return super.equals((Object)other) && Objects.equal((Object)this.backupsEnabled, (Object)other.backupsEnabled) && Objects.equal((Object)this.privateNetworking, (Object)other.privateNetworking) && Objects.equal((Object)this.autoCreateKeyPair, (Object)other.autoCreateKeyPair) && Objects.equal(this.sshKeyIds, other.sshKeyIds) && Arrays.equals(this.userData, other.userData);
    }

    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string().omitNullValues();
        toString.add("privateNetworking", this.privateNetworking);
        toString.add("backupsEnabled", this.backupsEnabled);
        if (!this.sshKeyIds.isEmpty()) {
            toString.add("sshKeyIds", this.sshKeyIds);
        }
        toString.add("autoCreateKeyPair", this.autoCreateKeyPair);
        toString.add("userData", (Object)this.userData);
        return toString;
    }

    public static class Builder {
        public static DigitalOcean2TemplateOptions privateNetworking(boolean privateNetworking) {
            DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
            return options.privateNetworking(privateNetworking);
        }

        public static DigitalOcean2TemplateOptions backupsEnabled(boolean backupsEnabled) {
            DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
            return options.backupsEnabled(backupsEnabled);
        }

        public static DigitalOcean2TemplateOptions sshKeyIds(Iterable<Integer> sshKeyIds) {
            DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
            return options.sshKeyIds(sshKeyIds);
        }

        public static DigitalOcean2TemplateOptions autoCreateKeyPair(boolean autoCreateKeyPair) {
            DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
            return options.autoCreateKeyPair(autoCreateKeyPair);
        }

        public static DigitalOcean2TemplateOptions userData(byte[] userData) {
            DigitalOcean2TemplateOptions options = new DigitalOcean2TemplateOptions();
            return options.userData(userData);
        }
    }
}

