/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.reflect.Invocation;

@Beta
public final class InvocationSuccess {
    private final Invocation invocation;
    private final Optional<Object> result;

    public static InvocationSuccess create(Invocation invocation, @Nullable Object result) {
        return new InvocationSuccess(invocation, (Optional<Object>)Optional.fromNullable((Object)result));
    }

    private InvocationSuccess(Invocation invocation, Optional<Object> result) {
        this.invocation = (Invocation)Preconditions.checkNotNull((Object)invocation, (Object)"invocation");
        this.result = (Optional)Preconditions.checkNotNull(result, (Object)"result");
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Optional<Object> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationSuccess that = (InvocationSuccess)InvocationSuccess.class.cast(o);
        return Objects.equal((Object)this.invocation, (Object)that.invocation) && Objects.equal((Object)this.result.orNull(), (Object)that.result.orNull());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.invocation, this.result.orNull()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("invocation", (Object)this.invocation).add("result", this.result.orNull());
    }
}

