/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.ssh.SshClient;

public class SudoAwareInitManager {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger computeLogger = Logger.NULL;
    protected Logger logger = Logger.NULL;
    protected NodeMetadata node;
    protected final String initFile;
    protected final InitScript init;
    protected final boolean runAsRoot;
    protected final Function<NodeMetadata, SshClient> sshFactory;
    protected SshClient ssh;

    public String getInitFile() {
        return this.initFile;
    }

    public SudoAwareInitManager(Function<NodeMetadata, SshClient> sshFactory, boolean runAsRoot, NodeMetadata node, InitScriptConfigurationForTasks initScriptConfiguration, InitScript init) {
        this.sshFactory = (Function)Preconditions.checkNotNull(sshFactory, (Object)"sshFactory");
        this.runAsRoot = runAsRoot;
        this.node = (NodeMetadata)Preconditions.checkNotNull((Object)node, (Object)"node");
        this.initFile = String.format(initScriptConfiguration.getInitScriptPattern(), init.getInstanceName());
        this.init = (InitScript)Preconditions.checkNotNull((Object)init, (Object)"init");
    }

    public SudoAwareInitManager init() {
        this.ssh = (SshClient)this.sshFactory.apply((Object)this.node);
        return this;
    }

    public ExecResponse refreshAndRunAction(String action) {
        Preconditions.checkState((this.ssh != null ? 1 : 0) != 0, (Object)"please call init() before invoking call");
        try {
            if (!this.ssh.isConnected()) {
                this.ssh.connect();
            }
            ExecResponse execResponse = this.runAction(action);
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    public ExecResponse runAction(String action) {
        String command = this.runAsRoot && Predicates.in((Collection)ImmutableSet.of((Object)"start", (Object)"stop", (Object)"run")).apply((Object)action) ? this.execScriptAsRoot(action) : this.execScriptAsDefaultUser(action);
        ExecResponse returnVal = this.runCommand(command);
        if (ImmutableSet.of((Object)"status", (Object)"stdout", (Object)"stderr").contains((Object)action)) {
            this.logger.trace("<< %s(%d)", new Object[]{action, returnVal.getExitStatus()});
        } else if (this.computeLogger.isTraceEnabled()) {
            this.computeLogger.trace("<< %s[%s]", new Object[]{action, returnVal});
        } else {
            this.computeLogger.debug("<< %s(%d)", new Object[]{action, returnVal.getExitStatus()});
        }
        return returnVal;
    }

    ExecResponse runCommand(String command) {
        String statement = String.format("[%s] as %s@%s", command.replace(this.node.getCredentials().getOptionalPassword().isPresent() ? (String)this.node.getCredentials().getOptionalPassword().get() : "XXXXX", "XXXXX"), this.ssh.getUsername(), this.ssh.getHostAddress());
        if (command.endsWith("status") || command.endsWith("stdout") || command.endsWith("stderr")) {
            this.logger.trace(">> running %s", new Object[]{statement});
        } else {
            this.computeLogger.debug(">> running " + statement, new Object[0]);
        }
        ExecResponse returnVal = this.ssh.exec(command);
        if (!command.endsWith("status")) {
            Preconditions.checkState((returnVal.getExitStatus() == 0 ? 1 : 0) != 0, (String)"error running %s; returnVal !=0: %s", (Object[])new Object[]{statement, returnVal});
        }
        return returnVal;
    }

    @VisibleForTesting
    String execScriptAsRoot(String action) {
        String command = this.node.getCredentials().identity.equals("root") ? this.initFile + " " + action : (this.node.getCredentials().shouldAuthenticateSudo() ? String.format("echo '%s'|sudo -S %s %s", this.node.getCredentials().getOptionalPassword().get(), this.initFile, action) : "sudo " + this.initFile + " " + action);
        return command;
    }

    protected String execScriptAsDefaultUser(String action) {
        return this.initFile + " " + action;
    }

    public NodeMetadata getNode() {
        return this.node;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("node", (Object)this.node.getId()).add("name", (Object)this.init.getInstanceName()).add("runAsRoot", this.runAsRoot).toString();
    }

    public InitScript getStatement() {
        return this.init;
    }
}

