/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.javax.annotation.Nullable;

public class Pod
implements Comparable<Pod> {
    private final String id;
    private final String name;
    private final String zoneId;
    private final String zoneName;
    private final String gateway;
    private final String netmask;
    private final String startIp;
    private final String endIp;
    private final AllocationState allocationState;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPod(this);
    }

    @ConstructorProperties(value={"id", "name", "zoneid", "zonename", "gateway", "netmask", "startip", "endip", "allocationstate"})
    protected Pod(String id, @Nullable String name, @Nullable String zoneId, @Nullable String zoneName, @Nullable String gateway, @Nullable String netmask, @Nullable String startIp, @Nullable String endIp, @Nullable AllocationState allocationState) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIp = startIp;
        this.endIp = endIp;
        this.allocationState = allocationState;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getStartIp() {
        return this.startIp;
    }

    @Nullable
    public String getEndIp() {
        return this.endIp;
    }

    @Nullable
    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.zoneId, this.zoneName, this.gateway, this.netmask, this.startIp, this.endIp, this.allocationState});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Pod that = (Pod)Pod.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.startIp, (Object)that.startIp) && Objects.equal((Object)this.endIp, (Object)that.endIp) && Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState));
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName).add("gateway", (Object)this.gateway).add("netmask", (Object)this.netmask).add("startIp", (Object)this.startIp).add("endIp", (Object)this.endIp).add("allocationState", (Object)this.allocationState);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Pod other) {
        return this.id.compareTo(other.id);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String zoneId;
        protected String zoneName;
        protected String gateway;
        protected String netmask;
        protected String startIp;
        protected String endIp;
        protected AllocationState allocationState;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public T gateway(String gateway) {
            this.gateway = gateway;
            return this.self();
        }

        public T netmask(String netmask) {
            this.netmask = netmask;
            return this.self();
        }

        public T startIp(String startIp) {
            this.startIp = startIp;
            return this.self();
        }

        public T endIp(String endIp) {
            this.endIp = endIp;
            return this.self();
        }

        public T allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this.self();
        }

        public Pod build() {
            return new Pod(this.id, this.name, this.zoneId, this.zoneName, this.gateway, this.netmask, this.startIp, this.endIp, this.allocationState);
        }

        public T fromPod(Pod in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).zoneId(in.getZoneId())).zoneName(in.getZoneName())).gateway(in.getGateway())).netmask(in.getNetmask())).startIp(in.getStartIp())).endIp(in.getEndIp())).allocationState(in.getAllocationState());
        }
    }
}

