/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.domain.internal.BoundedHashSet;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.internal.ContainerPropertiesImpl;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AccountNameEnumerationResultsHandler
extends ParseSax.HandlerWithResult<BoundedSet<ContainerProperties>> {
    private SortedSet<ContainerProperties> containerMetadata = Sets.newTreeSet();
    private String prefix;
    private String marker;
    private int maxResults;
    private String nextMarker;
    private String currentName;
    private Date currentLastModified;
    private String currentETag;
    private boolean inMetadata;
    private Map<String, String> currentMetadata = Maps.newHashMap();
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private URI accountUrl;

    @Inject
    public AccountNameEnumerationResultsHandler(DateService dateParser) {
        this.dateParser = dateParser;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Container")) {
            this.inMetadata = false;
        } else if (qName.equals("Metadata")) {
            this.inMetadata = true;
        } else if (qName.equals("EnumerationResults")) {
            this.accountUrl = URI.create(attributes.getValue("ServiceEndpoint").trim());
        }
    }

    public BoundedSet<ContainerProperties> getResult() {
        return new BoundedHashSet<ContainerProperties>(this.containerMetadata, this.accountUrl, this.prefix, this.marker, this.maxResults, this.nextMarker);
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inMetadata && !qName.equals("Metadata")) {
            this.currentMetadata.put(qName, this.currentText.toString().trim());
        } else if (qName.equals("Metadata")) {
            this.inMetadata = false;
        } else if (qName.equals("MaxResults")) {
            this.maxResults = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("Marker")) {
            this.marker = this.currentText.toString().trim();
            this.marker = this.marker.equals("") ? null : this.marker;
        } else if (qName.equals("Prefix")) {
            this.prefix = this.currentText.toString().trim();
            this.prefix = this.prefix.equals("") ? null : this.prefix;
        } else if (qName.equals("NextMarker")) {
            this.nextMarker = this.currentText.toString().trim();
            this.nextMarker = this.nextMarker.equals("") ? null : this.nextMarker;
        } else if (qName.equals("Container")) {
            URI currentUrl;
            try {
                currentUrl = new URI(this.accountUrl.getScheme(), this.accountUrl.getHost(), "/" + this.currentName, null);
            }
            catch (URISyntaxException use) {
                throw Throwables.propagate((Throwable)use);
            }
            this.containerMetadata.add(new ContainerPropertiesImpl(currentUrl, this.currentLastModified, this.currentETag, this.currentMetadata));
            this.currentName = null;
            this.currentLastModified = null;
            this.currentETag = null;
            this.currentMetadata = Maps.newHashMap();
        } else if (qName.equals("Name")) {
            this.currentName = this.currentText.toString().trim();
        } else if (qName.equals("Last-Modified")) {
            this.currentLastModified = this.dateParser.rfc822DateParse(this.currentText.toString().trim());
        } else if (qName.equals("Etag")) {
            this.currentETag = this.currentText.toString().trim();
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

