/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.options;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.domain.ListBlobsInclude;

public class ListBlobsOptions
extends ListOptions {
    private Set<String> datasets;

    public ListBlobsOptions delimiter(String delimiter) {
        this.queryParameters.put((Object)"delimiter", (Object)delimiter);
        return this;
    }

    public String getDelimiter() {
        return this.getFirstQueryOrNull("delimiter");
    }

    @Override
    public ListBlobsOptions includeMetadata() {
        return (ListBlobsOptions)super.includeMetadata();
    }

    @Override
    public ListBlobsOptions marker(String marker) {
        return (ListBlobsOptions)super.marker(marker);
    }

    @Override
    public ListBlobsOptions maxResults(int maxresults) {
        return (ListBlobsOptions)super.maxResults(maxresults);
    }

    @Override
    public ListBlobsOptions prefix(String prefix) {
        return (ListBlobsOptions)super.prefix(prefix);
    }

    public ListBlobsOptions include(Set<ListBlobsInclude> datasets) {
        datasets = ImmutableSet.copyOf(datasets);
        this.queryParameters.put((Object)"include", (Object)Joiner.on((String)",").join((Iterable)datasets));
        return this;
    }

    public Set<String> getInclude() {
        return this.datasets;
    }

    public static class Builder {
        public static ListBlobsOptions delimiter(String delimiter) {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.delimiter(delimiter);
        }

        public static ListBlobsOptions includeMetadata() {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.includeMetadata();
        }

        public static ListBlobsOptions prefix(String prefix) {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.prefix(prefix);
        }

        public static ListBlobsOptions marker(String marker) {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.marker(marker);
        }

        public static ListBlobsOptions maxResults(int maxKeys) {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.maxResults(maxKeys);
        }

        public static ListBlobsOptions include(Set<ListBlobsInclude> datasets) {
            ListBlobsOptions options = new ListBlobsOptions();
            return options.include(datasets);
        }
    }
}

