/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;

public class ToListContainerOptions
implements Function<org.jclouds.blobstore.options.ListContainerOptions, ListContainerOptions> {
    public ListContainerOptions apply(org.jclouds.blobstore.options.ListContainerOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        if (from.getDir() != null && from.getPrefix() != null) {
            throw new IllegalArgumentException("Cannot set both directory and prefix");
        }
        if ((from.getDir() != null || from.isRecursive()) && from.getDelimiter() != null) {
            throw new IllegalArgumentException("Cannot set both delimiter and recursive or directory");
        }
        ListContainerOptions options = new ListContainerOptions();
        if (from.getDir() != null) {
            if (from.isRecursive()) {
                options.prefix(from.getDir().endsWith("/") ? from.getDir() : from.getDir() + "/");
            } else {
                options.path(from.getDir());
            }
        } else if (!from.isRecursive()) {
            options.delimiter('/');
        }
        if (from.getDelimiter() != null) {
            if (from.getDelimiter().length() != 1) {
                throw new IllegalArgumentException("Delimiter must be a single character");
            }
            options.delimiter(from.getDelimiter().charAt(0));
        }
        if (from.getPrefix() != null) {
            options.prefix(from.getPrefix());
        }
        if (from.getMarker() != null) {
            options.marker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            options.limit(from.getMaxResults());
        }
        return options;
    }
}

