/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import java.util.Map;
import org.jclouds.docker.domain.Network;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_Network
extends Network {
    private final String name;
    private final String id;
    private final String scope;
    private final String driver;
    private final Network.IPAM ipam;
    private final Map<String, Network.Details> containers;
    private final Map<String, String> options;

    private AutoValue_Network(@Nullable String name, @Nullable String id, @Nullable String scope, @Nullable String driver, @Nullable Network.IPAM ipam, @Nullable Map<String, Network.Details> containers, @Nullable Map<String, String> options) {
        this.name = name;
        this.id = id;
        this.scope = scope;
        this.driver = driver;
        this.ipam = ipam;
        this.containers = containers;
        this.options = options;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String scope() {
        return this.scope;
    }

    @Override
    @Nullable
    public String driver() {
        return this.driver;
    }

    @Override
    @Nullable
    public Network.IPAM ipam() {
        return this.ipam;
    }

    @Override
    @Nullable
    public Map<String, Network.Details> containers() {
        return this.containers;
    }

    @Override
    @Nullable
    public Map<String, String> options() {
        return this.options;
    }

    public String toString() {
        return "Network{name=" + this.name + ", " + "id=" + this.id + ", " + "scope=" + this.scope + ", " + "driver=" + this.driver + ", " + "ipam=" + this.ipam + ", " + "containers=" + this.containers + ", " + "options=" + this.options + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Network) {
            Network that = (Network)o;
            return (this.name == null ? that.name() == null : this.name.equals(that.name())) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.scope == null ? that.scope() == null : this.scope.equals(that.scope())) && (this.driver == null ? that.driver() == null : this.driver.equals(that.driver())) && (this.ipam == null ? that.ipam() == null : this.ipam.equals(that.ipam())) && (this.containers == null ? that.containers() == null : this.containers.equals(that.containers())) && (this.options == null ? that.options() == null : this.options.equals(that.options()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name == null ? 0 : this.name.hashCode();
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.scope == null ? 0 : this.scope.hashCode();
        h *= 1000003;
        h ^= this.driver == null ? 0 : this.driver.hashCode();
        h *= 1000003;
        h ^= this.ipam == null ? 0 : this.ipam.hashCode();
        h *= 1000003;
        h ^= this.containers == null ? 0 : this.containers.hashCode();
        h *= 1000003;
        return h ^= this.options == null ? 0 : this.options.hashCode();
    }

    static final class Builder
    extends Network.Builder {
        private String name;
        private String id;
        private String scope;
        private String driver;
        private Network.IPAM ipam;
        private Map<String, Network.Details> containers;
        private Map<String, String> options;

        Builder() {
        }

        Builder(Network source) {
            this.name = source.name();
            this.id = source.id();
            this.scope = source.scope();
            this.driver = source.driver();
            this.ipam = source.ipam();
            this.containers = source.containers();
            this.options = source.options();
        }

        @Override
        public Network.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Network.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Network.Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public Network.Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        @Override
        public Network.Builder ipam(Network.IPAM ipam) {
            this.ipam = ipam;
            return this;
        }

        @Override
        public Network.Builder containers(Map<String, Network.Details> containers) {
            this.containers = containers;
            return this;
        }

        @Override
        public Map<String, Network.Details> containers() {
            return this.containers;
        }

        @Override
        public Network.Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        @Override
        public Map<String, String> options() {
            return this.options;
        }

        @Override
        public Network autoBuild() {
            return new AutoValue_Network(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, this.options);
        }
    }
}

