/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.util;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import java.util.List;
import java.util.regex.Pattern;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.util.MacAddresses;
import org.jclouds.profitbricks.util.Passwords;

public final class Preconditions {
    private static final Pattern INVALID_CHARS = Pattern.compile("^.*[@/\\|'`\u2019^].*$");

    public static void checkInvalidChars(String name) {
        com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is required.");
        com.google.common.base.Preconditions.checkArgument((!INVALID_CHARS.matcher(name).matches() ? 1 : 0) != 0, (Object)"Name must not contain any of: @ / \\ | ' ` \u2019 ^");
    }

    public static void checkIp(String ip) {
        com.google.common.base.Preconditions.checkArgument((boolean)InetAddresses.isInetAddress((String)ip), (String)"IP '%s' is invalid", (Object[])new Object[]{ip});
    }

    public static void checkIps(List<String> ips) {
        com.google.common.base.Preconditions.checkNotNull(ips, (Object)"Null ip list");
        for (String ip : ips) {
            Preconditions.checkIp(ip);
        }
    }

    public static void checkPortRange(Integer portRangeStart, Integer portRangeEnd, Firewall.Protocol protocol) {
        com.google.common.base.Preconditions.checkArgument((!(portRangeEnd == null ^ portRangeStart == null) ? 1 : 0) != 0, (Object)"Port range must be both present or null");
        if (portRangeEnd != null) {
            com.google.common.base.Preconditions.checkArgument((protocol == Firewall.Protocol.TCP || protocol == Firewall.Protocol.UDP ? 1 : 0) != 0, (Object)"Port range can only be set for TCP or UDP");
            com.google.common.base.Preconditions.checkArgument((portRangeEnd > portRangeStart ? 1 : 0) != 0, (Object)"portRangeEnd must be greater than portRangeStart");
            com.google.common.base.Preconditions.checkArgument((portRangeEnd >= 1 && portRangeEnd <= 65534 ? 1 : 0) != 0, (Object)"Port range end must be 1 to 65534");
            com.google.common.base.Preconditions.checkArgument((portRangeStart >= 1 && portRangeStart <= 65534 ? 1 : 0) != 0, (Object)"Port range start must be 1 to 65534");
        }
    }

    public static void checkMacAddress(String macAddress) {
        com.google.common.base.Preconditions.checkArgument((boolean)MacAddresses.isMacAddress(macAddress), (Object)"MAC must match pattern 'aa:bb:cc:dd:ee:ff'");
    }

    public static void checkIcmp(Integer icmpType, Integer icmpCode, Firewall.Protocol protocol) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)protocol), (Object)"Protocol can't be null");
        if (protocol == Firewall.Protocol.ICMP) {
            if (icmpType != null) {
                com.google.common.base.Preconditions.checkArgument((icmpType >= 1 && icmpType <= 254 ? 1 : 0) != 0, (Object)"ICMP type must be 1 to 254");
            }
            if (icmpCode != null) {
                com.google.common.base.Preconditions.checkArgument((icmpCode >= 1 && icmpCode <= 254 ? 1 : 0) != 0, (Object)"ICMP code must be 1 to 254");
            }
        }
    }

    public static void checkLanId(Integer id) {
        com.google.common.base.Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"LAN ID must be non-negative");
    }

    public static void checkCores(Integer cores) {
        com.google.common.base.Preconditions.checkArgument((cores > 0 ? 1 : 0) != 0, (Object)"Number of cores must be atleast 1.");
    }

    public static void checkRam(Integer ram, Boolean isRamHotPlug) {
        int minRam = isRamHotPlug == null || isRamHotPlug == false ? 256 : 1024;
        com.google.common.base.Preconditions.checkArgument((ram >= minRam && ram % 256 == 0 ? 1 : 0) != 0, (Object)"RAM must be multiples of 256 with minimum of 256 MB (1024 MB if ramHotPlug is enabled)");
    }

    public static void checkSize(Float size) {
        com.google.common.base.Preconditions.checkArgument((size.floatValue() > 1.0f ? 1 : 0) != 0, (Object)"Storage size must be > 1GB");
    }

    public static void checkPassword(String password) {
        com.google.common.base.Preconditions.checkArgument((boolean)Passwords.isValidPassword(password), (Object)"Password must be between 8 and 50 characters, only a-z, A-Z, 0-9 without  characters i, I, l, o, O, w, W, y, Y, z, Z and 1, 0");
    }
}

