/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.nic;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;
import org.jclouds.profitbricks.http.parser.firewall.FirewallResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseNicResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected final FirewallResponseHandler firewallResponseHandler;
    protected boolean useFirewallParser = false;
    protected Nic.Builder builder = Nic.builder();
    protected List<String> ips;

    @Inject
    BaseNicResponseHandler(FirewallResponseHandler firewallResponseHandler) {
        this.firewallResponseHandler = firewallResponseHandler;
        this.ips = new ArrayList<String>();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("firewall".equals(qName)) {
            this.useFirewallParser = true;
        }
        if (this.useFirewallParser) {
            this.firewallResponseHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.useFirewallParser) {
            this.firewallResponseHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("dataCenterId".equals(qName)) {
            this.builder.dataCenterId(this.textToStringValue());
        } else if ("nicName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("nicId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("lanId".equals(qName)) {
            this.builder.lanId(this.textToIntValue());
        } else if ("internetAccess".equals(qName)) {
            this.builder.internetAccess(this.textToBooleanValue());
        } else if ("serverId".equals(qName)) {
            this.builder.serverId(this.textToStringValue());
        } else if ("ips".equals(qName)) {
            this.ips.add(this.textToStringValue());
        } else if ("macAddress".equals(qName)) {
            this.builder.macAddress(this.textToStringValue());
        } else if ("dhcpActive".equals(qName)) {
            this.builder.dhcpActive(this.textToBooleanValue());
        } else if ("gatewayIp".equals(qName)) {
            this.builder.gatewayIp(this.textToStringValue());
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        }
    }
}

