/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.windows;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorTasks;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.feed.windows.WindowsPerformanceCounterPollConfig;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsPerformanceCounterFeed
extends AbstractFeed {
    private static final Logger log = LoggerFactory.getLogger(WindowsPerformanceCounterFeed.class);
    protected static final Pattern lineWithPerfData = Pattern.compile("^\"[\\d:/\\-. ]+\",\".*\"$", 8);
    private static final Joiner JOINER_ON_SPACE = Joiner.on((char)' ');
    private static final Joiner JOINER_ON_COMMA = Joiner.on((char)',');
    private static final int OUTPUT_COLUMN_WIDTH = 100;
    public static final ConfigKey<Collection<WindowsPerformanceCounterPollConfig<?>>> POLLS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<WindowsPerformanceCounterPollConfig<?>>>(){}, (String)"polls");

    public static Builder builder() {
        return new Builder();
    }

    public WindowsPerformanceCounterFeed() {
    }

    protected WindowsPerformanceCounterFeed(Builder builder) {
        ArrayList polls = Lists.newArrayList();
        for (WindowsPerformanceCounterPollConfig config : builder.polls) {
            if (!config.isEnabled()) continue;
            WindowsPerformanceCounterPollConfig configCopy = new WindowsPerformanceCounterPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            polls.add(configCopy);
        }
        this.config().set(POLLS, (Object)polls);
        this.initUniqueTag(builder.uniqueTag, new Object[]{polls});
    }

    protected void preStart() {
        Collection polls = (Collection)this.getConfig(POLLS);
        long minPeriod = Integer.MAX_VALUE;
        ArrayList performanceCounterNames = Lists.newArrayList();
        for (WindowsPerformanceCounterPollConfig config : polls) {
            minPeriod = Math.min(minPeriod, config.getPeriod());
            performanceCounterNames.add(config.getPerformanceCounterName());
        }
        ImmutableList allParams = ImmutableList.builder().add((Object)"$ProgressPreference = \"SilentlyContinue\";").add((Object)"(Get-Counter").add((Object)"-Counter").add((Object)JOINER_ON_COMMA.join(Iterables.transform((Iterable)performanceCounterNames, (Function)QuoteStringFunction.INSTANCE))).add((Object)"-SampleInterval").add((Object)"2").add((Object)").CounterSamples").add((Object)"|").add((Object)"Format-Table").add((Object)String.format("@{Expression={$_.Path};width=%d},@{Expression={$_.CookedValue};width=%<d}", 100)).add((Object)"-HideTableHeaders").add((Object)"|").add((Object)"Out-String").add((Object)"-Width").add((Object)String.valueOf(200)).build();
        String command = JOINER_ON_SPACE.join((Iterable)allParams);
        log.debug("Windows performance counter poll command for {} will be: {}", (Object)this.entity, (Object)command);
        GetPerformanceCountersJob job = new GetPerformanceCountersJob((Entity)this.getEntity(), command);
        this.getPoller().scheduleAtFixedRate(new CallInEntityExecutionContext((Entity)this.entity, job), (PollHandler)new SendPerfCountersToSensors((Entity)this.getEntity(), polls), minPeriod);
    }

    protected Poller<WinRmToolResponse> getPoller() {
        return super.getPoller();
    }

    private static enum QuoteStringFunction implements Function<String, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nullable String input) {
            return input != null ? "\"" + input + "\"" : null;
        }
    }

    static class PerfCounterValueIterator
    implements Iterator<String> {
        protected static final Pattern splitPerfData = Pattern.compile("^\"([^\\\"]*)\"((,\"[^\\\"]*\")*)$");
        private Matcher matcher;

        public PerfCounterValueIterator(String input) {
            this.matcher = splitPerfData.matcher(input);
            Preconditions.checkArgument((boolean)this.hasNext(), (Object)("input " + input + " does not match expected pattern " + splitPerfData.pattern()));
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.matcher != null && this.matcher.find();
        }

        @Override
        public String next() {
            String next = this.matcher.group(1);
            String remainder = this.matcher.group(2);
            if (!Strings.isNullOrEmpty((String)remainder)) {
                assert (remainder.startsWith(","));
                remainder = remainder.substring(1);
                this.matcher = splitPerfData.matcher(remainder);
            } else {
                this.matcher = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    static class SendPerfCountersToSensors
    implements PollHandler<WinRmToolResponse> {
        private final Entity entity;
        private final List<WindowsPerformanceCounterPollConfig<?>> polls;
        private final Set<AttributeSensor<?>> failedAttributes = Sets.newLinkedHashSet();
        private static final Pattern MACHINE_NAME_LOOKBACK_PATTERN = Pattern.compile(String.format("(?<=\\\\\\\\.{0,%d})\\\\.*", 100));

        public SendPerfCountersToSensors(Entity entity, Collection<WindowsPerformanceCounterPollConfig<?>> polls) {
            this.entity = entity;
            this.polls = ImmutableList.copyOf(polls);
        }

        public boolean checkSuccess(WinRmToolResponse val) {
            if (val == null || val.getStatusCode() != 0) {
                return false;
            }
            String stderr = val.getStdErr();
            if (stderr == null || stderr.length() != 0) {
                return false;
            }
            String out = val.getStdOut();
            return out != null && out.length() != 0;
        }

        public void onSuccess(WinRmToolResponse val) {
            for (String pollResponse : val.getStdOut().split("\r\n")) {
                String path;
                Matcher machineNameLookbackMatcher;
                if (Strings.isNullOrEmpty((String)pollResponse) || !(machineNameLookbackMatcher = MACHINE_NAME_LOOKBACK_PATTERN.matcher(path = pollResponse.substring(0, 99))).find()) continue;
                String name = machineNameLookbackMatcher.group(0).trim();
                String rawValue = pollResponse.substring(100).replaceAll("^\\s+", "");
                WindowsPerformanceCounterPollConfig<?> config = this.getPollConfig(name);
                Class clazz = config.getSensor().getType();
                AttributeSensor attribute = Sensors.newSensor((Class)clazz, (String)config.getSensor().getName(), (String)config.getDescription());
                try {
                    Object value = TypeCoercions.coerce((Object)rawValue, (TypeToken)TypeToken.of((Class)clazz));
                    this.entity.sensors().set(attribute, value);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (this.failedAttributes.add(attribute)) {
                        log.warn("Failed to coerce value '{}' to {} for {} -> {}", new Object[]{rawValue, clazz, this.entity, attribute});
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Failed (repeatedly) to coerce value '{}' to {} for {} -> {}", new Object[]{rawValue, clazz, this.entity, attribute});
                }
            }
        }

        public void onFailure(WinRmToolResponse val) {
            if (val == null) {
                log.trace("Windows Performance Counter not executed since there is still now WinRmMachineLocation");
                return;
            }
            log.error("Windows Performance Counter query did not respond as expected. exitcode={} stdout={} stderr={}", new Object[]{val.getStatusCode(), val.getStdOut(), val.getStdErr()});
            for (WindowsPerformanceCounterPollConfig<?> config : this.polls) {
                Class clazz = config.getSensor().getType();
                AttributeSensor attribute = Sensors.newSensor((Class)clazz, (String)config.getSensor().getName(), (String)config.getDescription());
                this.entity.sensors().set(attribute, null);
            }
        }

        public void onException(Exception exception) {
            log.error("Detected exception while retrieving Windows Performance Counters from entity " + this.entity.getDisplayName(), (Throwable)exception);
            for (WindowsPerformanceCounterPollConfig<?> config : this.polls) {
                this.entity.sensors().set(Sensors.newSensor(config.getSensor().getClass(), (String)config.getPerformanceCounterName(), (String)config.getDescription()), null);
            }
        }

        public String getDescription() {
            return "" + this.polls;
        }

        public String toString() {
            return super.toString() + "[" + this.getDescription() + "]";
        }

        private WindowsPerformanceCounterPollConfig<?> getPollConfig(String sensorName) {
            for (WindowsPerformanceCounterPollConfig<?> poll : this.polls) {
                if (!poll.getPerformanceCounterName().equalsIgnoreCase(sensorName)) continue;
                return poll;
            }
            throw new IllegalStateException(String.format("%s not found in configured polls: %s", sensorName, this.polls));
        }
    }

    private static class CallInEntityExecutionContext<T>
    implements Callable<T> {
        private final Callable<T> job;
        private Entity entity;

        private CallInEntityExecutionContext(Entity entity, Callable<T> job) {
            this.job = job;
            this.entity = entity;
        }

        @Override
        public T call() throws Exception {
            ExecutionContext executionContext = ((EntityInternal)this.entity).getExecutionContext();
            return (T)executionContext.submit((Map)Maps.newHashMap(), this.job).get();
        }
    }

    private static class GetPerformanceCountersJob<T>
    implements Callable<T> {
        private final Entity entity;
        private final String command;

        GetPerformanceCountersJob(Entity entity, String command) {
            this.entity = entity;
            this.command = command;
        }

        @Override
        public T call() throws Exception {
            Maybe machineLocationMaybe = Machines.findUniqueMachineLocation((Iterable)this.entity.getLocations(), WinRmMachineLocation.class);
            if (machineLocationMaybe.isAbsent()) {
                return null;
            }
            WinRmMachineLocation machine = (WinRmMachineLocation)EffectorTasks.getMachine((Entity)this.entity, WinRmMachineLocation.class);
            WinRmToolResponse response = machine.executePsScript(this.command);
            return (T)response;
        }
    }

    public static class Builder {
        private Entity entity;
        private Set<WindowsPerformanceCounterPollConfig<?>> polls = Sets.newLinkedHashSet();
        private Duration period = Duration.of((long)30L, (TimeUnit)TimeUnit.SECONDS);
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = (Entity)Preconditions.checkNotNull((Object)val, (Object)"entity");
            return this;
        }

        public Builder addSensor(WindowsPerformanceCounterPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder addSensor(String performanceCounterName, AttributeSensor<?> sensor) {
            return this.addSensor(new WindowsPerformanceCounterPollConfig(sensor).performanceCounterName((String)Preconditions.checkNotNull((Object)performanceCounterName, (Object)"performanceCounterName")));
        }

        public Builder addSensors(Map<String, AttributeSensor> sensors) {
            for (Map.Entry<String, AttributeSensor> entry : sensors.entrySet()) {
                this.addSensor(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder period(Duration period) {
            this.period = (Duration)Preconditions.checkNotNull((Object)period, (Object)"period");
            return this;
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public WindowsPerformanceCounterFeed build() {
            this.built = true;
            WindowsPerformanceCounterFeed result = new WindowsPerformanceCounterFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)((EntityLocal)this.entity), (Object)"entity"));
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("WindowsPerformanceCounterFeed.Builder created, but build() never called");
            }
        }
    }
}

