/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/floating_ips/api/v1.1", name="FloatingIps", alias="os-floating-ips")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface FloatingIPApi {
    @Named(value="floatingIP:list")
    @GET
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ips"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<FloatingIP> list();

    @Named(value="floatingIP:get")
    @GET
    @Path(value="/os-floating-ips/{id}")
    @SelectJson(value={"floating_ip"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FloatingIP get(@PathParam(value="id") String var1);

    @Named(value="floatingIP:create")
    @POST
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ip"})
    @Produces(value={"application/json"})
    @Payload(value="{}")
    @Nullable
    public FloatingIP create();

    @Named(value="floatingIP:allocateFromPool")
    @POST
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ip"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"pool\":\"{pool}\"%7D")
    @Nullable
    public FloatingIP allocateFromPool(@PayloadParam(value="pool") String var1);

    @Named(value="floatingIP:delete")
    @DELETE
    @Path(value="/os-floating-ips/{id}")
    public void delete(@PathParam(value="id") String var1);

    @Named(value="floatingIP:add")
    @POST
    @Path(value="/servers/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"addFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public void addToServer(@PayloadParam(value="address") String var1, @PathParam(value="id") String var2);

    @Named(value="floatingIP:remove")
    @POST
    @Path(value="/servers/{id}/action")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"removeFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public void removeFromServer(@PayloadParam(value="address") String var1, @PathParam(value="id") String var2);
}

