/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerWithSecurityGroups;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.extensions.ServerWithSecurityGroupsApi;

@Singleton
public class CleanupServer
implements Function<String, Boolean> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<RegionAndName, SecurityGroupInRegion> securityGroupMap;
    protected final LoadingCache<RegionAndName, KeyPair> keyPairCache;

    @Inject
    public CleanupServer(NovaApi novaApi, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<RegionAndName, SecurityGroupInRegion> securityGroupMap, LoadingCache<RegionAndName, KeyPair> keyPairCache) {
        this.novaApi = novaApi;
        this.removeFloatingIpFromNodeAndDeallocate = removeFloatingIpFromNodeAndDeallocate;
        this.securityGroupMap = (LoadingCache)Preconditions.checkNotNull(securityGroupMap, (Object)"securityGroupMap");
        this.keyPairCache = (LoadingCache)Preconditions.checkNotNull(keyPairCache, (Object)"keyPairCache");
    }

    public Boolean apply(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        boolean secGroupsPresent = this.novaApi.getServerWithSecurityGroupsApi(regionAndId.getRegion()).isPresent();
        Server server = secGroupsPresent ? ((ServerWithSecurityGroupsApi)this.novaApi.getServerWithSecurityGroupsApi(regionAndId.getRegion()).get()).get(regionAndId.getId()) : this.novaApi.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
        if (this.novaApi.getFloatingIPApi(regionAndId.getRegion()).isPresent()) {
            try {
                this.removeFloatingIpFromNodeAndDeallocate.apply(regionAndId);
            }
            catch (RuntimeException e) {
                this.logger.warn((Throwable)e, "<< error removing and deallocating ip from node(%s): %s", new Object[]{id, e.getMessage()});
            }
        }
        if (this.containsMetadata(server, "jclouds_keyPair") && this.novaApi.getKeyPairApi(regionAndId.getRegion()).isPresent()) {
            RegionAndName regionAndName = RegionAndName.fromRegionAndName(regionAndId.getRegion(), server.getKeyName());
            this.logger.debug(">> deleting keypair(%s)", new Object[]{regionAndName});
            ((KeyPairApi)this.novaApi.getKeyPairApi(regionAndId.getRegion()).get()).delete(server.getKeyName());
            this.keyPairCache.invalidate((Object)regionAndName);
            this.logger.debug("<< deleted keypair(%s)", new Object[]{regionAndName});
        }
        boolean serverDeleted = this.novaApi.getServerApi(regionAndId.getRegion()).delete(regionAndId.getId());
        if (this.containsMetadata(server, "jclouds_securityGroup") && secGroupsPresent) {
            for (String securityGroupName : ((ServerWithSecurityGroups)server).getSecurityGroupNames()) {
                for (SecurityGroup securityGroup : ((SecurityGroupApi)this.novaApi.getSecurityGroupApi(regionAndId.getRegion()).get()).list().toList()) {
                    if (!securityGroup.getName().equalsIgnoreCase(securityGroupName) || !this.novaApi.getSecurityGroupApi(regionAndId.getRegion()).isPresent()) continue;
                    RegionAndName regionAndName = RegionAndName.fromRegionAndName(regionAndId.getRegion(), securityGroup.getName());
                    this.logger.debug(">> deleting securityGroup(%s)", new Object[]{regionAndName});
                    ((SecurityGroupApi)this.novaApi.getSecurityGroupApi(regionAndId.getRegion()).get()).delete(securityGroup.getId());
                    this.securityGroupMap.invalidate((Object)regionAndName);
                    this.logger.debug("<< deleted securityGroup(%s)", new Object[]{regionAndName});
                }
            }
        }
        return serverDeleted;
    }

    private boolean containsMetadata(Server server, String key) {
        if (server == null || server.getMetadata() == null || server.getMetadata().get("jclouds_tags") == null) {
            return false;
        }
        return server.getMetadata().get("jclouds_tags").contains(key);
    }
}

