/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.brooklyn.rest.domain.HasId;
import org.apache.brooklyn.rest.domain.LinkWithMetadata;
import org.apache.brooklyn.util.collections.Jsonya;

public class TaskSummary
implements HasId,
Serializable {
    private static final long serialVersionUID = 4637850742127078158L;
    private final String id;
    private final String displayName;
    private final String entityId;
    private final String entityDisplayName;
    private final String description;
    private final Collection<Object> tags;
    private final Long submitTimeUtc;
    private final Long startTimeUtc;
    private final Long endTimeUtc;
    private final String currentStatus;
    private final Object result;
    private final boolean isError;
    private final boolean isCancelled;
    private final List<LinkWithMetadata> children;
    private final LinkWithMetadata submittedByTask;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final LinkWithMetadata blockingTask;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String blockingDetails;
    private final String detailedStatus;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, LinkWithMetadata> streams;
    private final Map<String, URI> links;

    public TaskSummary(@JsonProperty(value="id") String id, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="entityId") String entityId, @JsonProperty(value="entityDisplayName") String entityDisplayName, @JsonProperty(value="tags") Set<Object> tags, @JsonProperty(value="submitTimeUtc") Long submitTimeUtc, @JsonProperty(value="startTimeUtc") Long startTimeUtc, @JsonProperty(value="endTimeUtc") Long endTimeUtc, @JsonProperty(value="currentStatus") String currentStatus, @JsonProperty(value="result") Object result, @JsonProperty(value="isError") boolean isError, @JsonProperty(value="isCancelled") boolean isCancelled, @JsonProperty(value="children") List<LinkWithMetadata> children, @JsonProperty(value="submittedByTask") LinkWithMetadata submittedByTask, @JsonProperty(value="blockingTask") LinkWithMetadata blockingTask, @JsonProperty(value="blockingDetails") String blockingDetails, @JsonProperty(value="detailedStatus") String detailedStatus, @JsonProperty(value="streams") Map<String, LinkWithMetadata> streams, @JsonProperty(value="links") Map<String, URI> links) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.entityId = entityId;
        this.entityDisplayName = entityDisplayName;
        this.tags = tags == null ? ImmutableList.of() : ImmutableList.copyOf(tags);
        this.submitTimeUtc = submitTimeUtc;
        this.startTimeUtc = startTimeUtc;
        this.endTimeUtc = endTimeUtc;
        this.currentStatus = currentStatus;
        this.result = result;
        this.isError = isError;
        this.isCancelled = isCancelled;
        this.children = children;
        this.blockingDetails = blockingDetails;
        this.blockingTask = blockingTask;
        this.submittedByTask = submittedByTask;
        this.detailedStatus = detailedStatus;
        this.streams = streams;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityDisplayName() {
        return this.entityDisplayName;
    }

    public Collection<Object> getTags() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object t : this.tags) {
            result.add(Jsonya.convertToJsonPrimitive((Object)t));
        }
        return result;
    }

    @JsonIgnore
    public Collection<Object> getRawTags() {
        return this.tags;
    }

    public Long getSubmitTimeUtc() {
        return this.submitTimeUtc;
    }

    public Long getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public Long getEndTimeUtc() {
        return this.endTimeUtc;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public Object getResult() {
        return this.result;
    }

    @Deprecated
    @JsonIgnore
    public boolean getIsError() {
        return this.isError;
    }

    @Deprecated
    @JsonIgnore
    public boolean getIsCancelled() {
        return this.isCancelled;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public List<LinkWithMetadata> getChildren() {
        return this.children;
    }

    public LinkWithMetadata getSubmittedByTask() {
        return this.submittedByTask;
    }

    public LinkWithMetadata getBlockingTask() {
        return this.blockingTask;
    }

    public String getBlockingDetails() {
        return this.blockingDetails;
    }

    public String getDetailedStatus() {
        return this.detailedStatus;
    }

    public Map<String, LinkWithMetadata> getStreams() {
        return this.streams;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskSummary)) {
            return false;
        }
        TaskSummary that = (TaskSummary)o;
        return this.isError == that.isError && this.isCancelled == that.isCancelled && Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.entityId, that.entityId) && Objects.equals(this.entityDisplayName, that.entityDisplayName) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.submitTimeUtc, that.submitTimeUtc) && Objects.equals(this.startTimeUtc, that.startTimeUtc) && Objects.equals(this.endTimeUtc, that.endTimeUtc) && Objects.equals(this.currentStatus, that.currentStatus) && Objects.equals(this.result, that.result) && Objects.equals(this.children, that.children) && Objects.equals(this.submittedByTask, that.submittedByTask) && Objects.equals(this.blockingTask, that.blockingTask) && Objects.equals(this.blockingDetails, that.blockingDetails) && Objects.equals(this.detailedStatus, that.detailedStatus) && Objects.equals(this.streams, that.streams) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.entityId, this.entityDisplayName, this.description, this.tags, this.submitTimeUtc, this.startTimeUtc, this.endTimeUtc, this.currentStatus, this.result, this.isError, this.isCancelled, this.children, this.submittedByTask, this.blockingTask, this.blockingDetails, this.detailedStatus, this.streams, this.links);
    }

    public String toString() {
        return "TaskSummary{id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", entityId='" + this.entityId + '\'' + ", entityDisplayName='" + this.entityDisplayName + '\'' + ", description='" + this.description + '\'' + ", tags=" + this.tags + ", submitTimeUtc=" + this.submitTimeUtc + ", startTimeUtc=" + this.startTimeUtc + ", endTimeUtc=" + this.endTimeUtc + ", currentStatus='" + this.currentStatus + '\'' + ", result=" + this.result + ", isError=" + this.isError + ", isCancelled=" + this.isCancelled + ", children=" + this.children + ", submittedByTask=" + this.submittedByTask + ", blockingTask=" + this.blockingTask + ", blockingDetails='" + this.blockingDetails + '\'' + ", detailedStatus='" + this.detailedStatus + '\'' + ", streams=" + this.streams + ", links=" + this.links + '}';
    }
}

