/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.rest.domain.ConfigSummary;
import org.apache.brooklyn.util.text.StringPredicates;

public class EntityConfigSummary
extends ConfigSummary {
    private static final long serialVersionUID = -1336134336883426030L;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Boolean pinned;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final List<String> constraints;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final Map<String, URI> links;

    public EntityConfigSummary(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="defaultValue") Object defaultValue, @JsonProperty(value="reconfigurable") boolean reconfigurable, @JsonProperty(value="label") String label, @JsonProperty(value="priority") Double priority, @JsonProperty(value="possibleValues") List<Map<String, String>> possibleValues, @JsonProperty(value="pinned") Boolean pinned, @JsonProperty(value="constraints") List<String> constraints, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, type, description, defaultValue, reconfigurable, label, priority, possibleValues);
        this.pinned = pinned;
        this.constraints = constraints == null ? ImmutableList.of() : ImmutableList.copyOf(constraints);
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public EntityConfigSummary(ConfigKey<?> config, String label, Double priority, Boolean pinned, Map<String, URI> links) {
        super(config, label, priority);
        this.pinned = pinned;
        this.constraints = !config.getConstraint().equals((Object)Predicates.alwaysTrue()) ? ImmutableList.of((Object)(config.getConstraint().getClass().equals(StringPredicates.isNonBlank().getClass()) ? "required" : config.getConstraint().toString())) : ImmutableList.of();
        this.links = links != null ? ImmutableMap.copyOf(links) : null;
    }

    public Boolean isPinned() {
        return this.pinned;
    }

    public List<String> getConstraints() {
        return this.constraints;
    }

    @Override
    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityConfigSummary that = (EntityConfigSummary)o;
        if (this.pinned != that.pinned) {
            return false;
        }
        if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) {
            return false;
        }
        return this.links != null ? this.links.equals(that.links) : that.links == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.links);
    }

    @Override
    public String toString() {
        return "EntityConfigSummary{name='" + this.getName() + '\'' + ", type='" + this.getType() + '\'' + ", description='" + this.getDescription() + '\'' + "links=" + this.links + '}';
    }
}

