/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;

public class ApiError
implements Serializable {
    private static final long serialVersionUID = -8244515572813244686L;
    private final String message;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final String details;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Object data;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer error;

    public static Builder builder() {
        return new Builder();
    }

    public static ApiError of(Throwable t) {
        return ApiError.builderFromThrowable(t).build();
    }

    public static ApiError of(String message) {
        return ApiError.builder().message(message).build();
    }

    @Deprecated
    public static Builder fromThrowable(Throwable t) {
        return ApiError.builderFromThrowable(t);
    }

    public static Builder builderFromThrowable(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"throwable");
        String message = Exceptions.collapseText((Throwable)t);
        return ApiError.builder().message(message).details(Throwables.getStackTraceAsString((Throwable)t));
    }

    public ApiError(String message) {
        this(message, null);
    }

    public ApiError(String message, String details) {
        this(message, details, null, null);
    }

    public ApiError(@JsonProperty(value="message") String message, @JsonProperty(value="details") String details, @JsonProperty(value="data") Object data, @JsonProperty(value="error") Integer error) {
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.details = details != null ? details : "";
        this.data = data;
        this.error = error;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    public Object getData() {
        return this.data;
    }

    public Integer getError() {
        return this.error;
    }

    public Response asBadRequestResponseJson() {
        return this.asResponse(Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
    }

    public Response asResponse(Response.Status defaultStatusIfNoErrorCodeAlready, MediaType type) {
        boolean hasErrorAlready;
        boolean bl = hasErrorAlready = this.getError() != null && this.getError() != 0;
        int errorCode = hasErrorAlready ? this.error : (defaultStatusIfNoErrorCodeAlready != null ? defaultStatusIfNoErrorCodeAlready.getStatusCode() : Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        return Response.status((int)errorCode).type(type).entity((Object)(hasErrorAlready ? this : ApiError.builder().copy(this).errorCode(errorCode).build())).build();
    }

    public Response asResponse(MediaType type) {
        return this.asResponse(null, type);
    }

    public Response asJsonResponse() {
        return this.asResponse(MediaType.APPLICATION_JSON_TYPE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiError)) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.message, apiError.message) && Objects.equals(this.details, apiError.details) && Objects.equals(this.error, apiError.error);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.details, this.error);
    }

    public String toString() {
        return "ApiError{message='" + this.message + '\'' + ", details='" + this.details + '\'' + ", error=" + this.error + '}';
    }

    public static class Builder {
        private String message;
        private String details;
        private Object data;
        private Integer errorCode;

        public Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder errorCode(Response.Status errorCode) {
            return this.errorCode(errorCode.getStatusCode());
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder prefixMessage(String prefix) {
            return this.prefixMessage(prefix, ": ");
        }

        public Builder prefixMessage(String prefix, String separatorIfMessageNotBlank) {
            if (Strings.isNonBlank((CharSequence)prefix)) {
                if (Strings.isBlank((CharSequence)this.message)) {
                    this.message(prefix);
                } else {
                    this.message(prefix + separatorIfMessageNotBlank + this.message);
                }
            }
            return this;
        }

        public ApiError build() {
            return new ApiError(this.message, this.details, this.data, this.errorCode);
        }

        @Deprecated
        public Builder fromApiError(ApiError error) {
            return this.copy(error);
        }

        public Builder copy(ApiError error) {
            return this.message(error.message).details(error.details).errorCode(error.error);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

