/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.DynamicSequentialTask;
import org.apache.brooklyn.util.core.task.ParallelTask;
import org.apache.brooklyn.util.core.task.SequentialTask;

public class TaskBuilder<T> {
    String displayName = null;
    String description = null;
    Callable<T> body = null;
    Boolean swallowChildrenFailures = null;
    List<TaskAdaptable<?>> children = MutableList.of();
    Set<Object> tags = MutableSet.of();
    Map<String, Object> flags = MutableMap.of();
    Boolean dynamic = null;
    boolean parallel = false;

    public static <T> TaskBuilder<T> builder() {
        return new TaskBuilder<T>();
    }

    @Deprecated
    public TaskBuilder<T> name(String name) {
        return this.displayName(name);
    }

    public TaskBuilder<T> displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public TaskBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public TaskBuilder<T> dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public TaskBuilder<T> parallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public TaskBuilder<T> body(Callable<T> body) {
        this.body = body;
        return this;
    }

    public TaskBuilder<T> swallowChildrenFailures(boolean swallowChildrenFailures) {
        this.swallowChildrenFailures = swallowChildrenFailures;
        return this;
    }

    public TaskBuilder<T> body(Runnable body) {
        this.body = JavaGroovyEquivalents.toCallable((Runnable)body);
        return this;
    }

    public TaskBuilder<T> add(TaskAdaptable<?> child) {
        this.children.add(child);
        return this;
    }

    public TaskBuilder<T> addAll(Iterable<? extends TaskAdaptable<?>> additionalChildren) {
        Iterables.addAll(this.children, additionalChildren);
        return this;
    }

    public TaskBuilder<T> add(TaskAdaptable<?> ... additionalChildren) {
        this.children.addAll(Arrays.asList(additionalChildren));
        return this;
    }

    public TaskBuilder<T> tag(Object tag) {
        this.tags.add(tag);
        return this;
    }

    public TaskBuilder<T> tagIfNotNull(Object tag) {
        if (tag != null) {
            this.tags.add(tag);
        }
        return this;
    }

    public TaskBuilder<T> flag(String flag, Object value) {
        this.flags.put(flag, value);
        return this;
    }

    public TaskBuilder<T> flags(Map<String, Object> flags) {
        this.flags.putAll(flags);
        return this;
    }

    public Task<T> build() {
        MutableMap taskFlags = MutableMap.copyOf(this.flags);
        if (this.displayName != null) {
            taskFlags.put((Object)"displayName", (Object)this.displayName);
        }
        if (this.description != null) {
            taskFlags.put((Object)"description", (Object)this.description);
        }
        if (!this.tags.isEmpty()) {
            taskFlags.put((Object)"tags", this.tags);
        }
        if (Boolean.FALSE.equals(this.dynamic) && this.children.isEmpty()) {
            if (this.swallowChildrenFailures != null) {
                throw new IllegalArgumentException("Cannot set swallowChildrenFailures for non-dynamic task: " + this);
            }
            return new BasicTask<T>((Map<?, ?>)taskFlags, this.body);
        }
        if (Boolean.TRUE.equals(this.dynamic) || this.dynamic == null && !this.parallel) {
            if (this.parallel) {
                throw new UnsupportedOperationException("No implementation of parallel dynamic aggregate task available");
            }
            DynamicSequentialTask<T> result = new DynamicSequentialTask<T>((Map<?, ?>)taskFlags, this.body);
            if (this.swallowChildrenFailures != null && this.swallowChildrenFailures.booleanValue()) {
                result.swallowChildrenFailures();
            }
            for (TaskAdaptable<?> t : this.children) {
                result.queue(t.asTask());
            }
            return result;
        }
        if (this.body != null) {
            throw new UnsupportedOperationException("No implementation of non-dynamic task with both body and children");
        }
        if (this.swallowChildrenFailures != null) {
            throw new IllegalArgumentException("Cannot set swallowChildrenFailures for non-dynamic task: " + this);
        }
        if (this.parallel) {
            return new ParallelTask((Map<String, ?>)taskFlags, (Collection<?>)this.children);
        }
        return new SequentialTask((Map<String, ?>)taskFlags, (Collection<?>)this.children);
    }

    public TaskFactory<Task<T>> buildFactory() {
        return new TaskFactory<Task<T>>(){

            public Task<T> newTask() {
                return TaskBuilder.this.build();
            }
        };
    }

    public String toString() {
        return super.toString() + "[" + this.displayName + "]";
    }
}

