/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.mgmt.TaskQueueingContext;
import org.apache.brooklyn.api.mgmt.TaskWrapper;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DynamicTasks {
    private static final Logger log = LoggerFactory.getLogger(DynamicTasks.class);
    private static final ThreadLocal<TaskQueueingContext> taskQueueingContext = new ThreadLocal();

    public static void setTaskQueueingContext(TaskQueueingContext newTaskQC) {
        taskQueueingContext.set(newTaskQC);
    }

    public static TaskQueueingContext getThreadTaskQueuingContext() {
        return taskQueueingContext.get();
    }

    public static TaskQueueingContext getTaskQueuingContext() {
        TaskQueueingContext adder = DynamicTasks.getThreadTaskQueuingContext();
        if (adder != null) {
            return adder;
        }
        Task t = Tasks.current();
        if (t instanceof TaskQueueingContext) {
            return (TaskQueueingContext)t;
        }
        return null;
    }

    public static void removeTaskQueueingContext() {
        taskQueueingContext.remove();
    }

    public static <T> TaskQueueingResult<T> queueIfPossible(TaskAdaptable<T> task) {
        TaskQueueingContext adder = DynamicTasks.getTaskQueuingContext();
        boolean result = false;
        if (adder != null) {
            result = Tasks.tryQueueing(adder, task);
        }
        return new TaskQueueingResult(task, result);
    }

    public static <T> TaskQueueingResult<T> queueIfPossible(TaskFactory<? extends TaskAdaptable<T>> task) {
        return DynamicTasks.queueIfPossible(task.newTask());
    }

    public static <T> Task<T> queueInTaskHierarchy(Task<T> task) {
        Preconditions.checkNotNull(task, (Object)"Task to queue cannot be null");
        Preconditions.checkState((!Tasks.isQueuedOrSubmitted(task) ? 1 : 0) != 0, (String)"Task to queue must not yet be submitted: {}", (Object[])new Object[]{task});
        TaskQueueingContext adder = DynamicTasks.getTaskQueuingContext();
        if (adder != null && Tasks.tryQueueing(adder, task)) {
            log.debug("Queued task {} at context {} (no hierarchy)", task, (Object)adder);
            return task;
        }
        Task t = Tasks.current();
        Preconditions.checkState((t != null || adder != null ? 1 : 0) != 0, (Object)("No task addition context available for queueing task " + task));
        while (t != null) {
            if (t instanceof TaskQueueingContext && Tasks.tryQueueing((TaskQueueingContext)t, task)) {
                log.debug("Queued task {} at hierarchical context {}", task, (Object)t);
                return task;
            }
            t = t.getSubmittedByTask();
        }
        throw new IllegalStateException("No task addition context available in current task hierarchy for adding task " + task);
    }

    public static <V extends TaskAdaptable<?>> V queue(V task) {
        try {
            Preconditions.checkNotNull(task, (Object)"Task to queue cannot be null");
            Preconditions.checkState((!Tasks.isQueued(task) ? 1 : 0) != 0, (String)"Task to queue must not yet be queued: %s", (Object[])new Object[]{task});
            TaskQueueingContext adder = DynamicTasks.getTaskQueuingContext();
            if (adder == null) {
                throw new IllegalStateException("Task " + task + " cannot be queued here; no queueing context available");
            }
            adder.queue(task.asTask());
            return task;
        }
        catch (Throwable e) {
            log.warn("Error queueing " + task + " (rethrowing): " + e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static void queue(TaskAdaptable<?> task1, TaskAdaptable<?> task2, TaskAdaptable<?> ... tasks) {
        DynamicTasks.queue(task1);
        DynamicTasks.queue(task2);
        for (TaskAdaptable<?> task : tasks) {
            DynamicTasks.queue(task);
        }
    }

    public static <T extends TaskAdaptable<?>> T queue(TaskFactory<T> taskFactory) {
        return (T)DynamicTasks.queue(taskFactory.newTask());
    }

    public static void queue(TaskFactory<?> task1, TaskFactory<?> task2, TaskFactory<?> ... tasks) {
        DynamicTasks.queue(task1.newTask());
        DynamicTasks.queue(task2.newTask());
        for (TaskFactory<?> task : tasks) {
            DynamicTasks.queue(task.newTask());
        }
    }

    public static <T> Task<T> queue(String name, Callable<T> job) {
        return DynamicTasks.queue(Tasks.create(name, job));
    }

    public static <T> Task<T> queue(String name, Runnable job) {
        return DynamicTasks.queue(Tasks.create(name, job));
    }

    public static <T extends TaskAdaptable<?>> T queueIfNeeded(T task) {
        if (!(Tasks.isQueued(task) || Tasks.isSubmitted(task) && DynamicTasks.getTaskQueuingContext() == null)) {
            DynamicTasks.queue(task);
        }
        return task;
    }

    public static <T> T get(TaskAdaptable<T> t) {
        return (T)DynamicTasks.queueIfNeeded(t).asTask().getUnchecked();
    }

    public static Task<?> waitForLast() {
        DynamicTasks.drain(null, true);
        List q = DynamicTasks.getTaskQueuingContext().getQueue();
        return q.isEmpty() ? null : (Task)Iterables.getLast((Iterable)q);
    }

    public static TaskQueueingContext drain(Duration optionalTimeout, boolean throwFirstError) {
        TaskQueueingContext qc = DynamicTasks.getTaskQueuingContext();
        Preconditions.checkNotNull((Object)qc, (Object)"Cannot drain when there is no queueing context");
        qc.drain(optionalTimeout, false, throwFirstError);
        return qc;
    }

    @Beta
    public static void swallowChildrenFailures() {
        Preconditions.checkNotNull((Object)DynamicTasks.getTaskQueuingContext(), (Object)"Task queueing context required here");
        Tasks.swallowChildrenFailures();
    }

    public static void markInessential() {
        Tasks.markInessential();
    }

    public static <T> Task<T> submit(TaskAdaptable<T> task, Entity entity) {
        return DynamicTasks.queueIfPossible(task).orSubmitAsync(entity).asTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Task<T> submitTopLevelTask(TaskAdaptable<T> task, Entity entity) {
        Task<?> currentTask = BasicExecutionManager.getPerThreadCurrentTask().get();
        BasicExecutionManager.getPerThreadCurrentTask().set(null);
        try {
            Task task2 = Entities.submit(entity, task).asTask();
            return task2;
        }
        finally {
            BasicExecutionManager.getPerThreadCurrentTask().set(currentTask);
        }
    }

    public static class TaskQueueingResult<T>
    implements TaskWrapper<T> {
        private final Task<T> task;
        private final boolean wasQueued;
        private ExecutionContext execContext = null;

        private TaskQueueingResult(TaskAdaptable<T> task, boolean wasQueued) {
            this.task = task.asTask();
            this.wasQueued = wasQueued;
        }

        public Task<T> asTask() {
            return this.task;
        }

        public Task<T> getTask() {
            return this.task;
        }

        public boolean wasQueued() {
            return this.wasQueued;
        }

        public boolean isQueuedOrSubmitted() {
            return this.wasQueued || Tasks.isQueuedOrSubmitted(this.task);
        }

        public TaskQueueingResult<T> executionContext(ExecutionContext execContext) {
            this.execContext = execContext;
            return this;
        }

        public TaskQueueingResult<T> executionContext(Entity entity) {
            this.execContext = ((EntityInternal)entity).getExecutionContext();
            return this;
        }

        private boolean orSubmitInternal() {
            if (!this.wasQueued()) {
                if (this.isQueuedOrSubmitted()) {
                    log.warn("Redundant call to execute " + this.getTask() + "; skipping");
                    return false;
                }
                ExecutionContext ec = this.execContext;
                if (ec == null) {
                    ec = BasicExecutionContext.getCurrentExecutionContext();
                }
                if (ec == null) {
                    throw new IllegalStateException("Cannot execute " + this.getTask() + " without an execution context; ensure caller is in an ExecutionContext");
                }
                ec.submit(this.getTask());
                return true;
            }
            return false;
        }

        public TaskQueueingResult<T> orSubmitAsync() {
            this.orSubmitInternal();
            return this;
        }

        public TaskQueueingResult<T> orSubmitAsync(Entity entity) {
            this.executionContext(entity);
            return this.orSubmitAsync();
        }

        public TaskQueueingResult<T> orSubmitAndBlock() {
            if (this.orSubmitInternal()) {
                this.task.getUnchecked();
            }
            return this;
        }

        public TaskQueueingResult<T> orSubmitAndBlock(Entity entity) {
            this.executionContext(entity);
            return this.orSubmitAndBlock();
        }

        public T andWaitForSuccess() {
            return (T)this.task.getUnchecked();
        }

        public void orCancel() {
            if (!this.wasQueued()) {
                this.task.cancel(false);
            }
        }
    }
}

