/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.util.core.json.BidiSerialization;
import org.apache.brooklyn.util.core.json.ConfigurableSerializerProvider;
import org.apache.brooklyn.util.core.json.ErrorAndToStringUnknownTypeSerializer;
import org.apache.brooklyn.util.core.json.MultimapSerializer;
import org.apache.brooklyn.util.core.json.PossiblyStrictPreferringFieldsVisibilityChecker;

public class BrooklynObjectsJsonMapper {
    public static ObjectMapper newMapper(ManagementContext mgmt) {
        ConfigurableSerializerProvider sp = new ConfigurableSerializerProvider();
        sp.setUnknownTypeSerializer((JsonSerializer<Object>)new ErrorAndToStringUnknownTypeSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerProvider((DefaultSerializerProvider)sp);
        mapper.setVisibilityChecker((VisibilityChecker)new PossiblyStrictPreferringFieldsVisibilityChecker());
        SimpleModule mapperModule = new SimpleModule("Brooklyn", new Version(0, 0, 0, "ignored", null, null));
        new BidiSerialization.ManagementContextSerialization(mgmt).install(mapperModule);
        new BidiSerialization.EntitySerialization(mgmt).install(mapperModule);
        new BidiSerialization.LocationSerialization(mgmt).install(mapperModule);
        new BidiSerialization.PolicySerialization(mgmt).install(mapperModule);
        new BidiSerialization.EnricherSerialization(mgmt).install(mapperModule);
        new BidiSerialization.FeedSerialization(mgmt).install(mapperModule);
        new BidiSerialization.TaskSerialization(mgmt).install(mapperModule);
        new BidiSerialization.ClassLoaderSerialization(mgmt).install(mapperModule);
        mapperModule.addSerializer((JsonSerializer)new MultimapSerializer());
        mapper.registerModule((Module)mapperModule);
        return mapper;
    }
}

