/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;

public class CommandPollConfig<T>
extends PollConfig<SshPollValue, T, CommandPollConfig<T>> {
    private Supplier<String> commandSupplier;
    protected List<Supplier<Map<String, String>>> dynamicEnvironmentSupplier = MutableList.of();
    private static final Predicate<SshPollValue> unused_DEFAULT_SUCCESS = new Predicate<SshPollValue>(){

        public boolean apply(@Nullable SshPollValue input) {
            return input != null && input.getExitStatus() == 0;
        }
    };
    public static final Predicate<SshPollValue> DEFAULT_SUCCESS = new DefaultSuccessPredicate();

    public static <T> CommandPollConfig<T> forSensor(AttributeSensor<T> sensor) {
        return new CommandPollConfig<T>(sensor);
    }

    public static CommandPollConfig<Void> forMultiple() {
        return new CommandPollConfig<Void>(PollConfig.NO_SENSOR);
    }

    public CommandPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        super.checkSuccess(DEFAULT_SUCCESS);
    }

    public CommandPollConfig(CommandPollConfig<T> other) {
        super(other);
        this.commandSupplier = other.commandSupplier;
    }

    @Deprecated
    public String getCommand() {
        return (String)this.getCommandSupplier().get();
    }

    public Supplier<String> getCommandSupplier() {
        return this.commandSupplier;
    }

    @Deprecated
    public Map<String, String> getEnv() {
        return (Map)this.getEnvSupplier().get();
    }

    public Supplier<Map<String, String>> getEnvSupplier() {
        return new CombiningEnvSupplier(this.dynamicEnvironmentSupplier);
    }

    public CommandPollConfig<T> command(String val) {
        return this.command((Supplier<String>)Suppliers.ofInstance((Object)val));
    }

    public CommandPollConfig<T> command(Supplier<String> val) {
        this.commandSupplier = val;
        return this;
    }

    public CommandPollConfig<T> env(String key, String val) {
        return this.env(Collections.singletonMap(key, val));
    }

    public CommandPollConfig<T> env(Map<String, String> val) {
        if (val == null) {
            return this;
        }
        return this.env((Supplier<Map<String, String>>)Suppliers.ofInstance(val));
    }

    public CommandPollConfig<T> env(Supplier<Map<String, String>> val) {
        Preconditions.checkNotNull(val);
        this.dynamicEnvironmentSupplier.add(val);
        return this;
    }

    @Override
    protected String toStringBaseName() {
        return "ssh";
    }

    @Override
    protected Object toStringPollSource() {
        if (this.getCommandSupplier() == null) {
            return null;
        }
        String command = (String)this.getCommandSupplier().get();
        return command;
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull(this.getCommandSupplier() != null ? this.getCommandSupplier().get() : null).appendIfNotNull(this.getEnvSupplier() != null ? this.getEnvSupplier().get() : null);
    }

    private static class CombiningEnvSupplier
    implements Supplier<Map<String, String>> {
        private final List<Supplier<Map<String, String>>> dynamicEnvironmentSupplier;

        public CombiningEnvSupplier(List<Supplier<Map<String, String>>> dynamicEnvironmentSupplier) {
            this.dynamicEnvironmentSupplier = (List)Preconditions.checkNotNull(dynamicEnvironmentSupplier, (Object)"dynamicEnvironmentSupplier");
        }

        public Map<String, String> get() {
            MutableMap result = MutableMap.of();
            for (Supplier<Map<String, String>> envS : this.dynamicEnvironmentSupplier) {
                Map envM;
                if (envS == null || (envM = (Map)envS.get()) == null) continue;
                this.mergeEnvMaps(envM, (Map<String, String>)result);
            }
            return result;
        }

        protected void mergeEnvMaps(Map<String, String> supplied, Map<String, String> target) {
            if (supplied == null) {
                return;
            }
            target.putAll(supplied);
        }

        public int hashCode() {
            return this.dynamicEnvironmentSupplier.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CombiningEnvSupplier)) {
                return false;
            }
            CombiningEnvSupplier o = (CombiningEnvSupplier)obj;
            return Objects.equal(this.dynamicEnvironmentSupplier, o.dynamicEnvironmentSupplier);
        }

        public String toString() {
            return "CombiningEnvSupplier(" + this.dynamicEnvironmentSupplier + ")";
        }
    }

    private static class DefaultSuccessPredicate
    implements Predicate<SshPollValue> {
        private DefaultSuccessPredicate() {
        }

        public boolean apply(@Nullable SshPollValue input) {
            return input != null && input.getExitStatus() == 0;
        }
    }
}

