/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityTypeRegistry;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.objs.proxy.ClassLoaderCache;
import org.apache.brooklyn.core.objs.proxy.EntityProxy;
import org.apache.brooklyn.core.objs.proxy.EntityProxyImpl;
import org.apache.brooklyn.core.objs.proxy.InternalFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.AggregateClassLoader;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEntityFactory
extends InternalFactory {
    private static final Logger log = LoggerFactory.getLogger(InternalEntityFactory.class);
    private final EntityTypeRegistry entityTypeRegistry;
    private final InternalPolicyFactory policyFactory;
    private final ClassLoaderCache classLoaderCache;

    public InternalEntityFactory(ManagementContextInternal managementContext, EntityTypeRegistry entityTypeRegistry, InternalPolicyFactory policyFactory) {
        super(managementContext);
        this.entityTypeRegistry = (EntityTypeRegistry)Preconditions.checkNotNull((Object)entityTypeRegistry, (Object)"entityTypeRegistry");
        this.policyFactory = (InternalPolicyFactory)Preconditions.checkNotNull((Object)policyFactory, (Object)"policyFactory");
        this.classLoaderCache = new ClassLoaderCache();
    }

    @VisibleForTesting
    public <T extends Entity> T createEntityProxy(EntitySpec<T> spec, T entity) {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        if (spec.getType().isInterface()) {
            interfaces.add(spec.getType());
        } else {
            log.warn("EntitySpec declared in terms of concrete type " + spec.getType() + "; should be supplied in terms of interface");
            interfaces.addAll(Reflections.getAllInterfaces((Class)spec.getType()));
        }
        interfaces.addAll(spec.getAdditionalInterfaces());
        return this.createEntityProxy(interfaces, entity);
    }

    protected <T extends Entity> T createEntityProxy(Iterable<Class<?>> interfaces, T entity) {
        MutableSet allInterfaces = MutableSet.builder().add(EntityProxy.class, Entity.class, (Object[])new Class[]{EntityLocal.class, EntityInternal.class}).addAll(interfaces).build();
        AggregateClassLoader aggregateClassLoader = this.classLoaderCache.getClassLoaderForProxy(entity.getClass(), (Set<Class<?>>)allInterfaces);
        return (T)((Entity)Proxy.newProxyInstance((ClassLoader)aggregateClassLoader, allInterfaces.toArray(new Class[allInterfaces.size()]), (InvocationHandler)new EntityProxyImpl(entity)));
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec, Optional<String> entityId) {
        MutableMap entitiesByEntityId = MutableMap.of();
        MutableMap specsByEntityId = MutableMap.of();
        T entity = this.createEntityAndDescendantsUninitialized(spec, entityId, (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId);
        this.initEntityAndDescendants(entity.getId(), (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId);
        return entity;
    }

    private <T extends Entity> T createEntityAndDescendantsUninitialized(EntitySpec<T> spec, Optional<String> entityId, Map<String, Entity> entitiesByEntityId, Map<String, EntitySpec<?>> specsByEntityId) {
        if (spec.getFlags().containsKey("parent") || spec.getFlags().containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + spec);
        }
        if (spec.getFlags().containsKey("id")) {
            throw new IllegalArgumentException("Spec's flags must not contain id; use spec.id() instead for " + spec);
        }
        try {
            Class<T> clazz = this.getImplementedBy(spec);
            T entity = this.constructEntity(clazz, spec, entityId);
            this.loadUnitializedEntity(entity, spec);
            entitiesByEntityId.put(entity.getId(), (Entity)entity);
            specsByEntityId.put(entity.getId(), spec);
            for (EntitySpec childSpec : spec.getChildren()) {
                if (childSpec.getParent() != null) {
                    if (!childSpec.getParent().equals(entity)) {
                        throw new IllegalStateException("Spec " + childSpec + " has parent " + childSpec.getParent() + " defined, but it is defined as a child of " + entity);
                    }
                    log.warn("Child spec " + childSpec + " is already set with parent " + entity + "; how did this happen?!");
                }
                childSpec.parent(entity);
                T child = this.createEntityAndDescendantsUninitialized(childSpec, (Optional<String>)Optional.absent(), entitiesByEntityId, specsByEntityId);
                entity.addChild(child);
            }
            for (Entity member : spec.getMembers()) {
                if (!(entity instanceof Group)) {
                    throw new IllegalStateException("Entity " + entity + " must be a group to add members " + spec.getMembers());
                }
                ((Group)entity).addMember(member);
            }
            for (Group group : spec.getGroups()) {
                group.addMember(entity);
            }
            return entity;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T extends Entity> T loadUnitializedEntity(T entity, EntitySpec<T> spec) {
        try {
            AbstractEntity theEntity = (AbstractEntity)entity;
            if (spec.getDisplayName() != null) {
                theEntity.setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                theEntity.setCatalogItemIdAndSearchPath(spec.getCatalogItemId(), spec.getCatalogItemIdSearchPath());
            }
            entity.tags().addTags((Iterable)spec.getTags());
            this.addSpecParameters(spec, theEntity.getMutableEntityType());
            theEntity.configure((Map)MutableMap.copyOf((Map)spec.getFlags()));
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                entity.config().set((ConfigKey)entry.getKey(), entry.getValue());
            }
            Entity parent = spec.getParent();
            if (parent != null) {
                parent = parent instanceof AbstractEntity ? ((AbstractEntity)parent).getProxyIfAvailable() : parent;
                entity.setParent(parent);
            }
            return entity;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void addSpecParameters(EntitySpec<?> spec, EntityDynamicType edType) {
        if (Strings.isNonBlank((CharSequence)spec.getCatalogItemId())) {
            edType.clearConfigKeys();
        }
        for (SpecParameter param : spec.getParameters()) {
            edType.addConfigKey(param.getConfigKey());
            if (param.getSensor() == null) continue;
            edType.addSensor((Sensor<?>)param.getSensor());
        }
    }

    private void validateDescendantConfig(Entity e) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(e);
        while (!queue.isEmpty()) {
            Entity e1 = (Entity)queue.poll();
            ConfigConstraints.assertValid(e1);
            queue.addAll(e1.getChildren());
        }
    }

    protected <T extends Entity> void initEntityAndDescendants(String entityId, final Map<String, Entity> entitiesByEntityId, final Map<String, EntitySpec<?>> specsByEntityId) {
        final Entity entity = entitiesByEntityId.get(entityId);
        final EntitySpec<?> spec = specsByEntityId.get(entityId);
        if (entity == null || spec == null) {
            log.debug("Skipping initialization of " + entityId + " found as child of entity being initialized, but this child is not one we created; likely it was created by an initializer, and thus it should be already fully initialized.");
            return;
        }
        this.validateDescendantConfig(entity);
        ((EntityInternal)entity).getExecutionContext().submit(Tasks.builder().dynamic(false).displayName("Entity initialization").tag("TRANSIENT").body(new Runnable(){

            @Override
            public void run() {
                ((AbstractEntity)entity).init();
                for (LocationSpec locationSpec : spec.getLocationSpecs()) {
                    LocationSpec taggedSpec = (LocationSpec)LocationSpec.create((LocationSpec)locationSpec).tag((Object)BrooklynTags.newOwnerEntityTag(entity.getId()));
                    ((AbstractEntity)entity).addLocations((Collection<? extends Location>)MutableList.of((Object)InternalEntityFactory.this.managementContext.getLocationManager().createLocation(taggedSpec)));
                }
                ((AbstractEntity)entity).addLocations(spec.getLocations());
                for (EntityInitializer initializer : spec.getInitializers()) {
                    initializer.apply((EntityLocal)((EntityInternal)entity));
                }
                for (Enricher enricher : spec.getEnrichers()) {
                    entity.enrichers().add(enricher);
                }
                for (EnricherSpec enricherSpec : spec.getEnricherSpecs()) {
                    entity.enrichers().add(InternalEntityFactory.this.policyFactory.createEnricher(enricherSpec));
                }
                for (Policy policy : spec.getPolicies()) {
                    entity.policies().add(policy);
                }
                for (PolicySpec policySpec : spec.getPolicySpecs()) {
                    entity.policies().add(InternalEntityFactory.this.policyFactory.createPolicy(policySpec));
                }
                for (Entity child : entity.getChildren()) {
                    InternalEntityFactory.this.initEntityAndDescendants(child.getId(), entitiesByEntityId, specsByEntityId);
                }
            }
        }).build()).getUnchecked();
    }

    private <T extends Entity> T constructEntity(Class<? extends T> clazz, EntitySpec<T> spec, Optional<String> entityId) {
        T entity = this.constructEntityImpl(clazz, spec, null, entityId);
        if (((AbstractEntity)entity).getProxy() == null) {
            ((AbstractEntity)entity).setProxy((Entity)this.createEntityProxy(spec, entity));
        }
        return entity;
    }

    public <T extends Entity> T constructEntity(Class<T> clazz, Iterable<Class<?>> interfaces, String entityId) {
        if (!InternalEntityFactory.isNewStyle(clazz)) {
            throw new IllegalStateException("Cannot construct old-style entity " + clazz);
        }
        Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
        Preconditions.checkState((interfaces != null && !Iterables.isEmpty(interfaces) ? 1 : 0) != 0, (String)"must have at least one interface for entity %s:%s", (Object[])new Object[]{clazz, entityId});
        T entity = this.constructEntityImpl(clazz, null, null, (Optional<String>)Optional.of((Object)entityId));
        if (((AbstractEntity)entity).getProxy() == null) {
            Object proxy = this.managementContext.getEntityManager().getEntity(entity.getId());
            if (proxy == null) {
                proxy = this.createEntityProxy(interfaces, entity);
            }
            ((AbstractEntity)entity).setProxy((Entity)proxy);
        }
        return entity;
    }

    private <T extends Entity> T constructEntityImpl(Class<? extends T> clazz, EntitySpec<?> optionalSpec, Map<String, ?> optionalConstructorFlags, Optional<String> entityId) {
        Entity entity = (Entity)this.construct(clazz, (AbstractBrooklynObjectSpec<?, ?>)optionalSpec, optionalConstructorFlags);
        if (entityId.isPresent()) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)entityId.get()), entity);
        }
        if (entity instanceof AbstractApplication) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"mgmt", (Object)this.managementContext), entity);
        }
        this.managementContext.prePreManage(entity);
        ((AbstractEntity)entity).setManagementContext(this.managementContext);
        return (T)entity;
    }

    @Override
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (flags.containsKey("parent") || flags.containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + clazz);
        }
        return super.constructOldStyle(clazz, flags);
    }

    private <T extends Entity> Class<? extends T> getImplementedBy(EntitySpec<T> spec) {
        if (spec.getImplementation() != null) {
            return spec.getImplementation();
        }
        return this.entityTypeRegistry.getImplementedBy(spec.getType());
    }
}

