/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.HasBrooklynManagementContext;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.text.Identifiers;

public class BasicConfigurableObject
implements Configurable,
Identifiable,
ManagementContextInjectable,
HasBrooklynManagementContext {
    @SetFromFlag(value="id")
    private String id = Identifiers.makeRandomId((int)8);
    private volatile ManagementContext managementContext;
    private BasicConfigurationSupport config = new BasicConfigurationSupport();

    @Override
    public void setManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    @Override
    public ManagementContext getBrooklynManagementContext() {
        return this.managementContext;
    }

    public String getId() {
        return this.id;
    }

    public Configurable.ConfigurationSupport config() {
        return this.config;
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T value) {
        return (T)this.config().set(key, value);
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    private static class BasicConfigurationSupport
    implements Configurable.ConfigurationSupport {
        private final ConfigBag config = ConfigBag.newInstance();

        private BasicConfigurationSupport() {
        }

        public <T> T get(ConfigKey<T> key) {
            return this.config.get(key);
        }

        public <T> T get(ConfigKey.HasConfigKey<T> key) {
            return this.get(key.getConfigKey());
        }

        public <T> T set(ConfigKey<T> key, T val) {
            T old = this.config.get(key);
            this.config.configure(key, val);
            return old;
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
            return this.set(key.getConfigKey(), val);
        }

        public <T> T set(ConfigKey<T> key, Task<T> val) {
            throw new UnsupportedOperationException();
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
            return this.set(key.getConfigKey(), val);
        }

        @Deprecated
        public Set<ConfigKey<?>> findKeys(Predicate<? super ConfigKey<?>> filter) {
            return this.findKeysDeclared(filter);
        }

        public Set<ConfigKey<?>> findKeysDeclared(Predicate<? super ConfigKey<?>> filter) {
            return MutableSet.copyOf((Iterable)Iterables.filter(this.config.getAllConfigAsConfigKeyMap().keySet(), filter));
        }

        public Set<ConfigKey<?>> findKeysPresent(Predicate<? super ConfigKey<?>> filter) {
            return this.findKeysDeclared(filter);
        }
    }
}

