/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.MementoCopyMode;
import org.apache.brooklyn.api.mgmt.rebind.ChangeListener;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.ha.HighAvailabilityManagerImpl;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistenceActivityMetrics;
import org.apache.brooklyn.core.mgmt.rebind.ActivePartialRebindIteration;
import org.apache.brooklyn.core.mgmt.rebind.InitialFullRebindIteration;
import org.apache.brooklyn.core.mgmt.rebind.PeriodicDeltaChangeListener;
import org.apache.brooklyn.core.mgmt.rebind.PersistenceExceptionHandlerImpl;
import org.apache.brooklyn.core.mgmt.rebind.RebindExceptionHandlerImpl;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformer;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebindManagerImpl
implements RebindManager {
    public static final ConfigKey<RebindManager.RebindFailureMode> DANGLING_REFERENCE_FAILURE_MODE = ConfigKeys.newConfigKey(RebindManager.RebindFailureMode.class, "rebind.failureMode.danglingRef", "Action to take if a dangling reference is discovered during rebind", RebindManager.RebindFailureMode.CONTINUE);
    public static final ConfigKey<RebindManager.RebindFailureMode> REBIND_FAILURE_MODE = ConfigKeys.newConfigKey(RebindManager.RebindFailureMode.class, "rebind.failureMode.rebind", "Action to take if a failure occurs during rebind", RebindManager.RebindFailureMode.FAIL_AT_END);
    public static final ConfigKey<RebindManager.RebindFailureMode> ADD_CONFIG_FAILURE_MODE = ConfigKeys.newConfigKey(RebindManager.RebindFailureMode.class, "rebind.failureMode.addConfig", "Action to take if a failure occurs when setting a config value. It could happen coercion of the value type to fail.", RebindManager.RebindFailureMode.FAIL_AT_END);
    public static final ConfigKey<RebindManager.RebindFailureMode> ADD_POLICY_FAILURE_MODE = ConfigKeys.newConfigKey(RebindManager.RebindFailureMode.class, "rebind.failureMode.addPolicy", "Action to take if a failure occurs when adding a policy or enricher", RebindManager.RebindFailureMode.CONTINUE);
    public static final ConfigKey<RebindManager.RebindFailureMode> LOAD_POLICY_FAILURE_MODE = ConfigKeys.newConfigKey(RebindManager.RebindFailureMode.class, "rebind.failureMode.loadPolicy", "Action to take if a failure occurs when loading a policy or enricher", RebindManager.RebindFailureMode.CONTINUE);
    public static final ConfigKey<QuorumCheck> DANGLING_REFERENCES_MIN_REQUIRED_HEALTHY = ConfigKeys.newConfigKey(QuorumCheck.class, "rebind.failureMode.danglingRefs.minRequiredHealthy", "Number of items which must be rebinded at various sizes; a small number of dangling references is possible if items are in the process of being created or deleted, and that should be resolved on retry; the default set here allows max 2 dangling up to 10 items, then linear regression to allow max 5% at 100 items and above", QuorumCheck.QuorumChecks.newLinearRange((String)"[[0,-2],[10,8],[100,95],[200,190]]"));
    public static final Logger LOG = LoggerFactory.getLogger(RebindManagerImpl.class);
    private final ManagementContextInternal managementContext;
    private volatile Duration periodicPersistPeriod = Duration.ONE_SECOND;
    private volatile boolean persistenceRunning = false;
    private volatile PeriodicDeltaChangeListener persistenceRealChangeListener;
    private volatile ChangeListener persistencePublicChangeListener;
    private volatile boolean readOnlyRunning = false;
    private volatile ScheduledTask readOnlyTask = null;
    private transient Semaphore rebindActive = new Semaphore(1);
    private transient AtomicInteger readOnlyRebindCount = new AtomicInteger(Integer.MIN_VALUE);
    private volatile BrooklynMementoPersister persistenceStoreAccess;
    final boolean persistPoliciesEnabled;
    final boolean persistEnrichersEnabled;
    final boolean persistFeedsEnabled;
    final boolean persistCatalogItemsEnabled;
    final boolean persistBundlesEnabled;
    private RebindManager.RebindFailureMode danglingRefFailureMode;
    private RebindManager.RebindFailureMode rebindFailureMode;
    private RebindManager.RebindFailureMode addConfigFailureMode;
    private RebindManager.RebindFailureMode addPolicyFailureMode;
    private RebindManager.RebindFailureMode loadPolicyFailureMode;
    private QuorumCheck danglingRefsQuorumRequiredHealthy;
    private boolean isAwaitingInitialRebind;
    private PersistenceActivityMetrics rebindMetrics = new PersistenceActivityMetrics();
    private PersistenceActivityMetrics persistMetrics = new PersistenceActivityMetrics();
    Integer firstRebindAppCount;
    Integer firstRebindEntityCount;
    Integer firstRebindItemCount;

    public RebindManagerImpl(ManagementContextInternal managementContext) {
        this.managementContext = managementContext;
        this.persistencePublicChangeListener = ChangeListener.NOOP;
        this.persistPoliciesEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.policyPersistence");
        this.persistEnrichersEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.enricherPersistence");
        this.persistFeedsEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.feedPersistence");
        this.persistBundlesEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.catalogPersistence");
        this.persistCatalogItemsEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.catalogPersistence");
        this.danglingRefFailureMode = (RebindManager.RebindFailureMode)managementContext.getConfig().getConfig(DANGLING_REFERENCE_FAILURE_MODE);
        this.rebindFailureMode = (RebindManager.RebindFailureMode)managementContext.getConfig().getConfig(REBIND_FAILURE_MODE);
        this.addConfigFailureMode = (RebindManager.RebindFailureMode)managementContext.getConfig().getConfig(ADD_CONFIG_FAILURE_MODE);
        this.addPolicyFailureMode = (RebindManager.RebindFailureMode)managementContext.getConfig().getConfig(ADD_POLICY_FAILURE_MODE);
        this.loadPolicyFailureMode = (RebindManager.RebindFailureMode)managementContext.getConfig().getConfig(LOAD_POLICY_FAILURE_MODE);
        this.danglingRefsQuorumRequiredHealthy = (QuorumCheck)managementContext.getConfig().getConfig(DANGLING_REFERENCES_MIN_REQUIRED_HEALTHY);
        LOG.debug("{} initialized, settings: policies={}, enrichers={}, feeds={}, catalog={}", new Object[]{this, this.persistPoliciesEnabled, this.persistEnrichersEnabled, this.persistFeedsEnabled, this.persistCatalogItemsEnabled});
    }

    public ManagementContextInternal getManagementContext() {
        return this.managementContext;
    }

    public void setPeriodicPersistPeriod(Duration period) {
        if (this.persistenceStoreAccess != null) {
            throw new IllegalStateException("Cannot set period after persister is generated.");
        }
        this.periodicPersistPeriod = period;
    }

    @Deprecated
    public void setPeriodicPersistPeriod(long periodMillis) {
        this.setPeriodicPersistPeriod(Duration.of((long)periodMillis, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public boolean isPersistenceRunning() {
        return this.persistenceRunning;
    }

    public boolean isReadOnlyRunning() {
        return this.readOnlyRunning;
    }

    public void setPersister(BrooklynMementoPersister val) {
        PersistenceExceptionHandler exceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
        this.setPersister(val, exceptionHandler);
    }

    public void setPersister(BrooklynMementoPersister val, PersistenceExceptionHandler exceptionHandler) {
        if (this.persistenceStoreAccess != null && this.persistenceStoreAccess != val) {
            throw new IllegalStateException("Dynamically changing persister is not supported: old=" + this.persistenceStoreAccess + "; new=" + val);
        }
        if (this.persistenceRealChangeListener != null) {
            LOG.warn("Persister reset after listeners have been set", new Throwable("Source of persister reset"));
        }
        this.persistenceStoreAccess = (BrooklynMementoPersister)Preconditions.checkNotNull((Object)val, (Object)"persister");
        this.persistenceRealChangeListener = new PeriodicDeltaChangeListener(new PlaneIdSupplier(), this.managementContext.getServerExecutionContext(), this.persistenceStoreAccess, exceptionHandler, this.persistMetrics, this.periodicPersistPeriod);
        this.persistencePublicChangeListener = new SafeChangeListener(this.persistenceRealChangeListener);
        if (this.persistenceRunning) {
            this.persistenceRealChangeListener.start();
        }
    }

    @VisibleForTesting
    public BrooklynMementoPersister getPersister() {
        return this.persistenceStoreAccess;
    }

    public void startPersistence() {
        if (this.readOnlyRunning) {
            throw new IllegalStateException("Cannot start read-only when already running with persistence");
        }
        LOG.debug("Starting persistence (" + this + "), mgmt " + this.managementContext.getManagementNodeId());
        if (!this.persistenceRunning && this.managementContext.getBrooklynProperties().getConfig(BrooklynServerConfig.PERSISTENCE_BACKUPS_REQUIRED_ON_PROMOTION).booleanValue()) {
            BrooklynPersistenceUtils.createBackup(this.managementContext, BrooklynPersistenceUtils.CreateBackupMode.PROMOTION, MementoCopyMode.REMOTE);
        }
        this.persistenceRunning = true;
        this.readOnlyRebindCount.set(Integer.MIN_VALUE);
        this.persistenceStoreAccess.enableWriteAccess();
        if (this.persistenceRealChangeListener != null) {
            this.persistenceRealChangeListener.start();
        }
    }

    public void stopPersistence() {
        LOG.debug("Stopping persistence (" + this + "), mgmt " + this.managementContext.getManagementNodeId());
        this.persistenceRunning = false;
        if (this.persistenceRealChangeListener != null) {
            this.persistenceRealChangeListener.stop();
        }
        if (this.persistenceStoreAccess != null) {
            this.persistenceStoreAccess.disableWriteAccess(true);
        }
        LOG.debug("Stopped rebind (persistence), mgmt " + this.managementContext.getManagementNodeId());
    }

    public void startReadOnly(final ManagementNodeState mode) {
        if (!ManagementNodeState.isHotProxy((ManagementNodeState)mode)) {
            throw new IllegalStateException("Read-only rebind thread only permitted for hot proxy modes; not " + mode);
        }
        if (this.persistenceRunning) {
            throw new IllegalStateException("Cannot start read-only when already running with persistence");
        }
        if (this.readOnlyRunning || this.readOnlyTask != null) {
            LOG.warn("Cannot request read-only mode for " + this + " when already running - " + this.readOnlyTask + "; ignoring");
            return;
        }
        LOG.debug("Starting read-only rebinding (" + this + "), mgmt " + this.managementContext.getManagementNodeId());
        if (this.persistenceRealChangeListener != null) {
            this.persistenceRealChangeListener.stop();
        }
        if (this.persistenceStoreAccess != null) {
            this.persistenceStoreAccess.disableWriteAccess(true);
        }
        this.readOnlyRunning = true;
        this.readOnlyRebindCount.set(0);
        try {
            this.rebind(null, null, mode);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Callable taskFactory = new Callable<Task<?>>(){

            @Override
            public Task<Void> call() {
                return Tasks.builder().dynamic(false).displayName("rebind (periodic run").body(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            RebindManagerImpl.this.rebind(null, null, mode);
                            return null;
                        }
                        catch (RuntimeInterruptedException e) {
                            LOG.debug("Interrupted rebinding (re-interrupting): " + (Object)((Object)e));
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Interrupted rebinding (re-interrupting), details: " + (Object)((Object)e), (Throwable)e);
                            }
                            Thread.currentThread().interrupt();
                            return null;
                        }
                        catch (Exception e) {
                            if (!RebindManagerImpl.this.readOnlyRunning) {
                                LOG.debug("Problem rebinding (read-only running has probably just been turned off): " + e);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Problem rebinding (read-only running has probably just been turned off), details: " + e, (Throwable)e);
                                }
                            } else {
                                LOG.error("Problem rebinding: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                            }
                            return null;
                        }
                        catch (Throwable t) {
                            LOG.warn("Problem rebinding (rethrowing)", t);
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }
                }).build();
            }
        };
        this.readOnlyTask = (ScheduledTask)this.managementContext.getServerExecutionContext().submit((TaskAdaptable)new ScheduledTask((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)"Periodic read-only rebind"), taskFactory).period(this.periodicPersistPeriod));
    }

    public void stopReadOnly() {
        this.readOnlyRunning = false;
        if (this.readOnlyTask != null) {
            LOG.debug("Stopping read-only rebinding (" + this + "), mgmt " + this.managementContext.getManagementNodeId());
            this.readOnlyTask.cancel(true);
            this.readOnlyTask.blockUntilEnded();
            boolean reallyEnded = Tasks.blockUntilInternalTasksEnded(this.readOnlyTask, Duration.TEN_SECONDS);
            if (!reallyEnded) {
                LOG.warn("Rebind (read-only) tasks took too long to die after interrupt (ignoring): " + this.readOnlyTask);
            }
            this.readOnlyTask = null;
            LOG.debug("Stopped read-only rebinding (" + this + "), mgmt " + this.managementContext.getManagementNodeId());
        }
    }

    public void start() {
        ManagementNodeState target = this.getRebindMode();
        if (target == ManagementNodeState.HOT_STANDBY || target == ManagementNodeState.HOT_BACKUP) {
            this.startReadOnly(target);
        } else if (target == ManagementNodeState.MASTER) {
            this.startPersistence();
        } else {
            LOG.warn("Nothing to start in " + this + " when HA mode is " + target);
        }
    }

    public void stop() {
        this.stopReadOnly();
        this.stopPersistence();
        if (this.persistenceStoreAccess != null) {
            this.persistenceStoreAccess.stop(true);
        }
    }

    public void rebindPartialActive(CompoundTransformer transformer, Iterator<BrooklynObject> objectsToRebind) {
        ClassLoader classLoader = this.managementContext.getCatalogClassLoader();
        RebindExceptionHandler exceptionHandler = RebindExceptionHandlerImpl.builder().danglingRefFailureMode(this.danglingRefFailureMode).danglingRefQuorumRequiredHealthy(this.danglingRefsQuorumRequiredHealthy).rebindFailureMode(this.rebindFailureMode).addConfigFailureMode(this.addConfigFailureMode).addPolicyFailureMode(this.addPolicyFailureMode).loadPolicyFailureMode(this.loadPolicyFailureMode).build();
        ManagementNodeState mode = this.getRebindMode();
        ActivePartialRebindIteration iteration = new ActivePartialRebindIteration(this, mode, classLoader, exceptionHandler, this.rebindActive, this.readOnlyRebindCount, this.rebindMetrics, this.persistenceStoreAccess);
        iteration.setObjectIterator(Iterators.transform(objectsToRebind, (Function)new Function<BrooklynObject, BrooklynObject>(){

            public BrooklynObject apply(BrooklynObject obj) {
                if (obj instanceof Entity) {
                    obj = Entities.deproxy((Entity)obj);
                }
                return obj;
            }
        }));
        if (transformer != null) {
            iteration.applyTransformer(transformer);
        }
        iteration.run();
    }

    public void rebindPartialActive(CompoundTransformer transformer, String ... objectsToRebindIds) {
        MutableList objectsToRebind = MutableList.of();
        for (String objectId : objectsToRebindIds) {
            BrooklynObject obj = this.managementContext.lookup(objectId);
            objectsToRebind.add(obj);
        }
        this.rebindPartialActive(transformer, objectsToRebind.iterator());
    }

    protected ManagementNodeState getRebindMode() {
        if (this.managementContext == null) {
            throw new IllegalStateException("Invalid " + this + ": no management context");
        }
        if (!(this.managementContext.getHighAvailabilityManager() instanceof HighAvailabilityManagerImpl)) {
            throw new IllegalStateException("Invalid " + this + ": unknown HA manager type " + this.managementContext.getHighAvailabilityManager());
        }
        ManagementNodeState target = ((HighAvailabilityManagerImpl)this.managementContext.getHighAvailabilityManager()).getTransitionTargetNodeState();
        return target;
    }

    @VisibleForTesting
    public void waitForPendingComplete(Duration timeout, boolean canTrigger) throws InterruptedException, TimeoutException {
        if (this.persistenceStoreAccess == null || !this.persistenceRunning) {
            return;
        }
        this.persistenceRealChangeListener.waitForPendingComplete(timeout, canTrigger);
        this.persistenceStoreAccess.waitForWritesCompleted(timeout);
    }

    @VisibleForTesting
    public void forcePersistNow() {
        this.forcePersistNow(false, null);
    }

    @VisibleForTesting
    public void forcePersistNow(boolean full, PersistenceExceptionHandler exceptionHandler) {
        if (this.persistenceStoreAccess == null || this.persistenceRealChangeListener == null) {
            LOG.info("Skipping forced persist; no persistence mechanism available");
            return;
        }
        if (full) {
            BrooklynMementoRawData memento = BrooklynPersistenceUtils.newStateMemento(this.managementContext, MementoCopyMode.LOCAL);
            if (exceptionHandler == null) {
                exceptionHandler = this.persistenceRealChangeListener.getExceptionHandler();
            }
            this.persistenceStoreAccess.checkpoint(memento, exceptionHandler);
        } else if (!this.persistenceRealChangeListener.persistNowSafely()) {
            throw new IllegalStateException("Forced persistence failed; see logs fore more detail");
        }
    }

    public ChangeListener getChangeListener() {
        return this.persistencePublicChangeListener;
    }

    public List<Application> rebind() {
        return this.rebind(null, null, null);
    }

    public List<Application> rebind(ClassLoader classLoader) {
        return this.rebind(classLoader, null, null);
    }

    public List<Application> rebind(ClassLoader classLoader, RebindExceptionHandler exceptionHandler) {
        return this.rebind(classLoader, exceptionHandler, null);
    }

    public List<Application> rebind(ClassLoader classLoaderO, RebindExceptionHandler exceptionHandlerO, ManagementNodeState modeO) {
        ManagementNodeState mode;
        final ClassLoader classLoader = classLoaderO != null ? classLoaderO : this.managementContext.getCatalogClassLoader();
        final RebindExceptionHandler exceptionHandler = exceptionHandlerO != null ? exceptionHandlerO : RebindExceptionHandlerImpl.builder().danglingRefFailureMode(this.danglingRefFailureMode).danglingRefQuorumRequiredHealthy(this.danglingRefsQuorumRequiredHealthy).rebindFailureMode(this.rebindFailureMode).addConfigFailureMode(this.addConfigFailureMode).addPolicyFailureMode(this.addPolicyFailureMode).loadPolicyFailureMode(this.loadPolicyFailureMode).build();
        ManagementNodeState managementNodeState = mode = modeO != null ? modeO : this.getRebindMode();
        if (mode != ManagementNodeState.MASTER && mode != ManagementNodeState.HOT_STANDBY && mode != ManagementNodeState.HOT_BACKUP) {
            throw new IllegalStateException("Must be either master or hot standby/backup to rebind (mode " + mode + ")");
        }
        BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
        if (ec == null) {
            ec = this.managementContext.getServerExecutionContext();
            Task task = ec.submit(new Callable<List<Application>>(){

                @Override
                public List<Application> call() throws Exception {
                    return RebindManagerImpl.this.rebindImpl(classLoader, exceptionHandler, mode);
                }
            });
            try {
                return (List)task.get();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return this.rebindImpl(classLoader, exceptionHandler, mode);
    }

    public BrooklynMementoRawData retrieveMementoRawData() {
        RebindExceptionHandler exceptionHandler = RebindExceptionHandlerImpl.builder().danglingRefFailureMode(this.danglingRefFailureMode).rebindFailureMode(this.rebindFailureMode).addConfigFailureMode(this.addConfigFailureMode).addPolicyFailureMode(this.addPolicyFailureMode).loadPolicyFailureMode(this.loadPolicyFailureMode).build();
        return this.loadMementoRawData(exceptionHandler);
    }

    protected BrooklynMementoRawData loadMementoRawData(RebindExceptionHandler exceptionHandler) {
        try {
            if (this.persistenceStoreAccess == null) {
                throw new IllegalStateException("Persistence not configured; cannot load memento data from persistent backing store");
            }
            if (!(this.persistenceStoreAccess instanceof BrooklynMementoPersisterToObjectStore)) {
                throw new IllegalStateException("Cannot load raw memento with persister " + this.persistenceStoreAccess);
            }
            return ((BrooklynMementoPersisterToObjectStore)this.persistenceStoreAccess).loadMementoRawData(exceptionHandler);
        }
        catch (RuntimeException e) {
            throw exceptionHandler.onFailed((Exception)e);
        }
    }

    protected List<Application> rebindImpl(ClassLoader classLoader, RebindExceptionHandler exceptionHandler, ManagementNodeState mode) {
        InitialFullRebindIteration iteration = new InitialFullRebindIteration(this, mode, classLoader, exceptionHandler, this.rebindActive, this.readOnlyRebindCount, this.rebindMetrics, this.persistenceStoreAccess);
        iteration.run();
        if (this.firstRebindAppCount == null) {
            this.firstRebindAppCount = iteration.getApplications().size();
            this.firstRebindEntityCount = iteration.getRebindContext().getEntities().size();
            this.firstRebindItemCount = iteration.getRebindContext().getAllBrooklynObjects().size();
        }
        this.isAwaitingInitialRebind = false;
        return iteration.getApplications();
    }

    @VisibleForTesting
    static <T extends TreeNode> Map<String, T> sortParentFirst(Map<String, T> nodes) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (TreeNode node : nodes.values()) {
            LinkedList tempchain = Lists.newLinkedList();
            TreeNode nodeinchain = node;
            while (nodeinchain != null) {
                tempchain.add(0, nodeinchain);
                nodeinchain = nodeinchain.getParent() == null ? null : (TreeNode)nodes.get(nodeinchain.getParent());
            }
            for (TreeNode n : tempchain) {
                result.put(n.getId(), n);
            }
        }
        return result;
    }

    public boolean isAwaitingInitialRebind() {
        return this.isAwaitingInitialRebind;
    }

    public void setAwaitingInitialRebind(boolean isAwaitingInitialRebind) {
        this.isAwaitingInitialRebind = isAwaitingInitialRebind;
    }

    public int getReadOnlyRebindCount() {
        return this.readOnlyRebindCount.get();
    }

    public Map<String, Object> getMetrics() {
        MutableMap result = MutableMap.of();
        result.put("rebind", this.rebindMetrics.asMap());
        result.put("persist", this.persistMetrics.asMap());
        if (this.readOnlyRebindCount.get() >= 0) {
            result.put("rebindReadOnlyCount", this.readOnlyRebindCount);
        }
        result.put("firstRebindCounts", MutableMap.of((Object)"applications", (Object)this.firstRebindAppCount, (Object)"entities", (Object)this.firstRebindEntityCount, (Object)"allItems", (Object)this.firstRebindItemCount));
        return result;
    }

    public String toString() {
        return super.toString() + "[mgmt=" + this.managementContext.getManagementNodeId() + "]";
    }

    private static class SafeChangeListener
    implements ChangeListener {
        private final ChangeListener delegate;

        public SafeChangeListener(ChangeListener delegate) {
            this.delegate = delegate;
        }

        public void onManaged(BrooklynObject instance) {
            try {
                this.delegate.onManaged(instance);
            }
            catch (Throwable t) {
                LOG.error("Error persisting mememento onManaged(" + instance + "); continuing.", t);
            }
        }

        public void onChanged(BrooklynObject instance) {
            try {
                this.delegate.onChanged(instance);
            }
            catch (Throwable t) {
                LOG.error("Error persisting mememento onChanged(" + instance + "); continuing.", t);
            }
        }

        public void onUnmanaged(BrooklynObject instance) {
            try {
                this.delegate.onUnmanaged(instance);
            }
            catch (Throwable t) {
                LOG.error("Error persisting mememento onUnmanaged(" + instance + "); continuing.", t);
            }
        }
    }

    private class PlaneIdSupplier
    implements Supplier<String> {
        private PlaneIdSupplier() {
        }

        public String get() {
            return (String)RebindManagerImpl.this.managementContext.getManagementPlaneIdMaybe().orNull();
        }
    }

    @Beta
    public static class RebindTracker {
        private static ThreadLocal<Boolean> rebinding = new ThreadLocal();

        public static boolean isRebinding() {
            return rebinding.get() == Boolean.TRUE;
        }

        static void reset() {
            rebinding.set(Boolean.FALSE);
        }

        static void setRebinding() {
            rebinding.set(Boolean.TRUE);
        }
    }
}

