/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind;

import org.apache.brooklyn.api.mgmt.rebind.RebindContext;
import org.apache.brooklyn.api.mgmt.rebind.mementos.CatalogItemMemento;
import org.apache.brooklyn.core.catalog.internal.CatalogItemDtoAbstract;
import org.apache.brooklyn.core.mgmt.rebind.AbstractBrooklynObjectRebindSupport;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCatalogItemRebindSupport
extends AbstractBrooklynObjectRebindSupport<CatalogItemMemento> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCatalogItemRebindSupport.class);
    private final CatalogItemDtoAbstract<?, ?> instance;

    public BasicCatalogItemRebindSupport(CatalogItemDtoAbstract<?, ?> instance) {
        super(instance);
        this.instance = instance;
    }

    @Override
    public void reconstruct(RebindContext rebindContext, CatalogItemMemento memento) {
        super.reconstruct(rebindContext, memento);
        FlagUtils.setFieldsFromFlags(MutableMap.builder().put((Object)"symbolicName", (Object)memento.getSymbolicName()).put((Object)"containingBundle", (Object)memento.getContainingBundle()).put((Object)"javaType", (Object)memento.getJavaType()).put((Object)"displayName", (Object)memento.getDisplayName()).put((Object)"description", (Object)memento.getDescription()).put((Object)"iconUrl", (Object)memento.getIconUrl()).put((Object)"version", (Object)memento.getVersion()).put((Object)"parameters", (Object)memento.getParameters()).put((Object)"libraries", (Object)memento.getLibraries()).put((Object)"planYaml", (Object)memento.getPlanYaml()).put((Object)"deprecated", (Object)memento.isDeprecated()).put((Object)"disabled", (Object)memento.isDisabled()).build(), this.instance);
    }

    @Override
    protected void addConfig(RebindContext rebindContext, CatalogItemMemento memento) {
    }

    @Override
    protected void addCustoms(RebindContext rebindContext, CatalogItemMemento memento) {
    }
}

