/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.SubscriptionManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.drivers.downloads.BasicDownloadsManager;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.AbstractManagementContext;
import org.apache.brooklyn.core.mgmt.internal.BrooklynGarbageCollector;
import org.apache.brooklyn.core.mgmt.internal.CollectionChangeListener;
import org.apache.brooklyn.core.mgmt.internal.DeferredBrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.LocalAccessManager;
import org.apache.brooklyn.core.mgmt.internal.LocalEntityManager;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.core.mgmt.internal.LocalSubscriptionManager;
import org.apache.brooklyn.core.mgmt.internal.LocalUsageManager;
import org.apache.brooklyn.core.objs.proxy.InternalEntityFactory;
import org.apache.brooklyn.core.objs.proxy.InternalLocationFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicExecutionManager;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalManagementContext
extends AbstractManagementContext {
    private static final Logger log = LoggerFactory.getLogger(LocalManagementContext.class);
    private static final Set<LocalManagementContext> INSTANCES;
    private final BrooklynProperties.Factory.Builder builder;
    private final List<ManagementContext.PropertiesReloadListener> reloadListeners = new CopyOnWriteArrayList<ManagementContext.PropertiesReloadListener>();
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private String managementPlaneId;
    private BasicExecutionManager execution;
    private SubscriptionManager subscriptions;
    private LocalEntityManager entityManager;
    private final LocalLocationManager locationManager;
    private final LocalAccessManager accessManager;
    private final LocalUsageManager usageManager;
    private OsgiManager osgiManager;
    public final Throwable constructionStackTrace = new Throwable("for construction stacktrace").fillInStackTrace();
    private final Map<String, Object> brooklynAdditionalProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static Set<LocalManagementContext> getInstances() {
        Set<LocalManagementContext> set = INSTANCES;
        synchronized (set) {
            return ImmutableSet.copyOf(INSTANCES);
        }
    }

    public static void logAll(Logger logger) {
        for (LocalManagementContext context : LocalManagementContext.getInstances()) {
            logger.warn("Management Context " + context + " running, creation stacktrace:\n" + Throwables.getStackTraceAsString((Throwable)context.constructionStackTrace));
        }
    }

    @Beta
    public static int terminateAll() {
        int closed = 0;
        int dangling = 0;
        for (LocalManagementContext context : LocalManagementContext.getInstances()) {
            try {
                context.terminate();
                ++closed;
            }
            catch (Throwable t) {
                Exceptions.propagateIfFatal((Throwable)t);
                log.warn("Failed to terminate management context", t);
                ++dangling;
            }
        }
        if (dangling > 0) {
            return -dangling;
        }
        return closed;
    }

    public LocalManagementContext() {
        this(BrooklynProperties.Factory.builderDefault());
    }

    @VisibleForTesting
    public LocalManagementContext(BrooklynProperties brooklynProperties) {
        this(BrooklynProperties.Factory.Builder.fromProperties(brooklynProperties));
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder) {
        this(builder, null);
    }

    public LocalManagementContext(BrooklynProperties brooklynProperties, Map<String, Object> brooklynAdditionalProperties) {
        this(BrooklynProperties.Factory.Builder.fromProperties(brooklynProperties), brooklynAdditionalProperties);
    }

    public LocalManagementContext(BrooklynProperties.Factory.Builder builder, Map<String, Object> brooklynAdditionalProperties) {
        super(builder.build());
        Preconditions.checkNotNull((Object)this.configMap, (Object)"brooklynProperties");
        this.builder = builder;
        this.brooklynAdditionalProperties = brooklynAdditionalProperties;
        if (brooklynAdditionalProperties != null) {
            this.configMap.addFromMap(brooklynAdditionalProperties);
        }
        BrooklynFeatureEnablement.init(this.configMap);
        this.locationManager = new LocalLocationManager(this);
        this.accessManager = new LocalAccessManager();
        this.usageManager = new LocalUsageManager(this);
        if (this.configMap.getConfig(OsgiManager.USE_OSGI).booleanValue()) {
            this.osgiManager = new OsgiManager(this);
            this.osgiManager.start();
        }
        INSTANCES.add(this);
        log.debug("Created management context " + this);
    }

    @Deprecated
    public String getManagementPlaneId() {
        return this.managementPlaneId;
    }

    public Maybe<String> getManagementPlaneIdMaybe() {
        return Maybe.ofDisallowingNull((Object)this.managementPlaneId);
    }

    public void setManagementPlaneId(String newPlaneId) {
        if (this.managementPlaneId != null && !this.managementPlaneId.equals(newPlaneId)) {
            log.warn("Management plane ID at {} {} changed from {} to {} (can happen on concurrent startup of multiple nodes)", new Object[]{this.getManagementNodeId(), this.getHighAvailabilityManager().getNodeState(), this.managementPlaneId, newPlaneId});
            log.debug("Management plane ID at {} {} changed from {} to {} (can happen on concurrent startup of multiple nodes)", new Object[]{this.getManagementNodeId(), this.getHighAvailabilityManager().getNodeState(), this.managementPlaneId, newPlaneId, new RuntimeException("Stack trace for setManagementPlaneId")});
        }
        this.managementPlaneId = newPlaneId;
    }

    public void generateManagementPlaneId() {
        if (this.managementPlaneId != null) {
            throw new IllegalStateException("Request to generate a management plane ID for node " + this.getManagementNodeId() + " but one already exists (" + this.managementPlaneId + ")");
        }
        this.managementPlaneId = Strings.makeRandomId((int)8);
    }

    @Override
    public void prePreManage(Entity entity) {
        this.getEntityManager().prePreManage(entity);
    }

    @Override
    public void prePreManage(Location location) {
        this.getLocationManager().prePreManage(location);
    }

    public synchronized Collection<Application> getApplications() {
        return this.getEntityManager().getApplications();
    }

    @Override
    public void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.getEntityManager().addEntitySetListener(listener);
    }

    @Override
    public void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        this.getEntityManager().removeEntitySetListener(listener);
    }

    @Override
    protected void manageIfNecessary(Entity entity, Object context) {
        this.getEntityManager().manageIfNecessary(entity, context);
    }

    public synchronized LocalEntityManager getEntityManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.entityManager == null) {
            this.entityManager = new LocalEntityManager(this);
        }
        return this.entityManager;
    }

    @Override
    public InternalEntityFactory getEntityFactory() {
        return this.getEntityManager().getEntityFactory();
    }

    @Override
    public InternalLocationFactory getLocationFactory() {
        return this.getLocationManager().getLocationFactory();
    }

    @Override
    public InternalPolicyFactory getPolicyFactory() {
        return this.getEntityManager().getPolicyFactory();
    }

    public synchronized LocalLocationManager getLocationManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.locationManager;
    }

    @Override
    public synchronized LocalAccessManager getAccessManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.accessManager;
    }

    @Override
    public synchronized LocalUsageManager getUsageManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.usageManager;
    }

    @Override
    public synchronized Maybe<OsgiManager> getOsgiManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.osgiManager == null) {
            return Maybe.absent((String)"OSGi not available in this instance");
        }
        return Maybe.of((Object)this.osgiManager);
    }

    public synchronized AccessController getAccessController() {
        return this.getAccessManager().getAccessController();
    }

    public synchronized SubscriptionManager getSubscriptionManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.subscriptions == null) {
            this.subscriptions = new LocalSubscriptionManager(this.getExecutionManager());
        }
        return this.subscriptions;
    }

    public synchronized ExecutionManager getExecutionManager() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        if (this.execution == null) {
            this.execution = new BasicExecutionManager(this.getManagementNodeId());
            this.gc = new BrooklynGarbageCollector(this.configMap, this.execution, this.getStorage());
        }
        return this.execution;
    }

    @Override
    public void terminate() {
        if (this.terminated.getAndSet(true)) {
            log.trace("Already terminated management context " + this);
            return;
        }
        log.debug("Terminating management context " + this);
        INSTANCES.remove(this);
        super.terminate();
        if (this.osgiManager != null) {
            this.osgiManager.stop();
            this.osgiManager = null;
        }
        if (this.usageManager != null) {
            this.usageManager.terminate();
        }
        if (this.execution != null) {
            this.execution.shutdownNow();
        }
        if (this.gc != null) {
            this.gc.shutdownNow();
        }
        log.debug("Terminated management context " + this);
    }

    protected void finalize() {
        this.terminate();
    }

    @Override
    protected <T> Task<T> runAtEntity(Map flags, Entity entity, Callable<T> c) {
        this.manageIfNecessary(entity, JavaGroovyEquivalents.elvis(Arrays.asList(flags.get("displayName"), flags.get("description"), flags, c)));
        return this.runAtEntity(entity, (TaskAdaptable<T>)Tasks.builder().dynamic(true).body(c).flags(flags).build());
    }

    protected <T> Task<T> runAtEntity(Entity entity, TaskAdaptable<T> task) {
        this.getExecutionContext(entity).submit(task);
        if (DynamicTasks.getTaskQueuingContext() != null) {
            TaskTags.markInessential(task);
            DynamicTasks.getTaskQueuingContext().queue(task.asTask());
        }
        return task.asTask();
    }

    @Override
    protected <T> Task<T> runAtEntity(Entity entity, Effector<T> eff, Map parameters) {
        this.manageIfNecessary(entity, eff);
        BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
        if (ec == null) {
            log.debug("Top-level effector invocation: {} on {}", eff, (Object)entity);
            ec = this.getExecutionContext(entity);
        }
        return this.runAtEntity(entity, Effectors.invocation(entity, eff, parameters));
    }

    @Override
    public boolean isManagedLocally(Entity e) {
        return true;
    }

    public String toString() {
        String planeId = (String)MoreObjects.firstNonNull((Object)this.managementPlaneId, (Object)"?");
        return LocalManagementContext.class.getSimpleName() + "[" + planeId + "-" + this.getManagementNodeId() + "]";
    }

    public void reloadBrooklynProperties() {
        log.info("Reloading brooklyn properties from " + this.builder);
        if (this.builder.hasDelegateOriginalProperties()) {
            log.warn("When reloading, mgmt context " + this + " properties are fixed, so reload will be of limited utility");
        }
        BrooklynProperties properties = this.builder.build();
        this.configMap = new DeferredBrooklynProperties(properties, this);
        if (this.brooklynAdditionalProperties != null && !this.brooklynAdditionalProperties.isEmpty()) {
            log.info("Reloading additional brooklyn properties from " + this.brooklynAdditionalProperties);
            this.configMap.addFromMap(this.brooklynAdditionalProperties);
        }
        this.downloadsManager = BasicDownloadsManager.newDefault(this.configMap);
        this.entitlementManager = Entitlements.newManager(this, this.configMap);
        this.clearLocationRegistry();
        BrooklynFeatureEnablement.init(this.configMap);
        for (ManagementContext.PropertiesReloadListener listener : this.reloadListeners) {
            listener.reloaded();
        }
    }

    @VisibleForTesting
    public void clearLocationRegistry() {
        this.locationRegistry = null;
    }

    public void addPropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.reloadListeners.add((ManagementContext.PropertiesReloadListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    public void removePropertiesReloadListener(ManagementContext.PropertiesReloadListener listener) {
        this.reloadListeners.remove(listener);
    }

    public void noteStartupComplete() {
        this.startupComplete = true;
    }

    static {
        BrooklynInitialization.initAll();
        INSTANCES = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    }
}

