/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.MemoryUsageTracker;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynTaskTags
extends TaskTags {
    private static final Logger log = LoggerFactory.getLogger(WrappedEntity.class);
    public static final String BROOKLYN_SERVER_TASK_TAG = "BROOKLYN-SERVER";
    public static final String EFFECTOR_TAG = "EFFECTOR";
    public static final String SENSOR_TAG = "SENSOR";
    public static final String NON_TRANSIENT_TASK_TAG = "NON-TRANSIENT";
    public static final String TRANSIENT_TASK_TAG = "TRANSIENT";
    public static final String IMMEDIATE_TASK_TAG = "IMMEDIATE";
    public static final String CONTEXT_ENTITY = "contextEntity";
    public static final String CALLER_ENTITY = "callerEntity";
    public static final String TARGET_ENTITY = "targetEntity";
    public static final String STREAM_STDIN = "stdin";
    public static final String STREAM_STDOUT = "stdout";
    public static final String STREAM_STDERR = "stderr";
    public static final String STREAM_ENV = "env";
    private static final Maybe<ByteArrayOutputStream> STREAM_GARBAGE_COLLECTED_MAYBE = Maybe.of((Object)Streams.byteArrayOfString((String)"<contents-garbage-collected>"));

    public static WrappedEntity tagForContextEntity(Entity entity) {
        return new WrappedEntity(CONTEXT_ENTITY, entity);
    }

    public static WrappedEntity tagForCallerEntity(Entity entity) {
        return new WrappedEntity(CALLER_ENTITY, entity);
    }

    public static WrappedEntity tagForTargetEntity(Entity entity) {
        return new WrappedEntity(TARGET_ENTITY, entity);
    }

    public static WrappedEntity getWrappedEntityTagOfType(Task<?> t, String wrappingType) {
        if (t == null) {
            return null;
        }
        return BrooklynTaskTags.getWrappedEntityTagOfType(t.getTags(), wrappingType);
    }

    public static WrappedEntity getWrappedEntityTagOfType(Collection<?> tags, String wrappingType) {
        for (Object x : tags) {
            if (!(x instanceof WrappedEntity) || !((WrappedEntity)x).wrappingType.equals(wrappingType)) continue;
            return (WrappedEntity)x;
        }
        return null;
    }

    public static Entity getWrappedEntityOfType(Task<?> t, String wrappingType) {
        WrappedEntity wrapper = BrooklynTaskTags.getWrappedEntityTagOfType(t, wrappingType);
        return wrapper == null ? null : wrapper.entity;
    }

    public static Entity getWrappedEntityOfType(Collection<?> tags, String wrappingType) {
        WrappedEntity wrapper = BrooklynTaskTags.getWrappedEntityTagOfType(tags, wrappingType);
        return wrapper == null ? null : wrapper.entity;
    }

    public static Entity getContextEntity(Task<?> task) {
        return BrooklynTaskTags.getWrappedEntityOfType(task, CONTEXT_ENTITY);
    }

    public static Object getTargetOrContextEntityTag(Task<?> task) {
        if (task == null) {
            return null;
        }
        WrappedEntity result = BrooklynTaskTags.getWrappedEntityTagOfType(task, CONTEXT_ENTITY);
        if (result != null) {
            return result;
        }
        result = BrooklynTaskTags.getWrappedEntityTagOfType(task, TARGET_ENTITY);
        if (result != null) {
            return result;
        }
        result = Tasks.tag(task, Entity.class, false);
        if (result != null) {
            return result;
        }
        return null;
    }

    public static Entity getTargetOrContextEntity(Task<?> t) {
        if (t == null) {
            return null;
        }
        Entity result = BrooklynTaskTags.getWrappedEntityOfType(t, CONTEXT_ENTITY);
        if (result != null) {
            return result;
        }
        result = BrooklynTaskTags.getWrappedEntityOfType(t, TARGET_ENTITY);
        if (result != null) {
            log.warn("Context entity found by looking at target entity tag, not context entity");
            return result;
        }
        result = Tasks.tag(t, Entity.class, false);
        if (result != null) {
            log.warn("Context entity found by looking at 'Entity' tag, not wrapped entity");
        }
        return result;
    }

    public static Set<Task<?>> getTasksInEntityContext(ExecutionManager em, Entity e) {
        return em.getTasksWithTag((Object)BrooklynTaskTags.tagForContextEntity(e));
    }

    public static ManagementContext getManagementContext(Task<?> task) {
        for (Object tag : task.getTags()) {
            if (!(tag instanceof ManagementContext)) continue;
            return (ManagementContext)tag;
        }
        return null;
    }

    public static WrappedStream tagForStream(String streamType, ByteArrayOutputStream stream) {
        return new WrappedStream(streamType, stream);
    }

    public static WrappedStream tagForStreamSoft(String streamType, ByteArrayOutputStream stream) {
        MemoryUsageTracker.SOFT_REFERENCES.track((Object)stream, (long)stream.size());
        Maybe weakStream = Maybe.softThen((Object)stream, STREAM_GARBAGE_COLLECTED_MAYBE);
        return new WrappedStream(streamType, (Supplier<String>)Suppliers.compose((Function)Functions.toStringFunction(), (Supplier)weakStream), (Supplier<Integer>)Suppliers.compose((Function)Streams.sizeFunction(), (Supplier)weakStream));
    }

    public static WrappedStream tagForStream(String streamType, Supplier<String> contents, Supplier<Integer> size) {
        return new WrappedStream(streamType, contents, size);
    }

    public static WrappedStream tagForEnvStream(String streamEnv, Map<?, ?> env) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> kv : env.entrySet()) {
            Object val = kv.getValue();
            sb.append(kv.getKey() + "=" + (val != null ? StringEscapes.BashStringEscapes.wrapBash((String)val.toString()) : "") + "\n");
        }
        return BrooklynTaskTags.tagForStream(STREAM_ENV, Streams.byteArrayOfString((String)sb.toString()));
    }

    public static Set<WrappedStream> streams(Task<?> task) {
        LinkedHashSet<WrappedStream> result = new LinkedHashSet<WrappedStream>();
        for (Object tag : task.getTags()) {
            if (!(tag instanceof WrappedStream)) continue;
            result.add((WrappedStream)tag);
        }
        return ImmutableSet.copyOf(result);
    }

    public static WrappedStream stream(Task<?> task, String streamType) {
        if (task == null) {
            return null;
        }
        for (Object tag : task.getTags()) {
            if (!(tag instanceof WrappedStream) || !((WrappedStream)tag).streamType.equals(streamType)) continue;
            return (WrappedStream)tag;
        }
        return null;
    }

    public static void setInessential(Task<?> task) {
        BrooklynTaskTags.addTagDynamically(task, "inessential");
    }

    public static void setTransient(Task<?> task) {
        BrooklynTaskTags.addTagDynamically(task, TRANSIENT_TASK_TAG);
    }

    public static boolean isTransient(Task<?> task) {
        if (BrooklynTaskTags.hasTag(task, TRANSIENT_TASK_TAG)) {
            return true;
        }
        if (BrooklynTaskTags.hasTag(task, NON_TRANSIENT_TASK_TAG)) {
            return false;
        }
        if (task.getSubmittedByTask() != null) {
            return BrooklynTaskTags.isTransient(task.getSubmittedByTask());
        }
        return false;
    }

    public static boolean isSubTask(Task<?> task) {
        return BrooklynTaskTags.hasTag(task, "SUB-TASK");
    }

    public static boolean isEffectorTask(Task<?> task) {
        return BrooklynTaskTags.hasTag(task, EFFECTOR_TAG);
    }

    public static EffectorCallTag tagForEffectorCall(Entity entity, String effectorName, ConfigBag parameters) {
        return new EffectorCallTag(entity.getId(), effectorName, parameters);
    }

    public static boolean isInEffectorTask(Task<?> task, @Nullable Entity entity, @Nullable Effector<?> effector, boolean allowNestedEffectorCalls) {
        for (Task t = task; t != null; t = t.getSubmittedByTask()) {
            Set tags = t.getTags();
            if (!tags.contains(EFFECTOR_TAG)) continue;
            for (Object tag : tags) {
                if (!(tag instanceof EffectorCallTag)) continue;
                EffectorCallTag et = (EffectorCallTag)tag;
                if (entity != null && !et.getEntityId().equals(entity.getId()) || effector != null && !et.getEffectorName().equals(effector.getName())) continue;
                return true;
            }
            if (allowNestedEffectorCalls) continue;
            return false;
        }
        return false;
    }

    @Beta
    public static Task<?> getClosestEffectorTask(Task<?> child, Effector<?> effector) {
        for (Task t = child; t != null; t = t.getSubmittedByTask()) {
            Set tags = t.getTags();
            if (!tags.contains(EFFECTOR_TAG)) continue;
            for (Object tag : tags) {
                if (!(tag instanceof EffectorCallTag)) continue;
                EffectorCallTag et = (EffectorCallTag)tag;
                if (effector != null && !et.getEffectorName().equals(effector.getName())) continue;
                return t;
            }
        }
        return null;
    }

    public static EffectorCallTag getEffectorCallTag(Task<?> task, boolean recurse) {
        for (Task t = task; t != null; t = t.getSubmittedByTask()) {
            for (Object tag : t.getTags()) {
                if (!(tag instanceof EffectorCallTag)) continue;
                return (EffectorCallTag)tag;
            }
            if (recurse) continue;
            return null;
        }
        return null;
    }

    public static String getEffectorName(Task<?> task) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        return result == null ? null : result.getEffectorName();
    }

    public static ConfigBag getEffectorParameters(Task<?> task) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        return result == null ? null : result.getParameters();
    }

    public static ConfigBag getCurrentEffectorParameters() {
        return BrooklynTaskTags.getEffectorParameters(Tasks.current());
    }

    public static void setEffectorParameters(Task<?> task, ConfigBag parameters) {
        EffectorCallTag result = BrooklynTaskTags.getEffectorCallTag(task, true);
        if (result == null) {
            throw new IllegalStateException("No EffectorCallTag found, is the task an effector? Task: " + task);
        }
        result.setParameters(parameters);
    }

    public static EntitlementContext getEntitlement(Task<?> task) {
        if (task == null) {
            return null;
        }
        return BrooklynTaskTags.getEntitlement(task.getTags());
    }

    public static EntitlementContext getEntitlement(Collection<?> tags) {
        if (tags == null) {
            return null;
        }
        for (Object tag : tags) {
            if (!(tag instanceof EntitlementTag)) continue;
            return ((EntitlementTag)tag).entitlementContext;
        }
        return null;
    }

    public static EntitlementContext getEntitlement(EntitlementTag tag) {
        if (tag == null) {
            return null;
        }
        return tag.entitlementContext;
    }

    public static EntitlementTag tagForEntitlement(EntitlementContext context) {
        EntitlementTag tag = new EntitlementTag();
        tag.entitlementContext = context;
        return tag;
    }

    public static class EntitlementTag {
        private EntitlementContext entitlementContext;
    }

    public static class EffectorCallTag {
        protected final String entityId;
        protected final String effectorName;
        protected transient ConfigBag parameters;

        protected EffectorCallTag(String entityId, String effectorName, ConfigBag parameters) {
            this.entityId = (String)Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
            this.effectorName = (String)Preconditions.checkNotNull((Object)effectorName, (Object)"effectorName");
            this.parameters = parameters;
        }

        public String toString() {
            return "EFFECTOR@" + this.entityId + ":" + this.effectorName;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.entityId, this.effectorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EffectorCallTag)) {
                return false;
            }
            EffectorCallTag other = (EffectorCallTag)obj;
            return Objects.equal((Object)this.entityId, (Object)other.entityId) && Objects.equal((Object)this.effectorName, (Object)other.effectorName);
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getEffectorName() {
            return this.effectorName;
        }

        public ConfigBag getParameters() {
            return this.parameters;
        }

        public void setParameters(ConfigBag parameters) {
            this.parameters = parameters;
        }
    }

    public static class WrappedStream {
        public final String streamType;
        public final Supplier<String> streamContents;
        public final Supplier<Integer> streamSize;

        protected WrappedStream(String streamType, Supplier<String> streamContents, Supplier<Integer> streamSize) {
            Preconditions.checkNotNull((Object)streamType);
            Preconditions.checkNotNull(streamContents);
            this.streamType = streamType;
            this.streamContents = streamContents;
            this.streamSize = streamSize != null ? streamSize : Suppliers.ofInstance((Object)((String)streamContents.get()).length());
        }

        protected WrappedStream(String streamType, ByteArrayOutputStream stream) {
            Preconditions.checkNotNull((Object)streamType);
            Preconditions.checkNotNull((Object)stream);
            this.streamType = streamType;
            this.streamContents = Strings.toStringSupplier((Object)stream);
            this.streamSize = Streams.sizeSupplier((ByteArrayOutputStream)stream);
        }

        @JsonProperty
        public Integer getStreamSize() {
            return (Integer)this.streamSize.get();
        }

        @JsonProperty(value="streamContents")
        public String getStreamContentsAbbreviated() {
            if ((Integer)this.streamSize.get() > 8192) {
                return "<contents-too-large>";
            }
            return Strings.maxlenWithEllipsis((String)((String)this.streamContents.get()), (int)80);
        }

        public String toString() {
            return "Stream[" + this.streamType + "/" + Strings.makeSizeString((long)((Integer)this.streamSize.get()).intValue()) + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.streamContents, this.streamType});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WrappedStream)) {
                return false;
            }
            return Objects.equal(this.streamContents, ((WrappedStream)obj).streamContents) && Objects.equal((Object)this.streamType, (Object)((WrappedStream)obj).streamType);
        }
    }

    public static class WrappedEntity {
        public final String wrappingType;
        public final Entity entity;

        protected WrappedEntity(String wrappingType, Entity entity) {
            Preconditions.checkNotNull((Object)wrappingType);
            Preconditions.checkNotNull((Object)entity);
            this.wrappingType = wrappingType;
            this.entity = entity;
        }

        public String toString() {
            return "Wrapped[" + this.wrappingType + ":" + this.entity + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.entity, this.wrappingType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WrappedEntity)) {
                return false;
            }
            return Objects.equal((Object)this.entity, (Object)((WrappedEntity)obj).entity) && Objects.equal((Object)this.wrappingType, (Object)((WrappedEntity)obj).wrappingType);
        }
    }
}

