/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.FeedMemento;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.core.mgmt.rebind.BasicFeedRebindSupport;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeed
extends AbstractEntityAdjunct
implements Feed {
    private static final Logger log = LoggerFactory.getLogger(AbstractFeed.class);
    public static final ConfigKey<Boolean> ONLY_IF_SERVICE_UP = ConfigKeys.newBooleanConfigKey("feed.onlyIfServiceUp", "", false);
    private final Object pollerStateMutex = new Object();
    private volatile transient Poller<?> poller;
    private volatile transient boolean activated;
    private volatile transient boolean suspended;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.feedRegistration")) {
            ((EntityInternal)entity).feeds().addFeed(this);
        }
    }

    protected void initUniqueTag(String uniqueTag, Object ... valsForDefault) {
        this.uniqueTag = Strings.isNonBlank((CharSequence)uniqueTag) ? uniqueTag : this.getDefaultUniqueTag(valsForDefault);
    }

    protected String getDefaultUniqueTag(Object ... valsForDefault) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaClassNames.simpleClassName((Object)this));
        if (valsForDefault.length == 0) {
            sb.append("@");
            sb.append(this.hashCode());
        } else if (valsForDefault.length == 1 && valsForDefault[0] instanceof Collection) {
            sb.append(Strings.toUniqueString((Object)valsForDefault[0], (int)80));
        } else {
            sb.append("[");
            boolean first = true;
            for (Object x : valsForDefault) {
                if (!first) {
                    sb.append(";");
                } else {
                    first = false;
                }
                sb.append(Strings.toUniqueString((Object)x, (int)80));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("Starting feed {} for {}", (Object)this, (Object)this.entity);
        }
        if (this.activated) {
            throw new IllegalStateException(String.format("Attempt to start feed %s of entity %s when already running", this, this.entity));
        }
        if (this.poller != null) {
            throw new IllegalStateException(String.format("Attempt to re-start feed %s of entity %s", this, this.entity));
        }
        this.poller = new Poller((Entity)this.entity, this, this.getConfig(ONLY_IF_SERVICE_UP));
        this.activated = true;
        this.preStart();
        Object object = this.pollerStateMutex;
        synchronized (object) {
            if (!this.suspended) {
                this.poller.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.pollerStateMutex;
        synchronized (object) {
            if (this.activated && !this.suspended) {
                this.poller.stop();
            }
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pollerStateMutex;
        synchronized (object) {
            if (this.activated && this.suspended) {
                this.poller.start();
            }
            this.suspended = false;
        }
    }

    @Override
    public void destroy() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.activated) {
            log.debug("Ignoring attempt to stop feed {} of entity {} when not running", (Object)this, (Object)this.entity);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("stopping feed {} for {}", (Object)this, (Object)this.entity);
        }
        this.activated = false;
        this.preStop();
        Object object = this.pollerStateMutex;
        synchronized (object) {
            if (!this.suspended) {
                this.poller.stop();
            }
        }
        this.postStop();
        super.destroy();
    }

    public boolean isActivated() {
        return this.activated;
    }

    public EntityLocal getEntity() {
        return this.entity;
    }

    protected boolean isConnected() {
        return this.isRunning() && this.entity != null && !((EntityInternal)this.entity).getManagementSupport().isNoLongerManaged();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public boolean isRunning() {
        return this.isActivated() && !this.isSuspended() && !this.isDestroyed() && this.getPoller() != null && this.getPoller().isRunning();
    }

    public RebindSupport<FeedMemento> getRebindSupport() {
        return new BasicFeedRebindSupport(this);
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<Feed> relations() {
        return super.relations();
    }

    @Override
    protected void onChanged() {
    }

    protected void preStart() {
    }

    protected void preStop() {
    }

    protected void postStop() {
    }

    protected Poller<?> getPoller() {
        return this.poller;
    }

    void highlightTriggerPeriod(Duration minPeriod) {
        this.highlightTriggers("Running every " + minPeriod);
    }

    void onRemoveSensor(Sensor<?> sensor) {
        this.highlightActionPublishSensor("Clear sensor " + sensor.getName());
    }

    void onPublishSensor(Sensor<?> sensor, Object v) {
        this.highlightActionPublishSensor(sensor, v);
    }
}

