/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.lifecycle;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.enricher.stock.AbstractMultipleSensorAggregator;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.task.ValueResolver;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStateLogic {
    private static final Logger log = LoggerFactory.getLogger(ServiceStateLogic.class);
    public static final AttributeSensor<Boolean> SERVICE_UP = Attributes.SERVICE_UP;
    public static final AttributeSensor<Map<String, Object>> SERVICE_NOT_UP_INDICATORS = Attributes.SERVICE_NOT_UP_INDICATORS;
    public static final AttributeSensor<Map<String, Object>> SERVICE_NOT_UP_DIAGNOSTICS = Attributes.SERVICE_NOT_UP_DIAGNOSTICS;
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Attributes.SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<Lifecycle.Transition> SERVICE_STATE_EXPECTED = Attributes.SERVICE_STATE_EXPECTED;
    public static final AttributeSensor<Map<String, Object>> SERVICE_PROBLEMS = Attributes.SERVICE_PROBLEMS;

    private ServiceStateLogic() {
    }

    public static <TKey, TVal> TVal getMapSensorEntry(Entity entity, AttributeSensor<Map<TKey, TVal>> sensor, TKey key) {
        Map map = (Map)entity.getAttribute(sensor);
        if (map == null) {
            return null;
        }
        return (TVal)map.get(key);
    }

    public static <TKey, TVal> void clearMapSensorEntry(Entity entity, AttributeSensor<Map<TKey, TVal>> sensor, TKey key) {
        ServiceStateLogic.updateMapSensorEntry(entity, sensor, key, Entities.REMOVE);
    }

    public static <TKey, TVal> void updateMapSensorEntry(Entity entity, AttributeSensor<Map<TKey, TVal>> sensor, final TKey key, final TVal v) {
        Function modifier = new Function<Map<TKey, TVal>, Maybe<Map<TKey, TVal>>>(){

            public Maybe<Map<TKey, TVal>> apply(Map<TKey, TVal> map) {
                boolean changed;
                boolean created;
                boolean bl = created = map == null;
                if (created) {
                    map = MutableMap.of();
                }
                if (v == Entities.REMOVE) {
                    changed = map.containsKey(key);
                    if (changed) {
                        map = MutableMap.copyOf((Map)map);
                        map.remove(key);
                    }
                } else {
                    Object oldV = map.get(key);
                    if (oldV == null) {
                        changed = v != null || !map.containsKey(key);
                    } else {
                        boolean bl2 = changed = !oldV.equals(v);
                    }
                    if (changed) {
                        map = MutableMap.copyOf((Map)map);
                        map.put(key, v);
                    }
                }
                if (changed || created) {
                    return Maybe.of((Object)map);
                }
                return Maybe.absent();
            }
        };
        if (!Entities.isNoLongerManaged(entity)) {
            entity.sensors().modify(sensor, modifier);
        }
    }

    public static void setExpectedState(Entity entity, Lifecycle state) {
        ServiceStateLogic.setExpectedState(entity, state, entity.getAttribute(SERVICE_STATE_ACTUAL) != null && entity.getAttribute(SERVICE_STATE_ACTUAL) != Lifecycle.ON_FIRE);
    }

    public static void setExpectedStateRunningWithErrors(Entity entity) {
        ServiceStateLogic.setExpectedState(entity, Lifecycle.RUNNING, false);
    }

    private static void setExpectedState(Entity entity, Lifecycle state, boolean waitBrieflyForServiceUpIfRunning) {
        if (waitBrieflyForServiceUpIfRunning) {
            ServiceStateLogic.waitBrieflyForServiceUpIfStateIsRunning(entity, state);
        }
        ((EntityInternal)entity).sensors().set(Attributes.SERVICE_STATE_EXPECTED, new Lifecycle.Transition(state, new Date()));
        Maybe enricher = EntityAdjuncts.tryFindWithUniqueTag(entity.enrichers(), "service.state.actual");
        if (enricher.isPresent() && enricher.get() instanceof ComputeServiceState) {
            ((ComputeServiceState)enricher.get()).onEvent(null);
        }
    }

    public static Lifecycle getExpectedState(Entity entity) {
        Lifecycle.Transition expected = (Lifecycle.Transition)entity.getAttribute(Attributes.SERVICE_STATE_EXPECTED);
        if (expected == null) {
            return null;
        }
        return expected.getState();
    }

    private static void waitBrieflyForServiceUpIfStateIsRunning(Entity entity, Lifecycle state) {
        Boolean up;
        if (state == Lifecycle.RUNNING && !Boolean.TRUE.equals(up = (Boolean)((EntityInternal)entity).getAttribute(Attributes.SERVICE_UP)) && !Boolean.TRUE.equals(Entities.isReadOnly(entity))) {
            Stopwatch timer = Stopwatch.createStarted();
            boolean nowUp = Repeater.create().every(ValueResolver.REAL_QUICK_PERIOD).limitTimeTo(ValueResolver.PRETTY_QUICK_WAIT).until((Object)entity, EntityPredicates.attributeEqualTo(Attributes.SERVICE_UP, true)).run();
            if (nowUp) {
                log.debug("Had to wait " + Duration.of((Object)timer) + " for " + entity + " " + Attributes.SERVICE_UP + " to be true before setting " + (Object)((Object)state));
            } else {
                log.warn("Service is not up when setting " + (Object)((Object)state) + " on " + entity + "; delayed " + Duration.of((Object)timer) + " but " + Attributes.SERVICE_UP + " did not recover from " + up + "; not-up-indicators=" + entity.getAttribute(Attributes.SERVICE_NOT_UP_INDICATORS));
            }
        }
    }

    public static Lifecycle getActualState(Entity entity) {
        return (Lifecycle)((Object)entity.getAttribute(Attributes.SERVICE_STATE_ACTUAL));
    }

    public static boolean isExpectedState(Entity entity, Lifecycle state) {
        return ServiceStateLogic.getExpectedState(entity) == state;
    }

    public static final EnricherSpec<?> newEnricherForServiceStateFromProblemsAndUp() {
        return ServiceStateLogic.newEnricherForServiceState(ComputeServiceState.class);
    }

    public static final EnricherSpec<?> newEnricherForServiceState(Class<? extends Enricher> type) {
        ServiceStateLogic.newEnricherForServiceUpFromChildren();
        return EnricherSpec.create(type);
    }

    public static final EnricherSpec<?> newEnricherForServiceUpFromChildren() {
        return ServiceStateLogic.newEnricherForServiceUp(Boolean.TRUE, Boolean.FALSE);
    }

    public static final EnricherSpec<?> newEnricherForServiceUpFromMembers() {
        return ServiceStateLogic.newEnricherForServiceUp(Boolean.FALSE, Boolean.TRUE);
    }

    public static final EnricherSpec<?> newEnricherForServiceUpFromChildrenWithQuorumCheck(QuorumCheck quorumCheck) {
        EnricherSpec serviceUp = (EnricherSpec)ServiceStateLogic.newEnricherForServiceUpFromChildren().configure(ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, (Object)quorumCheck);
        return serviceUp;
    }

    public static final EnricherSpec<?> newEnricherForServiceUp(Boolean fromChildren, Boolean fromMembers) {
        EnricherSpec serviceUp = (EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(ComputeServiceIndicatorsFromChildrenAndMembers.class).configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_CHILDREN, (Object)fromChildren)).configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_MEMBERS, (Object)fromMembers)).configure(ComputeServiceIndicatorsFromChildrenAndMembers.SUPPRESS_DUPLICATES, (Object)Boolean.TRUE)).configure(ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, (Object)QuorumCheck.QuorumChecks.all())).configure(ComputeServiceIndicatorsFromChildrenAndMembers.IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES, (Object)ImmutableSet.of((Object)((Object)Lifecycle.STOPPING), (Object)((Object)Lifecycle.STOPPED), (Object)((Object)Lifecycle.DESTROYED)));
        return serviceUp;
    }

    public static ComputeServiceIndicatorsFromChildrenAndMembersSpec newEnricherFromChildren() {
        return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)new ComputeServiceIndicatorsFromChildrenAndMembersSpec().uniqueTag("service-lifecycle-indicators-from-children-and-members");
    }

    public static ComputeServiceIndicatorsFromChildrenAndMembersSpec newEnricherFromChildrenUp() {
        return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)((ComputeServiceIndicatorsFromChildrenAndMembersSpec)ServiceStateLogic.newEnricherFromChildren().uniqueTag("service-not-up-indicators-from-children-and-members")).checkChildrenOnly().configure(ComputeServiceIndicatorsFromChildrenAndMembers.DERIVE_SERVICE_PROBLEMS, false);
    }

    public static ComputeServiceIndicatorsFromChildrenAndMembersSpec newEnricherFromChildrenState() {
        return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)ServiceStateLogic.newEnricherFromChildren().configure(ComputeServiceIndicatorsFromChildrenAndMembers.DERIVE_SERVICE_NOT_UP, false);
    }

    public static class ComputeServiceIndicatorsFromChildrenAndMembersSpec
    extends EnricherSpec.ExtensibleEnricherSpec<ComputeServiceIndicatorsFromChildrenAndMembers, ComputeServiceIndicatorsFromChildrenAndMembersSpec> {
        private static final long serialVersionUID = -607444925297963712L;

        protected ComputeServiceIndicatorsFromChildrenAndMembersSpec() {
            this(ComputeServiceIndicatorsFromChildrenAndMembers.class);
        }

        protected ComputeServiceIndicatorsFromChildrenAndMembersSpec(Class<? extends ComputeServiceIndicatorsFromChildrenAndMembers> clazz) {
            super(clazz);
        }

        public void addTo(Entity entity) {
            entity.enrichers().add((EnricherSpec)this);
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec suppressDuplicates(boolean val) {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.SUPPRESS_DUPLICATES, val);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec checkChildrenAndMembers() {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_MEMBERS, true);
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_CHILDREN, true);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec checkMembersOnly() {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_MEMBERS, true);
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_CHILDREN, false);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec checkChildrenOnly() {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_MEMBERS, false);
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.FROM_CHILDREN, true);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec requireUpChildren(QuorumCheck check) {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.UP_QUORUM_CHECK, check);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec requireRunningChildren(QuorumCheck check) {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, check);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }

        public ComputeServiceIndicatorsFromChildrenAndMembersSpec entityFilter(Predicate<? super Entity> val) {
            this.configure(ComputeServiceIndicatorsFromChildrenAndMembers.ENTITY_FILTER, val);
            return (ComputeServiceIndicatorsFromChildrenAndMembersSpec)this.self();
        }
    }

    public static class ComputeServiceIndicatorsFromChildrenAndMembers
    extends AbstractMultipleSensorAggregator<Void>
    implements SensorEventListener<Object> {
        public static final String DEFAULT_UNIQUE_TAG = "service-lifecycle-indicators-from-children-and-members";
        public static final String DEFAULT_UNIQUE_TAG_UP = "service-not-up-indicators-from-children-and-members";
        public static final ConfigKey<QuorumCheck> UP_QUORUM_CHECK = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(QuorumCheck.class, "enricher.service_state.children_and_members.quorum.up").description("Logic for checking whether this service is up, based on children and/or members, defaulting to allowing none but if there are any requiring at least one to be up")).defaultValue((QuorumCheck)QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty())).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
        public static final ConfigKey<QuorumCheck> RUNNING_QUORUM_CHECK = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(QuorumCheck.class, "enricher.service_state.children_and_members.quorum.running").description("Logic for checking whether this service is healthy, based on children and/or members running, defaulting to requiring none to be ON-FIRE")).defaultValue((QuorumCheck)QuorumCheck.QuorumChecks.all())).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
        public static final ConfigKey<Boolean> DERIVE_SERVICE_NOT_UP = ConfigKeys.newBooleanConfigKey("enricher.service_state.children_and_members.service_up.publish", "Whether to derive a service-not-up indicator from children", true);
        public static final ConfigKey<Boolean> DERIVE_SERVICE_PROBLEMS = ConfigKeys.newBooleanConfigKey("enricher.service_state.children_and_members.service_problems.publish", "Whether to derive a service-problem indicator from children", true);
        public static final ConfigKey<Boolean> IGNORE_ENTITIES_WITH_SERVICE_UP_NULL = ConfigKeys.newBooleanConfigKey("enricher.service_state.children_and_members.ignore_entities.service_up_null", "Whether to ignore children reporting null values for service up", true);
        public static final ConfigKey<Set<Lifecycle>> IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES = ConfigKeys.newConfigKey(new TypeToken<Set<Lifecycle>>(){}, "enricher.service_state.children_and_members.ignore_entities.service_state_values", "Service states (including null) which indicate an entity should be ignored when looking at children service states; anything apart from RUNNING not in this list will be treated as not healthy (by default just ON_FIRE will mean not healthy)", MutableSet.builder().addAll((Object[])Lifecycle.values()).add(null).remove((Object)Lifecycle.RUNNING).remove((Object)Lifecycle.ON_FIRE).build().asUnmodifiable());
        static final Set<ConfigKey<?>> RECONFIGURABLE_KEYS = ImmutableSet.of(UP_QUORUM_CHECK, RUNNING_QUORUM_CHECK, DERIVE_SERVICE_NOT_UP, DERIVE_SERVICE_NOT_UP, IGNORE_ENTITIES_WITH_SERVICE_UP_NULL, IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES, (Object[])new ConfigKey[0]);
        private final List<Sensor<?>> SOURCE_SENSORS = ImmutableList.of(SERVICE_UP, SERVICE_STATE_ACTUAL);

        protected String getKeyForMapSensor() {
            return (String)Preconditions.checkNotNull((Object)super.getUniqueTag());
        }

        @Override
        protected void setEntityLoadingConfig() {
            this.fromChildren = true;
            this.fromMembers = true;
            super.setEntityLoadingConfig();
            if (this.isAggregatingMembers() && !(this.entity instanceof Group)) {
                if (this.fromChildren.booleanValue()) {
                    this.fromMembers = false;
                } else {
                    throw new IllegalStateException("Cannot monitor only members for non-group entity " + this.entity + ": " + this);
                }
            }
            Preconditions.checkNotNull((Object)this.getKeyForMapSensor());
        }

        @Override
        protected void setEntityLoadingTargetConfig() {
            if (this.getConfig(TARGET_SENSOR) != null) {
                throw new IllegalArgumentException("Must not set " + TARGET_SENSOR + " when using " + this);
            }
        }

        @Override
        public void setEntity(EntityLocal entity) {
            super.setEntity(entity);
            if (this.suppressDuplicates == null) {
                this.suppressDuplicates = true;
            }
        }

        @Override
        protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
            if (RECONFIGURABLE_KEYS.contains(key)) {
                return;
            }
            super.doReconfigureConfig(key, val);
        }

        @Override
        protected void onChanged() {
            super.onChanged();
            if (this.entity != null && this.isRunning()) {
                this.onUpdated();
            }
        }

        @Override
        protected Collection<Sensor<?>> getSourceSensors() {
            return this.SOURCE_SENSORS;
        }

        @Override
        protected void onUpdated() {
            if (this.entity == null || !Entities.isManaged((Entity)this.entity)) {
                BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)this.entity), "Ignoring {} onUpdated when entity is not in valid state ({})", this, this.entity);
                return;
            }
            if (this.getConfig(DERIVE_SERVICE_PROBLEMS).booleanValue()) {
                this.updateMapSensor(SERVICE_PROBLEMS, this.computeServiceProblems());
            }
            if (this.getConfig(DERIVE_SERVICE_NOT_UP).booleanValue()) {
                this.updateMapSensor(SERVICE_NOT_UP_INDICATORS, this.computeServiceNotUp());
            }
        }

        protected Object computeServiceNotUp() {
            Map<Entity, Boolean> values = this.getValues(SERVICE_UP);
            MutableList violators = MutableList.of();
            boolean ignoreNull = this.getConfig(IGNORE_ENTITIES_WITH_SERVICE_UP_NULL);
            Set<Lifecycle> ignoreStates = this.getConfig(IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES);
            int entries = 0;
            int numUp = 0;
            for (Map.Entry<Entity, Boolean> state : values.entrySet()) {
                if (ignoreNull && state.getValue() == null) continue;
                ++entries;
                Lifecycle entityState = (Lifecycle)((Object)state.getKey().getAttribute(SERVICE_STATE_ACTUAL));
                if (Boolean.TRUE.equals(state.getValue())) {
                    ++numUp;
                    continue;
                }
                if (ignoreStates.contains((Object)entityState)) continue;
                violators.add(state.getKey());
            }
            QuorumCheck qc = this.getConfig(UP_QUORUM_CHECK);
            if (qc != null) {
                if (qc.isQuorate(numUp, violators.size() + numUp)) {
                    return null;
                }
                if (values.isEmpty()) {
                    return "No entities present";
                }
                if (entries == 0) {
                    return "No entities publishing service up";
                }
                if (violators.isEmpty()) {
                    return "Not enough entities";
                }
            } else if (violators.isEmpty()) {
                return null;
            }
            if (violators.size() == 1) {
                return violators.get(0) + " is not up";
            }
            if (violators.size() == entries) {
                return "None of the entities are up";
            }
            return violators.size() + " entities are not up, including " + violators.get(0);
        }

        protected Object computeServiceProblems() {
            Map<Entity, Lifecycle> values = this.getValues(SERVICE_STATE_ACTUAL);
            int numRunning = 0;
            MutableList onesNotHealthy = MutableList.of();
            Set<Lifecycle> ignoreStates = this.getConfig(IGNORE_ENTITIES_WITH_THESE_SERVICE_STATES);
            for (Map.Entry<Entity, Lifecycle> state : values.entrySet()) {
                if (state.getValue() == Lifecycle.RUNNING) {
                    ++numRunning;
                    continue;
                }
                if (ignoreStates.contains((Object)state.getValue())) continue;
                onesNotHealthy.add(state.getKey());
            }
            QuorumCheck qc = this.getConfig(RUNNING_QUORUM_CHECK);
            if (qc != null) {
                if (qc.isQuorate(numRunning, onesNotHealthy.size() + numRunning)) {
                    return null;
                }
                if (onesNotHealthy.isEmpty()) {
                    return "Not enough entities running to be quorate";
                }
            } else if (onesNotHealthy.isEmpty()) {
                return null;
            }
            return "Required entit" + Strings.ies((int)onesNotHealthy.size()) + " not healthy: " + (onesNotHealthy.size() > 3 ? this.nameOfEntity((Entity)onesNotHealthy.get(0)) + " and " + (onesNotHealthy.size() - 1) + " others" : Strings.join(this.nameOfEntity((List<Entity>)onesNotHealthy), (String)", "));
        }

        private List<String> nameOfEntity(List<Entity> entities) {
            MutableList result = MutableList.of();
            for (Entity e : entities) {
                result.add(this.nameOfEntity(e));
            }
            return result;
        }

        private String nameOfEntity(Entity entity) {
            String name = entity.getDisplayName();
            if (name.contains(entity.getId())) {
                return name;
            }
            return name + " (" + entity.getId() + ")";
        }

        protected void updateMapSensor(AttributeSensor<Map<String, Object>> sensor, Object value) {
            if (log.isTraceEnabled()) {
                log.trace("{} updating map sensor {} with {}", new Object[]{this, sensor, value});
            }
            if (value != null) {
                ServiceStateLogic.updateMapSensorEntry((Entity)this.entity, sensor, this.getKeyForMapSensor(), value);
            } else {
                ServiceStateLogic.clearMapSensorEntry((Entity)this.entity, sensor, this.getKeyForMapSensor());
            }
        }

        @Override
        protected Object compute() {
            return null;
        }
    }

    public static class ServiceProblemsLogic {
        private ServiceProblemsLogic() {
        }

        public static void updateProblemsIndicator(Entity entity, Sensor<?> sensor, Object value) {
            ServiceStateLogic.updateMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, sensor.getName(), value);
        }

        public static void clearProblemsIndicator(Entity entity, Sensor<?> sensor) {
            ServiceStateLogic.clearMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, sensor.getName());
        }

        public static void updateProblemsIndicator(Entity entity, Effector<?> eff, Object value) {
            ServiceStateLogic.updateMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, eff.getName(), value);
        }

        public static void clearProblemsIndicator(Entity entity, Effector<?> eff) {
            ServiceStateLogic.clearMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, eff.getName());
        }

        public static void updateProblemsIndicator(Entity entity, String key, Object value) {
            ServiceStateLogic.updateMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, key, value);
        }

        public static void clearProblemsIndicator(Entity entity, String key) {
            ServiceStateLogic.clearMapSensorEntry(entity, Attributes.SERVICE_PROBLEMS, key);
        }
    }

    public static class ComputeServiceState
    extends AbstractEnricher
    implements SensorEventListener<Object> {
        private static final Logger log = LoggerFactory.getLogger(ComputeServiceState.class);
        public static final String DEFAULT_ENRICHER_UNIQUE_TAG = "service.state.actual";
        private final AtomicInteger warnCounter = new AtomicInteger();

        @Override
        public void init() {
            super.init();
            if (this.uniqueTag == null) {
                this.uniqueTag = DEFAULT_ENRICHER_UNIQUE_TAG;
            }
        }

        @Override
        public void setEntity(EntityLocal entity) {
            super.setEntity(entity);
            if (this.suppressDuplicates == null) {
                this.suppressDuplicates = true;
            }
            ImmutableMap notifyOfInitialValue = ImmutableMap.of((Object)"notifyOfInitialValue", (Object)Boolean.TRUE);
            this.subscriptions().subscribe((Map<String, ?>)notifyOfInitialValue, (Entity)entity, SERVICE_PROBLEMS, this);
            this.subscriptions().subscribe((Map<String, ?>)notifyOfInitialValue, (Entity)entity, SERVICE_UP, this);
            this.subscriptions().subscribe((Map<String, ?>)notifyOfInitialValue, (Entity)entity, SERVICE_STATE_EXPECTED, this);
            this.highlightTriggers(MutableList.of(SERVICE_PROBLEMS, SERVICE_UP, (Object[])new AttributeSensor[]{SERVICE_STATE_EXPECTED}), null);
        }

        public void onEvent(@Nullable SensorEvent<Object> event) {
            Preconditions.checkNotNull((Object)this.entity, (Object)"Cannot handle subscriptions or compute state until associated with an entity");
            Map serviceProblems = (Map)this.entity.getAttribute(SERVICE_PROBLEMS);
            Boolean serviceUp = (Boolean)this.entity.getAttribute(SERVICE_UP);
            Lifecycle.Transition serviceExpected = (Lifecycle.Transition)this.entity.getAttribute(SERVICE_STATE_EXPECTED);
            if (serviceExpected != null && serviceExpected.getState() == Lifecycle.RUNNING) {
                this.setActualState(this.computeActualStateWhenExpectedRunning(serviceProblems, serviceUp));
            } else {
                this.setActualState(this.computeActualStateWhenNotExpectedRunning(serviceProblems, serviceUp, serviceExpected));
            }
        }

        protected Maybe<Lifecycle> computeActualStateWhenExpectedRunning(Map<String, Object> problems, Boolean serviceUp) {
            if (Boolean.TRUE.equals(serviceUp) && (problems == null || problems.isEmpty())) {
                return Maybe.of((Object)((Object)Lifecycle.RUNNING));
            }
            if (!Lifecycle.ON_FIRE.equals(this.entity.getAttribute(SERVICE_STATE_ACTUAL))) {
                BrooklynLogging.log(log, BrooklynLogging.levelDependingIfReadOnly((Entity)this.entity, BrooklynLogging.LoggingLevel.WARN, BrooklynLogging.LoggingLevel.TRACE, BrooklynLogging.LoggingLevel.DEBUG), "Setting " + this.entity + " " + (Object)((Object)Lifecycle.ON_FIRE) + " due to problems when expected running, up=" + serviceUp + ", " + (problems == null || problems.isEmpty() ? "not-up-indicators: " + this.entity.getAttribute(SERVICE_NOT_UP_INDICATORS) : "problems: " + problems), new Object[0]);
            }
            return Maybe.of((Object)((Object)Lifecycle.ON_FIRE));
        }

        protected Maybe<Lifecycle> computeActualStateWhenNotExpectedRunning(Map<String, Object> problems, Boolean up, Lifecycle.Transition stateTransition) {
            if (stateTransition != null) {
                return Maybe.of((Object)((Object)stateTransition.getState()));
            }
            if (problems != null && !problems.isEmpty()) {
                if (Boolean.FALSE.equals(up)) {
                    return Maybe.of((Object)((Object)Lifecycle.STOPPED));
                }
                BrooklynLogging.log(log, BrooklynLogging.levelDependingIfReadOnly((Entity)this.entity, BrooklynLogging.LoggingLevel.WARN, BrooklynLogging.LoggingLevel.TRACE, BrooklynLogging.LoggingLevel.DEBUG), "Setting " + this.entity + " " + (Object)((Object)Lifecycle.ON_FIRE) + " due to problems when expected " + stateTransition + " / up=" + up + ": " + problems, new Object[0]);
                return Maybe.of((Object)((Object)Lifecycle.ON_FIRE));
            }
            if (problems != null) {
                return Maybe.of(up == null ? null : (up != false ? Lifecycle.RUNNING : Lifecycle.STOPPED));
            }
            return Maybe.absent();
        }

        protected void setActualState(Maybe<Lifecycle> state) {
            if (log.isTraceEnabled()) {
                log.trace("{} setting actual state {}", (Object)this, state);
            }
            if (((EntityInternal)this.entity).getManagementSupport().isNoLongerManaged()) {
                BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)this.entity), this.entity + " is no longer managed when told to set actual state to " + state + "; suppressing", new Object[0]);
                return;
            }
            Object newVal = state.isAbsent() ? Entities.UNCHANGED : (state.get() == null ? Entities.REMOVE : state.get());
            this.emit(SERVICE_STATE_ACTUAL, newVal);
        }
    }

    public static class ServiceNotUpLogic {
        public static final String DEFAULT_ENRICHER_UNIQUE_TAG = "service.isUp if no service.notUp.indicators";

        private ServiceNotUpLogic() {
        }

        public static final EnricherSpec<?> newEnricherForServiceUpIfNotUpIndicatorsEmpty() {
            return ((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)Enrichers.builder().transforming((AttributeSensor)SERVICE_NOT_UP_INDICATORS).publishing((AttributeSensor)Attributes.SERVICE_UP).suppressDuplicates(true)).computing(Functionals.ifNotEquals(null).apply(Functions.forPredicate((Predicate)CollectionFunctionals.mapSizeEquals((int)0))).defaultValue(Entities.UNCHANGED))).uniqueTag(DEFAULT_ENRICHER_UNIQUE_TAG)).build();
        }

        public static void updateNotUpIndicator(Entity entity, String key, Object value) {
            ServiceStateLogic.updateMapSensorEntry(entity, Attributes.SERVICE_NOT_UP_INDICATORS, key, value);
        }

        public static void clearNotUpIndicator(Entity entity, String key) {
            ServiceStateLogic.clearMapSensorEntry(entity, Attributes.SERVICE_NOT_UP_INDICATORS, key);
        }

        public static void updateNotUpIndicator(Entity entity, Sensor<?> sensor, Object value) {
            ServiceStateLogic.updateMapSensorEntry(entity, Attributes.SERVICE_NOT_UP_INDICATORS, sensor.getName(), value);
        }

        public static void clearNotUpIndicator(Entity entity, Sensor<?> sensor) {
            ServiceStateLogic.clearMapSensorEntry(entity, Attributes.SERVICE_NOT_UP_INDICATORS, sensor.getName());
        }

        public static void updateNotUpIndicatorRequiringNonEmptyList(Entity entity, AttributeSensor<? extends Collection<?>> collectionSensor) {
            Collection nodes = (Collection)entity.getAttribute(collectionSensor);
            if (nodes == null || nodes.isEmpty()) {
                ServiceNotUpLogic.updateNotUpIndicator(entity, collectionSensor, (Object)"Should have at least one entry");
            } else {
                ServiceNotUpLogic.clearNotUpIndicator(entity, collectionSensor);
            }
        }

        public static void updateNotUpIndicatorRequiringNonEmptyMap(Entity entity, AttributeSensor<? extends Map<?, ?>> mapSensor) {
            Map nodes = (Map)entity.getAttribute(mapSensor);
            if (nodes == null || nodes.isEmpty()) {
                ServiceNotUpLogic.updateNotUpIndicator(entity, mapSensor, (Object)"Should have at least one entry");
            } else {
                ServiceNotUpLogic.clearNotUpIndicator(entity, mapSensor);
            }
        }
    }
}

