/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ConfigKeySelfExtracting;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;

public class EntityInitializers {
    public static EntityInitializer addingTags(Object ... tags) {
        return new AddTags(tags);
    }

    public static <T> T resolve(ConfigBag configBag, ConfigKey<T> key) {
        return EntityInitializers.resolve(configBag, key, BasicExecutionContext.getCurrentExecutionContext());
    }

    public static <T> T resolve(ConfigBag configBag, ConfigKey<T> key, ExecutionContext executionContext) {
        if (key instanceof ConfigKeySelfExtracting && executionContext != null) {
            ConfigKeySelfExtracting ckse = (ConfigKeySelfExtracting)key;
            return ckse.extractValue(configBag.getAllConfigAsConfigKeyMap(), executionContext);
        }
        return configBag.get(key);
    }

    public static class AddTags
    implements EntityInitializer {
        public final List<Object> tags;

        public AddTags(Object ... tags) {
            this.tags = ImmutableList.copyOf((Object[])tags);
        }

        public void apply(EntityLocal entity) {
            for (Object tag : this.tags) {
                entity.tags().addTag(tag);
            }
        }
    }
}

