/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;

public class EntityAndAttribute<T>
implements Supplier<T> {
    private final Entity entity;
    private final AttributeSensor<T> attribute;

    public static <T> EntityAndAttribute<T> create(Entity entity, AttributeSensor<T> attribute) {
        return new EntityAndAttribute<T>(entity, attribute);
    }

    @Deprecated
    public static <T> EntityAndAttribute<T> supplier(Entity entity, AttributeSensor<T> attribute) {
        return EntityAndAttribute.create(entity, attribute);
    }

    public EntityAndAttribute(Entity entity, AttributeSensor<T> attribute) {
        this.entity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.attribute = (AttributeSensor)Preconditions.checkNotNull(attribute, (Object)"attribute");
    }

    public Entity getEntity() {
        return this.entity;
    }

    public AttributeSensor<T> getAttribute() {
        return this.attribute;
    }

    public T getValue() {
        return (T)this.entity.getAttribute(this.attribute);
    }

    public void setValue(T val) {
        this.entity.sensors().set(this.attribute, val);
    }

    public T get() {
        return this.getValue();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", (Object)this.entity).add("attribute", this.attribute).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entity, this.attribute});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EntityAndAttribute)) {
            return false;
        }
        EntityAndAttribute that = (EntityAndAttribute)o;
        return Objects.equal((Object)this.entity, (Object)that.entity) && Objects.equal(this.attribute, that.attribute);
    }
}

